/*
 * Decompiled with CFR 0.152.
 */
package com.wily.zos.common;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.agent.stat.IIntegerFluctuatingCounterDataAccumulator;
import com.wily.introscope.agent.stat.ILongAverageDataAccumulator;
import com.wily.introscope.agent.stat.ILongFluctuatingCounterDataAccumulator;
import com.wily.introscope.agent.stat.ILongIntervalCounterDataAccumulator;
import com.wily.introscope.agent.stat.IStringEveryEventDataAccumulator;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.zos.common.Tracer;

public final class MetricWriter {
    private DataAccumulatorFactory factory;

    public MetricWriter(Tracer tracer) {
        this.factory = tracer.getFactory();
    }

    public MetricWriter(IAgent agent) {
        this.factory = agent.IAgent_getDataAccumulatorFactory();
    }

    public MetricWriter(DataAccumulatorFactory factory) {
        this.factory = factory;
    }

    public void writeLong(String metricName, long value) {
        ILongFluctuatingCounterDataAccumulator accumulator = this.longAccumulator(metricName);
        if (this.isOn((IDataAccumulator)accumulator)) {
            accumulator.ILongCounterDataAccumulator_setValue(value);
        }
    }

    public void writeInt(String metricName, int value) {
        IIntegerFluctuatingCounterDataAccumulator accumulator = this.intAccumulator(metricName);
        if (this.isOn((IDataAccumulator)accumulator)) {
            accumulator.IIntegerCounterDataAccumulator_setValue(value);
        }
    }

    public void writeLongDelta(String metricName, long value) {
        ILongFluctuatingCounterDataAccumulator accumulator = this.longAccumulator(metricName);
        if (this.isOn((IDataAccumulator)accumulator)) {
            accumulator.ILongFluctuatingCounterDataAccumulator_add(value);
        }
    }

    public void writeIntDelta(String metricName, int value) {
        IIntegerFluctuatingCounterDataAccumulator accumulator = this.intAccumulator(metricName);
        if (this.isOn((IDataAccumulator)accumulator)) {
            accumulator.IIntegerFluctuatingCounterDataAccumulator_add(value);
        }
    }

    public void writeString(String metricName, String value) {
        IStringEveryEventDataAccumulator accumulator = this.stringAccumulator(metricName);
        if (this.isOn((IDataAccumulator)accumulator)) {
            accumulator.IStringEveryEventDataAccumulator_addString(value);
        }
    }

    public void writeAverageResponseTime(String metricName, long value) {
        ILongAverageDataAccumulator accumulator = this.averageAccumulator(metricName);
        if (this.isOn((IDataAccumulator)accumulator)) {
            accumulator.ILongAggregatingDataAccumulator_recordDataPoint(value);
        }
    }

    public void writeResponsesPerInterval(String metricName) {
        ILongIntervalCounterDataAccumulator accumulator = this.intervalAccumulator(metricName);
        if (this.isOn((IDataAccumulator)accumulator)) {
            accumulator.ILongIntervalCounterDataAccumulator_addSingleIncident();
        }
    }

    public void increment(String metricName) {
        this.incrementLong(metricName);
    }

    public void incrementLong(String metricName) {
        this.writeLongDelta(metricName, 1L);
    }

    public void incrementInt(String metricName) {
        this.writeIntDelta(metricName, 1);
    }

    public void decrement(String metricName) {
        this.decrementLong(metricName);
    }

    public void decrementLong(String metricName) {
        this.writeLongDelta(metricName, -1L);
    }

    public void decrementInt(String metricName) {
        this.writeIntDelta(metricName, -1);
    }

    public AgentMetric longMetric(String metricName) {
        return this.longAccumulator(metricName).IDataAccumulator_getMetric();
    }

    public AgentMetric intMetric(String metricName) {
        return this.intAccumulator(metricName).IDataAccumulator_getMetric();
    }

    public AgentMetric stringMetric(String metricName) {
        return this.stringAccumulator(metricName).IDataAccumulator_getMetric();
    }

    public AgentMetric averageMetric(String metricName) {
        return this.averageAccumulator(metricName).IDataAccumulator_getMetric();
    }

    public AgentMetric intervalMetric(String metricName) {
        return this.intervalAccumulator(metricName).IDataAccumulator_getMetric();
    }

    private IIntegerFluctuatingCounterDataAccumulator intAccumulator(String metricName) {
        return this.factory.safeGetIntegerFluctuatingCounterDataAccumulator(metricName);
    }

    private ILongFluctuatingCounterDataAccumulator longAccumulator(String metricName) {
        return this.factory.safeGetLongFluctuatingCounterDataAccumulator(metricName);
    }

    private IStringEveryEventDataAccumulator stringAccumulator(String metricName) {
        return this.factory.safeGetStringEveryEventDataAccumulator(metricName);
    }

    private ILongAverageDataAccumulator averageAccumulator(String metricName) {
        return this.factory.safeGetLongAverageDataAccumulator(metricName);
    }

    private ILongIntervalCounterDataAccumulator intervalAccumulator(String metricName) {
        return this.factory.safeGetLongIntervalCounterDataAccumulator(metricName);
    }

    private boolean isOn(IDataAccumulator accumulator) {
        return !accumulator.IDataAccumulator_isShutOff();
    }
}

