/*
 * Decompiled with CFR 0.152.
 */
package com.wily.zos.common;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.hc2.BlamePointTracer;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.properties.AttributeListing;
import com.wily.zos.common.Listener;
import com.wily.zos.common.Tools;
import java.util.ArrayList;
import java.util.List;

public abstract class Tracer
extends BlamePointTracer {
    private static final String LISTENERS_DATA_KEY = "LISTENERS";
    private String dataKey;
    private Class[] allListeners = this.getListeners();

    public Tracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object object) {
        super(agent, parameters, probe, object);
        this.dataKey = Tools.uniqueDataKey((Object)this);
    }

    protected abstract Class[] getListeners();

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        List<Listener> listeners = this.listenersFor(data);
        data.put(this.dataKey, listeners);
        for (Listener listener : listeners) {
            listener.start(data);
        }
    }

    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        List listeners = (List)data.get(this.dataKey);
        for (Listener listener : listeners) {
            listener.finish(data);
        }
    }

    private List<Listener> listenersFor(InvocationData data) {
        ArrayList<Listener> listeners = new ArrayList<Listener>();
        Class[] classArray = this.allListeners;
        int n = this.allListeners.length;
        int n2 = 0;
        while (n2 < n) {
            Class cls = classArray[n2];
            try {
                Listener listener = Listener.getInstance(cls, this, data);
                if (listener.isInterested()) {
                    listeners.add(listener);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++n2;
        }
        return listeners;
    }

    protected DataAccumulatorFactory getFactory() {
        return this.getAgent().IAgent_getDataAccumulatorFactory();
    }

    protected IModuleFeedbackChannel getFeedback() {
        return this.getAgent().IAgent_getModuleFeedback();
    }

    protected String pbdMetricNameFor(InvocationData data) {
        return this.formatParameterizedName(data);
    }
}

