/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.agent.jaxrs;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.IInvocationDataParameterCallback;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.hc2.BlamePointTracer;
import com.wily.util.properties.AttributeListing;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class JaxrsTracer
extends BlamePointTracer
implements IInvocationDataParameterCallback {
    final IAgent fAgent;
    public static final String PATH_ANNOTATION = "@javax.ws.rs.Path";
    public static HashMap<String, String> methodAnnotationToNameMap = new HashMap();
    public static final String NAMESPACE_PARAM_KEY = "namespace";
    public static final String OPERATIONNAME_PARAM_KEY = "operationname";
    public static final String HTTPMETHOD_PARAM_KEY = "HTTP RESTful Method";
    public String namespace = "";
    public String method = "";
    public String httpRESTfulMethod = "";

    static {
        methodAnnotationToNameMap.put("@javax.ws.rs.GET()", "GET");
        methodAnnotationToNameMap.put("@javax.ws.rs.POST()", "POST");
        methodAnnotationToNameMap.put("@javax.ws.rs.PUT()", "PUT");
        methodAnnotationToNameMap.put("@javax.ws.rs.DELETE()", "DELETE");
        methodAnnotationToNameMap.put("@javax.ws.rs.HEAD()", "HEAD");
    }

    public JaxrsTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.fAgent = agent;
        this.namespace = this.getPath(sampleTracedObject, probe);
        this.method = probe.getProbeMethodName();
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        data.put(NAMESPACE_PARAM_KEY, (Object)this.namespace);
        data.put(OPERATIONNAME_PARAM_KEY, (Object)this.method);
        if (!data.isParameterCallbackInitialized()) {
            data.setParameterCallback((IInvocationDataParameterCallback)this);
        }
        super.ITracer_startTrace(tracerIndex, data);
    }

    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        super.ITracer_finishTrace(tracerIndex, data);
    }

    public void IInvocationDataParameterCallback_addParameters(InvocationData data, Map parameters) {
        parameters.put(NAMESPACE_PARAM_KEY, this.namespace);
        parameters.put(OPERATIONNAME_PARAM_KEY, this.method);
        parameters.put(HTTPMETHOD_PARAM_KEY, this.httpRESTfulMethod);
    }

    public String getPath(Object invocationObject, ProbeIdentification probe) {
        Method[] methods;
        String methodName = probe.getProbeMethodName();
        String methodDescriptor = probe.getProbeMethodDescriptor();
        StringBuilder path = new StringBuilder();
        path = this.buildPathAndMethod(path, invocationObject.getClass().getAnnotations());
        Method[] methodArray = methods = invocationObject.getClass().getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            String thisMethodName = method.getName();
            String thisMethodDescriptor = JaxrsTracer.getMethodDescriptor(method);
            if (thisMethodName.equals(methodName) && thisMethodDescriptor.equals(methodDescriptor)) {
                this.buildPathAndMethod(path, method.getAnnotations());
                break;
            }
            ++n2;
        }
        return path.toString();
    }

    public StringBuilder buildPathAndMethod(StringBuilder urlPath, Annotation[] annotations) {
        Annotation[] annotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            String stringRep = annotation.toString();
            if (stringRep.startsWith(PATH_ANNOTATION)) {
                StringBuilder rep = new StringBuilder(stringRep);
                int equal = rep.indexOf("=");
                int end = rep.indexOf(")");
                urlPath.append(rep.substring(equal + 1, end));
            } else if (methodAnnotationToNameMap.containsKey(stringRep)) {
                this.httpRESTfulMethod = methodAnnotationToNameMap.get(stringRep);
            }
            ++n2;
        }
        return urlPath;
    }

    public static String getMethodDescriptor(Method method) {
        StringBuilder s = new StringBuilder();
        s.append("(");
        Class<?>[] classArray = method.getParameterTypes();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> c = classArray[n2];
            s.append(JaxrsTracer.getDescriptorForClass(c));
            ++n2;
        }
        s.append(")");
        return s.append(JaxrsTracer.getDescriptorForClass(method.getReturnType())).toString();
    }

    public static String getDescriptorForClass(Class c) {
        if (c.isPrimitive()) {
            if (c == Byte.TYPE) {
                return "B";
            }
            if (c == Character.TYPE) {
                return "C";
            }
            if (c == Double.TYPE) {
                return "D";
            }
            if (c == Float.TYPE) {
                return "F";
            }
            if (c == Integer.TYPE) {
                return "I";
            }
            if (c == Long.TYPE) {
                return "J";
            }
            if (c == Short.TYPE) {
                return "S";
            }
            if (c == Boolean.TYPE) {
                return "Z";
            }
            if (c == Void.TYPE) {
                return "V";
            }
        }
        if (c.isArray()) {
            return c.getName().replace('.', '/');
        }
        return (String.valueOf('L') + c.getName() + ';').replace('.', '/');
    }
}

