/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.spec.server.transactiontrace.GUIDGenerator;
import com.wily.powerpack.webservices.KConstants;
import com.wily.util.IConfigurationListener;
import com.wily.util.StringUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.feedback.SeverityLevel;
import com.wily.util.finder.IResourceFinderFeedback;
import com.wily.util.io.ExtendedFile;
import com.wily.util.properties.IndexedProperties;
import com.wily.util.properties.hot.ConfigurationProperty;
import com.wily.util.properties.hot.EnumConfigurationProperty;
import com.wily.util.resource.FileBasedResource;
import com.wily.util.resource.IResource;
import com.wily.util.text.IStringLocalizer;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;

public class WSMUtils
implements KConstants {
    public static final int SERVER_OBSERVATION_TYPE = 1;
    public static final int CLIENT_OBSERVATION_TYPE = 2;
    public static HashMap wsdmClassLoaders = new HashMap();
    public static Boolean wsdmClassLoaderLoaded = Boolean.FALSE;
    public static final String axisJaxRPCHander = "com.wily.powerpack.webservices.handlers.axis.WsdmJaxRpcHandler";
    public static final String customClassloaderJar = "WebServicesAgent.jar";
    public static final String kComWilyGUIDGeneratorSeeder = "com.wily.GUIDGenerator.seeder";
    public static boolean debugLogging = false;
    public static boolean infoLogging = false;
    public static boolean warnLogging = false;
    private static final Module kModule = new Module("SPM");
    private static ClassLoader wilyClassLoader;
    private static Object wsdmProviderProtocol;
    private static Object wsdmClientProtocol;
    private static Object wsdmRpcClientProtocol;
    private static CxfClearOldHeadersProperty fCxfClearOldHeadersProperty;
    private static final String kLineSeparatorPropertyName = "line.separator";
    private static ProtectedLogger sLogger;
    private static GUIDGenerator sGlobalIDGenerator;
    private static Map methodCache;
    private static Map fieldCache;

    static {
        fCxfClearOldHeadersProperty = null;
        sLogger = new ProtectedLogger();
        sGlobalIDGenerator = WSMUtils.getGUIDGenerator();
        methodCache = null;
        fieldCache = null;
    }

    public static Object getWsdmRpcClientProtocol() {
        return wsdmRpcClientProtocol;
    }

    public static void setWsdmRpcClientProtocol(Object wsdmRpcClientProtocol) {
        WSMUtils.wsdmRpcClientProtocol = wsdmRpcClientProtocol;
    }

    public static IResource getDirFinder(String directoryName, String fileName) {
        ExtendedFile wilyDirectory = new ExtendedFile(directoryName);
        String fullPath = new ExtendedFile(wilyDirectory, fileName).safeGetCanonicalPath();
        return new FileBasedResource(fullPath);
    }

    public static boolean correlationEnabled() {
        try {
            return WSMUtils.getAgent().IAgent_getIndexedProperties().getBooleanProperty("com.wily.introscope.agent.soapheaderinsertion.enabled", true);
        }
        catch (Exception exception) {
            return true;
        }
    }

    public static boolean prependClientHandlerEnabled() {
        try {
            IAgent agent = WSMUtils.getAgent();
            return agent.IAgent_getIndexedProperties().safeGetBooleanProperty("com.wily.introscope.soa.client.prependhandler", true, agent.IAgent_getModuleFeedback(), agent.IAgent_getStringLocalizer());
        }
        catch (Exception exception) {
            return true;
        }
    }

    public static boolean appendServerHandlerEnabled() {
        try {
            IAgent agent = WSMUtils.getAgent();
            return agent.IAgent_getIndexedProperties().safeGetBooleanProperty("com.wily.introscope.soa.server.appendhandler", true, agent.IAgent_getModuleFeedback(), agent.IAgent_getStringLocalizer());
        }
        catch (Exception exception) {
            return true;
        }
    }

    public static boolean correlationSOAPReadEnabled() {
        try {
            IAgent agent = WSMUtils.getAgent();
            return agent.IAgent_getIndexedProperties().safeGetBooleanProperty("com.wily.introscope.agent.soapheaderread.enabled", true, agent.IAgent_getModuleFeedback(), agent.IAgent_getStringLocalizer());
        }
        catch (Exception exception) {
            return true;
        }
    }

    public static boolean correlationHTTPReadEnabled() {
        try {
            IAgent agent = WSMUtils.getAgent();
            return agent.IAgent_getIndexedProperties().safeGetBooleanProperty("com.wily.introscope.agent.httpheaderread.enabled", false, agent.IAgent_getModuleFeedback(), agent.IAgent_getStringLocalizer());
        }
        catch (Exception exception) {
            return true;
        }
    }

    public static boolean correlationSOAPInsertionEnabled() {
        try {
            IAgent agent = WSMUtils.getAgent();
            return agent.IAgent_getIndexedProperties().safeGetBooleanProperty("com.wily.introscope.agent.soapheaderinsertion.enabled", true, agent.IAgent_getModuleFeedback(), agent.IAgent_getStringLocalizer());
        }
        catch (Exception exception) {
            return true;
        }
    }

    public static boolean correlationHTTPInsertionEnabled() {
        try {
            IAgent agent = WSMUtils.getAgent();
            return agent.IAgent_getIndexedProperties().safeGetBooleanProperty("com.wily.introscope.agent.httpheaderinsertion.enabled", false, agent.IAgent_getModuleFeedback(), agent.IAgent_getStringLocalizer());
        }
        catch (Exception exception) {
            return true;
        }
    }

    public static String getJAXWSHeadersClassName() {
        try {
            IAgent agent = WSMUtils.getAgent();
            String customJaxWSHeaderClassName = agent.IAgent_getIndexedProperties().getTrimmedProperty("com.wily.introscope.agent.soa.JAXWSHeadersClassName");
            return customJaxWSHeaderClassName != null ? customJaxWSHeaderClassName : "com.sun.xml.ws.transport.Headers";
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean xmlParsingEnabled() {
        try {
            return WSMUtils.getAgent().IAgent_getIndexedProperties().getBooleanProperty("com.wily.introscope.agent.soa.xmlParsingForOperationName.enabled", true);
        }
        catch (AgentNotAvailableException agentNotAvailableException) {
            return true;
        }
    }

    public static boolean axisClearingSOAPActorAttributeEnabled() {
        try {
            IAgent agent = WSMUtils.getAgent();
            return agent.IAgent_getIndexedProperties().safeGetBooleanProperty("com.wily.introscope.soa.axis.clearingsoapactorattribute", false, agent.IAgent_getModuleFeedback(), agent.IAgent_getStringLocalizer());
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static int cxfClearOldHeaders() {
        try {
            if (fCxfClearOldHeadersProperty == null) {
                IAgent agent = WSMUtils.getAgent();
                fCxfClearOldHeadersProperty = new CxfClearOldHeadersProperty(agent);
                agent.IAgent_getConfigurationManager().add((ConfigurationProperty)fCxfClearOldHeadersProperty, true);
            }
            return (Integer)fCxfClearOldHeadersProperty.getValue();
        }
        catch (Exception exception) {
            return 1;
        }
    }

    public static URLClassLoader createClassLoader(ClassLoader parent, String customClassLoaderJarFile, IAgent agent) throws MalformedURLException, AgentNotAvailableException {
        URLClassLoader urlClassLoader = null;
        IResource resource = null;
        String directoryProperty = (String)agent.IAgent_getIndexedProperties().get((Object)"introscope.agent.extensions.directory");
        resource = ExtendedFile.isAbsolutePath((String)directoryProperty) ? WSMUtils.getDirFinder(WSMUtils.getExtensionDirectory(), customClassLoaderJarFile) : WSMUtils.getDirFinder(String.valueOf(WSMUtils.getAbsoluteAgentPath()) + File.separator + WSMUtils.getExtensionDirectory() + File.separator, customClassLoaderJarFile);
        URL[] urlResources = new URL[]{resource.IResource_getURL()};
        urlClassLoader = new URLClassLoader(urlResources, parent);
        return urlClassLoader;
    }

    public static Module getModule() {
        return kModule;
    }

    public static Object invokeMethodOnObject(Object object, String methodName, Class[] parameterTypes, Object[] args) throws NoSuchMethodException, SecurityException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = object.getClass();
        Method method = WSMUtils.getMethod(clazz, methodName, parameterTypes);
        method.setAccessible(true);
        return method.invoke(object, args);
    }

    public static Object invokeMethodOnObjectInClassHierarchy(Object object, String methodName, Class[] parameterTypes, Object[] args) {
        Class<?> clazz = object.getClass();
        Object result = null;
        while (clazz != null) {
            try {
                Method method = WSMUtils.getMethod(clazz, methodName, parameterTypes);
                method.setAccessible(true);
                result = method.invoke(object, args);
            }
            catch (Throwable throwable) {}
            if (result != null) {
                return result;
            }
            clazz = clazz.getSuperclass();
        }
        return result;
    }

    public static Object invokeMethodOnObject(Object object, String methodName) throws NoSuchMethodException, SecurityException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return WSMUtils.invokeMethodOnObject(object, methodName, new Class[0], new Object[0]);
    }

    public static Object invokeDeclaredMethodOnObject(Object object, String methodName, Class[] parameterTypes, Object[] args) throws NoSuchMethodException, SecurityException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = object.getClass();
        Method method = WSMUtils.getDeclaredMethod(clazz, methodName, parameterTypes);
        method.setAccessible(true);
        return method.invoke(object, args);
    }

    public static Object invokeDeclaredMethodOnObject(Object object, String methodName) throws NoSuchMethodException, SecurityException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return WSMUtils.invokeDeclaredMethodOnObject(object, methodName, new Class[0], new Object[0]);
    }

    public static Object invokeMethodOnClass(Class clazz, String methodName) throws NoSuchMethodException, SecurityException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return WSMUtils.invokeMethodOnClass(clazz, methodName, new Class[0], new Object[0]);
    }

    public static Object invokeMethodOnClass(Class clazz, String methodName, Class[] parameterTypes, Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method = WSMUtils.getMethod(clazz, methodName, parameterTypes);
        return method.invoke(null, args);
    }

    public static Method findGetPropertyWithStringArgMethod(Class clazz) throws NoSuchMethodException, SecurityException {
        return WSMUtils.getMethod(clazz, "getProperty", kSingleStringClassArray);
    }

    public static void dumpMethodsForClass(Class dumpMe, IModuleFeedbackChannel logger) {
        if (logger.isDebugEnabled()) {
            int j;
            Class<?>[] classes;
            Method[] methods = dumpMe.getDeclaredMethods();
            int i = 0;
            while (i < methods.length) {
                classes = methods[i].getParameterTypes();
                logger.debug("declared method=" + methods[i].getName());
                j = 0;
                while (j < classes.length) {
                    logger.debug("        parameter=" + classes[j]);
                    ++j;
                }
                logger.debug("");
                ++i;
            }
            methods = dumpMe.getMethods();
            i = 0;
            while (i < methods.length) {
                classes = methods[i].getParameterTypes();
                logger.debug(" method=" + methods[i].getName());
                j = 0;
                while (j < classes.length) {
                    logger.debug("        parameter=" + classes[j]);
                    ++j;
                }
                logger.debug("");
                ++i;
            }
        }
    }

    public static Method find_GetPropertyWithStringArgMethod(Class clazz) throws NoSuchMethodException, SecurityException {
        return WSMUtils.getMethod(clazz, "_getProperty", kSingleStringClassArray);
    }

    public static String toString(Object object) throws NoSuchMethodException, SecurityException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return (String)WSMUtils.invokeMethodOnObject(object, "toString");
    }

    public static Method getMethodForObject(Object object, String methodName, Class[] paramTypes) throws NoSuchMethodException, SecurityException, IllegalArgumentException {
        Class<?> clazz = object.getClass();
        return WSMUtils.getMethod(clazz, methodName, paramTypes);
    }

    public static Object getField(Object object, String fieldName) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Class<?> clazz = object.getClass();
        Field field = WSMUtils.getDeclaredField(clazz, fieldName);
        field.setAccessible(true);
        return field.get(object);
    }

    public static String resource2URI(String resource) {
        int index;
        if (resource != null && (index = resource.indexOf(95)) != -1) {
            StringBuilder buf = new StringBuilder(resource);
            buf.setCharAt(index, ':');
            resource = buf.toString();
        }
        return resource;
    }

    public static String URI2Resource(String URI2) {
        int index;
        if (URI2 != null && (index = URI2.indexOf(58)) != -1) {
            StringBuilder buf = new StringBuilder(URI2);
            buf.setCharAt(index, '_');
            URI2 = buf.toString();
        }
        return URI2;
    }

    public static String formatToBeResourceSafe(String value) {
        return StringUtils.replaceIllegalChars((String)value, (char[])kIllegalResourceChars, (char)'_');
    }

    public static String formatURLToBeResourceSafe(String URL2) {
        String newURL = null;
        StringBuilder newURLBuffer = new StringBuilder();
        String substituteString = null;
        if (URL2 != null) {
            try {
                substituteString = WSMUtils.getAgent().IAgent_getIndexedProperties().getProperty("com.wily.introscope.agent.soa.metricNameFormatting");
            }
            catch (AgentNotAvailableException agentNotAvailableException) {}
            if (substituteString == null) {
                return URL2;
            }
            StringTokenizer strTok = new StringTokenizer(URL2, substituteString);
            int tokens = strTok.countTokens();
            int x = 0;
            while (x < tokens) {
                String token = strTok.nextToken();
                if (!token.equals("")) {
                    newURLBuffer.append(token).append("_");
                }
                ++x;
            }
            if (newURLBuffer.length() < 2) {
                newURL = null;
            } else {
                String tempURL = newURLBuffer.toString();
                newURL = tempURL.trim().substring(0, tempURL.length() - 1);
            }
        }
        return newURL;
    }

    public static String formatSOAPFaultURLToBeResourceSafe(String URL2) {
        String newURL = null;
        StringBuilder newURLBuffer = new StringBuilder();
        String substituteString = null;
        if (URL2 != null) {
            try {
                substituteString = WSMUtils.getAgent().IAgent_getIndexedProperties().getProperty("com.wily.introscope.agent.soa.metricNameFormatting");
            }
            catch (AgentNotAvailableException agentNotAvailableException) {}
            substituteString = substituteString != null ? String.valueOf(substituteString) + ":@&$+!*'()," : ":@&$+!*'(),";
            StringTokenizer strTok = new StringTokenizer(URL2, substituteString);
            int tokens = strTok.countTokens();
            int x = 0;
            while (x < tokens) {
                String token = strTok.nextToken();
                if (!token.equals("")) {
                    newURLBuffer.append(token).append("_");
                }
                ++x;
            }
            if (newURLBuffer.length() < 2) {
                newURL = null;
            } else {
                String tempURL = newURLBuffer.toString();
                newURL = tempURL.trim().substring(0, tempURL.length() - 1);
            }
        }
        return newURL;
    }

    public static void handleError(IAgent agent, String localizedKey, Throwable t) {
        if (agent.IAgent_getModuleFeedback().isVerboseEnabled()) {
            agent.IAgent_getModuleFeedback().warn(agent.IAgent_getStringLocalizer().IStringLocalizer_getLocalizedString(localizedKey), t);
        } else {
            agent.IAgent_getModuleFeedback().warn(agent.IAgent_getStringLocalizer().IStringLocalizer_getLocalizedString(localizedKey));
        }
    }

    public static void handleException(IAgent agent, String text, Throwable t) {
        if (agent.IAgent_getModuleFeedback().isDebugEnabled()) {
            agent.IAgent_getModuleFeedback().debug(String.valueOf(text) + WSMUtils.dumpStackTrace(t));
        } else {
            agent.IAgent_getModuleFeedback().warn(String.valueOf(text) + " " + t);
        }
    }

    public static void handleError(IAgent agent, String localizedKey) {
        agent.IAgent_getModuleFeedback().warn(agent.IAgent_getStringLocalizer().IStringLocalizer_getLocalizedString(localizedKey));
    }

    public static IAgent getAgent() throws AgentNotAvailableException {
        return AgentShim.getAgent();
    }

    public static IModuleFeedbackChannel getAgentLogger() throws AgentNotAvailableException {
        return WSMUtils.getAgent().IAgent_getModuleFeedback();
    }

    public static IStringLocalizer getAgentStringLocalizer() throws AgentNotAvailableException {
        return WSMUtils.getAgent().IAgent_getStringLocalizer();
    }

    public static IndexedProperties getAgentConfiguration() throws AgentNotAvailableException {
        return WSMUtils.getAgent().IAgent_getIndexedProperties();
    }

    public static IModuleFeedbackChannel getLogger() {
        return sLogger;
    }

    public static String getGlobalUniqueID() {
        return sGlobalIDGenerator.generateKey();
    }

    private static GUIDGenerator getGUIDGenerator() {
        String seederClassName = null;
        try {
            seederClassName = WSMUtils.getAgent().IAgent_getIndexedProperties().getProperty(kComWilyGUIDGeneratorSeeder, GUIDGenerator.kDefaultSeeder);
            WSMUtils.getAgent().IAgent_getModuleFeedback().info(kModule, WSMUtils.getAgent().IAgent_getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Using_Seeder", seederClassName));
        }
        catch (AgentNotAvailableException anae) {
            try {
                AgentShim.handleError((String)WSMUtils.getAgent().IAgent_getStringLocalizer().IStringLocalizer_getLocalizedString("Agent_Unable_to_get_Agent_properties"), (Throwable)anae);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable throwable) {}
        }
        return GUIDGenerator.getInstance((String)seederClassName);
    }

    public static void getKeyAndValue(String context, StringBuffer key, StringBuffer value) {
        WSMUtils.refreshLogLevels();
        WSMUtils.getLogger().debug("getKeyAndValue");
        int equals = context.indexOf("=");
        if (equals != -1) {
            key.append(context.substring(0, equals));
            value.append(context.substring(equals + 1));
            WSMUtils.getLogger().debug("getKeyAndValue key=" + key + " value= " + value);
        }
    }

    public static String dumpStackTrace(Throwable bomb) {
        StackTracePrintStream stack = new StackTracePrintStream((OutputStream)new ByteArrayOutputStream(), 1024);
        bomb.printStackTrace(stack);
        return stack.getString();
    }

    public static String getAbsoluteAgentPath() {
        String path = "";
        try {
            IResource profileResource = WSMUtils.getAgent().IAgent_getConfigurationResource();
            if (profileResource.IResource_isFileResource()) {
                File profileDirectory = new File(profileResource.IResource_getLocation()).getParentFile();
                File pathFile = new File(profileDirectory, path);
                path = pathFile.getAbsolutePath();
            }
        }
        catch (AgentNotAvailableException agentNotAvailableException) {
            path = "wily";
        }
        return path;
    }

    public static void addConfigurationListener(IConfigurationListener listener) throws Throwable {
        try {
            WSMUtils.getAgent().addConfigurationListener(listener);
        }
        catch (Throwable bomb) {
            WSMUtils.dumpStackTrace(bomb);
            throw bomb;
        }
    }

    public static Hashtable getWSDMHandlerConfig(String observerType) {
        Hashtable<String, String> config = new Hashtable<String, String>();
        try {
            WSMUtils.getAgentConfiguration();
            config.put("observationType", observerType);
        }
        catch (AgentNotAvailableException a) {
            WSMUtils.getLogger().error("ModifyHandlerCache getWSDMHandlerConfig " + WSMUtils.dumpStackTrace(a));
        }
        return config;
    }

    public static void refreshLogLevels() {
        debugLogging = sLogger.isDebugEnabled();
        infoLogging = sLogger.isInfoEnabled(WSMUtils.getModule());
        warnLogging = sLogger.isWarningEnabled(WSMUtils.getModule());
    }

    public static boolean isDebugLogging() {
        return debugLogging;
    }

    public static boolean isInfoLogging() {
        return infoLogging;
    }

    public static boolean isWarnLogging() {
        return warnLogging;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassLoader setClassLoader(Object o, IAgent agent) {
        ClassLoader parent = o.getClass().getClassLoader();
        ClassLoader wsdmClassLoader = null;
        HashMap hashMap = wsdmClassLoaders;
        synchronized (hashMap) {
            if (wsdmClassLoaders.size() == 1) {
                Collection c = wsdmClassLoaders.values();
                Object[] co = c.toArray();
                return (ClassLoader)co[0];
            }
            wsdmClassLoader = (ClassLoader)wsdmClassLoaders.get(parent);
            String name = "";
            if (wsdmClassLoader != null) {
                if (wsdmClassLoader.getParent() != null) {
                    wsdmClassLoader.getParent().getClass().getName();
                }
                name = wsdmClassLoader.getClass().getName();
            }
            if (wsdmClassLoader == null) {
                try {
                    wsdmClassLoader = WSMUtils.createClassLoader(parent, customClassloaderJar, agent);
                    name = parent.getClass().getName();
                    WSMUtils.getLogger().debug("adding classloaders: " + name);
                    wsdmClassLoaders.put(parent, wsdmClassLoader);
                }
                catch (Exception bomb) {
                    bomb.printStackTrace();
                    return o.getClass().getClassLoader();
                }
            }
            WSMUtils.getLogger().debug(String.valueOf(wsdmClassLoaders.size()) + " classloaders in hash");
        }
        return wsdmClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassLoader setClassLoader(ClassLoader cl, IAgent agent) {
        ClassLoader wsdmClassLoader = null;
        HashMap hashMap = wsdmClassLoaders;
        synchronized (hashMap) {
            wsdmClassLoader = (ClassLoader)wsdmClassLoaders.get(cl);
            if (wsdmClassLoader == null) {
                try {
                    wsdmClassLoader = WSMUtils.createClassLoader(cl, customClassloaderJar, agent);
                    wsdmClassLoaders.put(cl, wsdmClassLoader);
                }
                catch (Exception bomb) {
                    bomb.printStackTrace();
                    return cl;
                }
            }
            WSMUtils.getLogger().debug(String.valueOf(wsdmClassLoaders.size()) + " classloaders in hash");
        }
        return wsdmClassLoader;
    }

    public static String getExtensionDirectory() {
        String extFolder = "";
        try {
            IndexedProperties props = WSMUtils.getAgentConfiguration();
            extFolder = props.getTrimmedProperty("introscope.agent.extensions.directory");
        }
        catch (AgentNotAvailableException bomb) {
            WSMUtils.getLogger().error("getExtensionDirectory " + WSMUtils.dumpStackTrace(bomb));
        }
        return extFolder;
    }

    public static Object getWsdmProviderProtocol() {
        return wsdmProviderProtocol;
    }

    public static void setWsdmProviderProtocol(Object wsdmProviderProtocol) {
        WSMUtils.wsdmProviderProtocol = wsdmProviderProtocol;
    }

    public static Object getWsdmClientProtocol() {
        return wsdmClientProtocol;
    }

    public static void setWsdmClientProtocol(Object wsdmClientProtocol) {
        WSMUtils.wsdmClientProtocol = wsdmClientProtocol;
    }

    public static ClassLoader getWilyClassLoader() {
        return wilyClassLoader;
    }

    public static void setWilyClassLoader(ClassLoader wilyClassLoader) {
        WSMUtils.wilyClassLoader = wilyClassLoader;
    }

    private static Method getMethod(Class clz, String methodName, Class[] parameterTypes) throws NoSuchMethodException, SecurityException, IllegalArgumentException {
        ReflectionKey key = new ReflectionKey(clz, methodName, parameterTypes);
        Method m = null;
        if (WSMUtils.getMethodCache() != null) {
            m = (Method)methodCache.get(key);
        }
        if (m == null) {
            Method lookup = clz.getMethod(methodName, parameterTypes);
            if (methodCache != null) {
                m = methodCache.put(key, lookup);
            }
            if (m == null) {
                m = lookup;
            }
        }
        return m;
    }

    private static Method getDeclaredMethod(Class clz, String methodName, Class[] parameterTypes) throws NoSuchMethodException, SecurityException, IllegalArgumentException {
        ReflectionKey key = new ReflectionKey(clz, methodName, parameterTypes);
        Method m = null;
        if (WSMUtils.getMethodCache() != null) {
            m = (Method)methodCache.get(key);
        }
        if (m == null) {
            Method lookup = clz.getDeclaredMethod(methodName, parameterTypes);
            if (methodCache != null) {
                m = methodCache.put(key, lookup);
            }
            if (m == null) {
                m = lookup;
            }
        }
        return m;
    }

    private static Field getDeclaredField(Class clz, String fieldName) throws NoSuchFieldException, SecurityException, IllegalArgumentException {
        ReflectionKey key = new ReflectionKey(clz, fieldName, new Class[0]);
        Field f = null;
        if (WSMUtils.getFieldCache() != null) {
            f = (Field)fieldCache.get(key);
        }
        if (f == null) {
            Field lookup = clz.getDeclaredField(fieldName);
            if (fieldCache != null) {
                f = fieldCache.put(key, lookup);
            }
            if (f == null) {
                f = lookup;
            }
        }
        return f;
    }

    private static Map getMethodCache() {
        if (methodCache == null) {
            try {
                methodCache = AgentShim.getAgent().IAgent_getConcurrentMapFactory().getConcurrentCappedMap("WSMUtilMethodCache");
            }
            catch (AgentNotAvailableException e) {
                try {
                    WSMUtils.getAgent().IAgent_getModuleFeedback().info("APMDebug : methodCache not initialized due to ", (Throwable)e);
                }
                catch (Exception exception) {}
            }
        }
        return methodCache;
    }

    private static Map getFieldCache() {
        if (fieldCache == null) {
            try {
                fieldCache = AgentShim.getAgent().IAgent_getConcurrentMapFactory().getConcurrentCappedMap("WSMUtilFieldCache");
            }
            catch (AgentNotAvailableException e) {
                try {
                    WSMUtils.getAgent().IAgent_getModuleFeedback().info("APMDebug : methodCache not initialized due to ", (Throwable)e);
                }
                catch (Exception exception) {}
            }
        }
        return fieldCache;
    }

    public static String removeTrailingSlash(String serviceURI) {
        String retval = serviceURI;
        if (serviceURI != null && serviceURI.length() > 1 && serviceURI.endsWith("/")) {
            retval = serviceURI.substring(0, serviceURI.length() - 1);
        }
        return retval;
    }

    public static final boolean checkIfVersionQualifies(String sVersion, String checkAgainstVersion) {
        return WSMUtils.checkIfVersionQualifies(sVersion, checkAgainstVersion, false);
    }

    public static final boolean checkIfVersionQualifies(String sVersion, String checkAgainstVersion, boolean strictFlag) {
        if (strictFlag) {
            if (sVersion.equalsIgnoreCase(checkAgainstVersion)) {
                return true;
            }
        } else {
            int[] formattedVersion = WSMUtils.formatVersion(sVersion);
            int[] markedVersion = WSMUtils.formatVersion(checkAgainstVersion);
            if (formattedVersion != null && markedVersion != null) {
                int arrLength = formattedVersion.length <= markedVersion.length ? formattedVersion.length : markedVersion.length;
                int i = 0;
                while (i < arrLength) {
                    if (formattedVersion[i] == markedVersion[i]) {
                        ++i;
                        continue;
                    }
                    if (formattedVersion[i] > markedVersion[i]) {
                        return true;
                    }
                    if (formattedVersion[i] >= markedVersion[i]) continue;
                    return false;
                }
            }
        }
        return false;
    }

    public static final int[] formatVersion(String version) {
        if (version != null) {
            String[] vNumbers = version.split("\\.");
            int[] vInts = new int[vNumbers.length];
            int i = 0;
            while (i < vNumbers.length) {
                vInts[i] = Integer.parseInt(vNumbers[i]);
                ++i;
            }
            return vInts;
        }
        return null;
    }

    private static final class CxfClearOldHeadersProperty
    extends EnumConfigurationProperty {
        private CxfClearOldHeadersProperty(IAgent agent) {
            super("com.wily.introscope.soa.cxf.clearoldheaders", Integer.valueOf(1), new String[]{"none", "wily", "all"}, agent.IAgent_getModuleFeedback(), agent.IAgent_getModule(), agent.IAgent_getStringLocalizer());
        }
    }

    private static class ProtectedLogger
    implements IModuleFeedbackChannel {
        private ProtectedLogger() {
        }

        private synchronized IModuleFeedbackChannel getFeedbackChannel() {
            IModuleFeedbackChannel channel = null;
            try {
                channel = WSMUtils.getAgentLogger();
            }
            catch (AgentNotAvailableException agentNotAvailableException) {}
            return channel;
        }

        public boolean isVerboseEnabled() {
            boolean verbose = false;
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                verbose = channel.isVerboseEnabled(WSMUtils.getModule());
            }
            return verbose;
        }

        public boolean isDebugEnabled() {
            boolean debug = false;
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                debug = channel.isDebugEnabled(WSMUtils.getModule());
            }
            return debug;
        }

        public boolean isTraceEnabled() {
            boolean trace = false;
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                trace = channel.isTraceEnabled(WSMUtils.getModule());
            }
            return trace;
        }

        public boolean isErrorEnabled(Module module) {
            boolean error = false;
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                error = channel.isErrorEnabled(module);
            }
            return error;
        }

        public boolean isWarningEnabled(Module module) {
            boolean warn = false;
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                warn = channel.isWarningEnabled(module);
            }
            return warn;
        }

        public boolean isInfoEnabled(Module module) {
            boolean info = false;
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                info = channel.isInfoEnabled(module);
            }
            return info;
        }

        public boolean isVerboseEnabled(Module module) {
            boolean verbose = false;
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                verbose = channel.isVerboseEnabled(module);
            }
            return verbose;
        }

        public boolean isDebugEnabled(Module module) {
            boolean debug = false;
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                debug = channel.isDebugEnabled(module);
            }
            return debug;
        }

        public boolean isTraceEnabled(Module module) {
            boolean trace = false;
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                trace = channel.isTraceEnabled(module);
            }
            return trace;
        }

        public boolean isLogEnabled(SeverityLevel severityLevel, Module module) {
            boolean log = false;
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                log = channel.isLogEnabled(severityLevel, module);
            }
            return log;
        }

        public void error(String string) {
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                channel.error(WSMUtils.getModule(), string);
            }
        }

        public void error(String string, Throwable throwable) {
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                channel.error(WSMUtils.getModule(), string, throwable);
            }
        }

        public void warn(String string) {
            IModuleFeedbackChannel channel;
            if (warnLogging && (channel = this.getFeedbackChannel()) != null) {
                channel.warn(WSMUtils.getModule(), string);
            }
        }

        public void warn(String string, Throwable throwable) {
            IModuleFeedbackChannel channel;
            if (warnLogging && (channel = this.getFeedbackChannel()) != null) {
                channel.warn(WSMUtils.getModule(), string, throwable);
            }
        }

        public void info(String string) {
            IModuleFeedbackChannel channel;
            if (infoLogging && (channel = this.getFeedbackChannel()) != null) {
                channel.info(WSMUtils.getModule(), string);
            }
        }

        public void info(String string, Throwable throwable) {
            IModuleFeedbackChannel channel;
            if (infoLogging && (channel = this.getFeedbackChannel()) != null) {
                channel.info(WSMUtils.getModule(), string, throwable);
            }
        }

        public void verbose(String string) {
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                channel.verbose(WSMUtils.getModule(), string);
            }
        }

        public void verbose(String string, Throwable throwable) {
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                channel.verbose(WSMUtils.getModule(), string, throwable);
            }
        }

        public void debug(String string) {
            IModuleFeedbackChannel channel;
            if (debugLogging && (channel = this.getFeedbackChannel()) != null) {
                channel.debug(WSMUtils.getModule(), string);
            }
        }

        public void debug(String string, Throwable throwable) {
            IModuleFeedbackChannel channel;
            if (debugLogging && (channel = this.getFeedbackChannel()) != null) {
                channel.debug(WSMUtils.getModule(), string, throwable);
            }
        }

        public void log(SeverityLevel severityLevel, String string) {
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                channel.log(severityLevel, WSMUtils.getModule(), string);
            }
        }

        public void log(SeverityLevel severityLevel, String string, Throwable throwable) {
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                channel.log(severityLevel, WSMUtils.getModule(), string, throwable);
            }
        }

        public void error(Throwable throwable) {
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                channel.error(WSMUtils.getModule(), throwable.getMessage(), throwable);
            }
        }

        public void verbose(Throwable throwable) {
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                channel.verbose(WSMUtils.getModule(), throwable.getMessage(), throwable);
            }
        }

        public void debug(Throwable throwable) {
            IModuleFeedbackChannel channel;
            if (debugLogging && (channel = this.getFeedbackChannel()) != null) {
                channel.debug(WSMUtils.getModule(), throwable.getMessage(), throwable);
            }
        }

        public void error(Module module, String string) {
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                channel.error(module, string);
            }
        }

        public void error(Module module, String string, Throwable throwable) {
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                channel.error(module, string, throwable);
            }
        }

        public void warn(Module module, String string) {
            IModuleFeedbackChannel channel;
            if (warnLogging && (channel = this.getFeedbackChannel()) != null) {
                channel.warn(module, string);
            }
        }

        public void warn(Module module, String string, Throwable throwable) {
            IModuleFeedbackChannel channel;
            if (warnLogging && (channel = this.getFeedbackChannel()) != null) {
                channel.warn(module, string, throwable);
            }
        }

        public void info(Module module, String string) {
            IModuleFeedbackChannel channel;
            if (infoLogging && (channel = this.getFeedbackChannel()) != null) {
                channel.info(module, string);
            }
        }

        public void info(Module module, String string, Throwable throwable) {
            IModuleFeedbackChannel channel;
            if (infoLogging && (channel = this.getFeedbackChannel()) != null) {
                channel.info(module, string, throwable);
            }
        }

        public void verbose(Module module, String string) {
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                channel.verbose(module, string);
            }
        }

        public void verbose(Module module, String string, Throwable throwable) {
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                channel.verbose(module, string, throwable);
            }
        }

        public void debug(Module module, String string) {
            IModuleFeedbackChannel channel;
            if (debugLogging && (channel = this.getFeedbackChannel()) != null) {
                channel.debug(module, string);
            }
        }

        public void debug(Module module, String string, Throwable throwable) {
            IModuleFeedbackChannel channel;
            if (debugLogging && (channel = this.getFeedbackChannel()) != null) {
                channel.debug(module, string, throwable);
            }
        }

        public void trace(String string) {
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                channel.trace(WSMUtils.getModule(), string);
            }
        }

        public void trace(String string, Throwable throwable) {
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                channel.trace(WSMUtils.getModule(), string, throwable);
            }
        }

        public void trace(Module module, String string) {
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                channel.trace(module, string);
            }
        }

        public void trace(Module module, String string, Throwable throwable) {
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                channel.trace(module, string, throwable);
            }
        }

        public void log(SeverityLevel severityLevel, Module module, String string) {
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                channel.log(severityLevel, module, string);
            }
        }

        public void log(SeverityLevel severityLevel, Module module, String string, Throwable throwable) {
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                channel.log(severityLevel, module, string, throwable);
            }
        }

        public void logImmediate(SeverityLevel severityLevel, Module module, String string) {
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                channel.logImmediate(severityLevel, module, string);
            }
        }

        public void logImmediate(SeverityLevel severityLevel, Module module, String string, Throwable throwable) {
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                channel.logImmediate(severityLevel, module, string, throwable);
            }
        }

        public void setLevel(SeverityLevel level, Module module) {
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                channel.setLevel(level, module);
            }
        }

        public SeverityLevel getLevel(Module module) {
            SeverityLevel level = null;
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                level = channel.getLevel(module);
            }
            return level;
        }

        public SeverityLevel getEffectiveLevel(Module module) {
            SeverityLevel level = null;
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                level = channel.getEffectiveLevel(module);
            }
            return level;
        }

        public String getApplicationName() {
            String appName = null;
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                appName = channel.getApplicationName();
            }
            return appName;
        }

        public String getModuleName() {
            String name = null;
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                name = channel.getModuleName();
            }
            return name;
        }
    }

    static class ReflectionKey {
        Class clz;
        ClassLoader cl;
        String methodname;
        Class[] parameterTypes;

        ReflectionKey(Class cls, String method, Class[] params) {
            if (cls == null || method == null) {
                throw new IllegalArgumentException("Class and member method or field name cannot be null");
            }
            this.clz = cls;
            this.cl = cls.getClassLoader();
            this.methodname = method;
            this.parameterTypes = params;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj instanceof ReflectionKey) {
                ReflectionKey keyobj = (ReflectionKey)obj;
                if (this.cl != null && !this.cl.equals(keyobj.cl)) {
                    return false;
                }
                if (!this.clz.equals(keyobj.clz)) {
                    return false;
                }
                if (!this.methodname.equals(keyobj.methodname)) {
                    return false;
                }
                if (this.parameterTypes == null) {
                    return keyobj.parameterTypes == null;
                }
                if (this.parameterTypes != null && keyobj.parameterTypes == null) {
                    return false;
                }
                int size = this.parameterTypes.length;
                int keyobjparamsize = keyobj.parameterTypes.length;
                if (size != keyobjparamsize) {
                    return false;
                }
                int i = 0;
                while (i < size) {
                    if (!this.parameterTypes[i].equals(keyobj.parameterTypes[i])) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            int paramsum = 0;
            if (this.parameterTypes != null) {
                int i = 0;
                while (i < this.parameterTypes.length) {
                    paramsum += this.parameterTypes[i].hashCode();
                    ++i;
                }
            }
            int classhash = this.clz.hashCode();
            int methodhash = this.methodname.hashCode();
            int clhash = 0;
            if (this.cl != null) {
                clhash = this.cl.hashCode();
            }
            int result = clhash + classhash + methodhash + paramsum;
            return result;
        }
    }

    private static class StackTracePrintStream
    extends PrintStream {
        private final char[] fLineSeparator = System.getProperty("line.separator").toCharArray();
        private int fCursor = 0;
        private char[] fChars;
        private int fCharCount;

        public StackTracePrintStream(OutputStream dummy, int initialSize) {
            super(dummy);
            this.fChars = new char[initialSize];
            this.fCharCount = initialSize;
        }

        @Override
        public synchronized void print(char[] data) {
            while (this.fCursor + data.length > this.fCharCount) {
                this.growBuffer();
            }
            System.arraycopy(data, 0, this.fChars, this.fCursor, data.length);
            this.fCursor += data.length;
        }

        @Override
        public synchronized void print(String s) {
            if (s == null) {
                s = "null";
            }
            int length = s.length();
            while (this.fCursor + length > this.fCharCount) {
                this.growBuffer();
            }
            s.getChars(0, length, this.fChars, this.fCursor);
            this.fCursor += length;
        }

        @Override
        public synchronized void print(Object obj) {
            this.print(String.valueOf(obj));
        }

        @Override
        public synchronized void println(char[] data) {
            this.print(data);
            this.printSeparator();
        }

        @Override
        public synchronized void println(String s) {
            this.print(s);
            this.printSeparator();
        }

        @Override
        public synchronized void println(Object obj) {
            this.print(obj);
            this.printSeparator();
        }

        @Override
        public synchronized void println() {
            this.printSeparator();
        }

        private void printSeparator() {
            this.print(this.fLineSeparator);
        }

        private void growBuffer() {
            int newSize = this.fCharCount * 2;
            char[] newBuffer = new char[newSize];
            System.arraycopy(this.fChars, 0, newBuffer, 0, this.fCharCount);
            this.fCharCount = newSize;
            this.fChars = newBuffer;
        }

        public String getString() {
            return new String(this.fChars, 0, this.fCursor);
        }

        public void reset() {
            this.fCursor = 0;
        }

        @Override
        public void flush() {
        }
    }

    private static class WSMFinderFeedback
    implements IResourceFinderFeedback {
        IModuleFeedbackChannel fLogger;
        IStringLocalizer fLocalizer;

        public WSMFinderFeedback(IModuleFeedbackChannel logger, IStringLocalizer localizer) {
            this.fLogger = logger;
            this.fLocalizer = localizer;
        }

        public IStringLocalizer IResourceFinderFeedback_getStringLocalizer() {
            return this.fLocalizer;
        }

        public void IResourceFinderFeedback_feedbackStatus(String message) {
            this.fLogger.info(message);
        }

        public void IResourceFinderFeedback_feedbackFailure(String message) {
            this.fLogger.error(message);
        }

        public void IResourceFinderFeedback_feedbackSuccess(String message) {
            this.fLogger.info(message);
        }
    }
}

