/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.concurrent;

import com.wily.EDU.oswego.cs.dl.util.concurrent.Channel;
import com.wily.EDU.oswego.cs.dl.util.concurrent.LinkedQueue;
import com.wily.EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import com.wily.EDU.oswego.cs.dl.util.concurrent.ThreadFactory;

public class PooledVaryingExecutor
extends PooledExecutor {
    public PooledVaryingExecutor(String name, int minPoolSize, int maxPoolSize) {
        this(name, (Channel)new LinkedQueue(), minPoolSize, maxPoolSize);
    }

    public PooledVaryingExecutor(String name, Channel channel, int minPoolSize, int maxPoolSize) {
        super(channel, maxPoolSize);
        this.waitWhenBlocked();
        this.setThreadFactory(new PooledVaryingThreadFactory(name));
        this.setMinimumPoolSize(minPoolSize);
        this.setKeepAliveTime(1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Runnable getTask() throws InterruptedException {
        long waitTime;
        PooledVaryingExecutor pooledVaryingExecutor = this;
        synchronized (pooledVaryingExecutor) {
            if (this.poolSize_ > this.maximumPoolSize_) {
                return null;
            }
            waitTime = this.shutdown_ ? 0L : this.keepAliveTime_;
        }
        while (true) {
            Runnable work = null;
            work = waitTime >= 0L ? (Runnable)this.handOff_.poll(waitTime) : (Runnable)this.handOff_.take();
            if (this.shutdown_ || work != null) {
                return work;
            }
            PooledVaryingExecutor pooledVaryingExecutor2 = this;
            synchronized (pooledVaryingExecutor2) {
                if (this.poolSize_ > this.minimumPoolSize_) {
                    return null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Runnable command) throws InterruptedException {
        do {
            PooledVaryingExecutor pooledVaryingExecutor = this;
            synchronized (pooledVaryingExecutor) {
                if (!this.shutdown_) {
                    int size = this.poolSize_;
                    if (size < this.maximumPoolSize_) {
                        this.addThread(command);
                        return;
                    }
                    if (this.handOff_.offer((Object)command, 0L)) {
                        return;
                    }
                }
            }
        } while (!this.getBlockedExecutionHandler().blockedAction(command));
    }

    private static class PooledVaryingThreadFactory
    implements ThreadFactory {
        private final String fName;

        PooledVaryingThreadFactory(String name) {
            this.fName = name;
        }

        public Thread newThread(Runnable command) {
            Thread t = new Thread(command);
            t.setName(this.fName + " Pooled Worker");
            return t;
        }
    }
}

