/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.format;

import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;

public class ElapsedTimeFormat
extends NumberFormat {
    private static final long serialVersionUID = 1L;
    private boolean fFormatMicroseconds;
    private NumberFormat fTwoDigitFormat;
    private DecimalFormat fSecondsAndMillisFormat;
    private boolean fShowMillisPart;

    public ElapsedTimeFormat() {
        this(false);
    }

    public ElapsedTimeFormat(boolean useMicroseconds) {
        this.fShowMillisPart = this.fFormatMicroseconds = useMicroseconds;
        this.fTwoDigitFormat = new DecimalFormat("00");
        this.fSecondsAndMillisFormat = new DecimalFormat("00.000###");
    }

    public ElapsedTimeFormat setShowMillisPart(boolean v) {
        this.fShowMillisPart = v;
        return this;
    }

    public StringBuffer format(long number, StringBuffer toAppendTo, FieldPosition pos) {
        pos.setBeginIndex(toAppendTo.length());
        double milliseconds = this.fFormatMicroseconds ? (double)number / 1000.0 : (double)number;
        double secondsPart = milliseconds / 1000.0;
        long minutesPart = (long)milliseconds / 60000L % 60L;
        long hoursPart = (long)milliseconds / 3600000L;
        if (hoursPart > 0L) {
            toAppendTo.append(hoursPart).append(":");
        }
        this.fTwoDigitFormat.format(minutesPart, toAppendTo, pos);
        toAppendTo.append(":");
        if (this.fShowMillisPart) {
            this.fSecondsAndMillisFormat.format(secondsPart % 60.0, toAppendTo, pos);
        } else {
            this.fTwoDigitFormat.format(secondsPart % 60.0, toAppendTo, pos);
        }
        pos.setEndIndex(toAppendTo.length() - 1);
        return toAppendTo;
    }

    public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
        return this.format((long)number, toAppendTo, pos);
    }

    public Number parse(String source, ParsePosition parsePosition) {
        throw new UnsupportedOperationException("Parsing not implemented.");
    }
}

