/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.bit;

import com.wily.util.bit.BitStackCollection;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public final class SimpleBitStack
extends BitStackCollection
implements Serializable {
    protected long[] m_blob;
    private long m_stackTop;
    private int m_bottomIdx;

    public SimpleBitStack(int len) {
        this.m_blob = new long[len];
        this.m_stackTop = 0L;
    }

    public SimpleBitStack(long[] blob, int blobLength) {
        this.m_blob = blob;
        this.m_stackTop = blob[blobLength - 1];
    }

    @Override
    public final void setCursorToStack(int stackID, long[] cursor) {
        cursor[0] = this.m_stackTop;
    }

    @Override
    public final int getCursorStack(long[] cursor) {
        return 0;
    }

    @Override
    public final boolean atStackBottom(long cursorValue) {
        return cursorValue == 0L;
    }

    public final void alterStack(long newTop, long newStackBottom) {
        this.m_stackTop = newTop;
        this.m_bottomIdx = (int)(newStackBottom >>> 6);
    }

    @Override
    public final long[] getCursor() {
        long[] cursor = new long[]{this.m_stackTop};
        return cursor;
    }

    @Override
    public final void setCursorToTop(long[] cursor) {
        cursor[0] = this.m_stackTop;
    }

    @Override
    public final void pushLong(int numBits, long value, int stackID) {
        int arrayIndex = (int)(this.m_stackTop >>> 6);
        int bitPosition = (int)(this.m_stackTop & 0x3FL);
        int n = arrayIndex;
        this.m_blob[n] = this.m_blob[n] | value << bitPosition;
        int bitsUsedInFirstLong = 64 - bitPosition;
        if (numBits > bitsUsedInFirstLong) {
            int n2 = arrayIndex + 1;
            this.m_blob[n2] = this.m_blob[n2] | value >>> bitsUsedInFirstLong;
        }
        this.m_stackTop += (long)numBits;
    }

    @Override
    public final long readLong(int numBits, long[] cursor) throws ArrayIndexOutOfBoundsException {
        long bitIndex = cursor[0];
        if (bitIndex < (long)numBits) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int arrayIndex = (int)(bitIndex - 1L >>> 6);
        int bitPosition = (int)(bitIndex - 1L & 0x3FL) + 1;
        int lastValidBitInLong = bitPosition - numBits;
        int leftShift = 64 - bitPosition;
        long value = this.m_blob[arrayIndex] << leftShift >>> leftShift + lastValidBitInLong;
        if (lastValidBitInLong < 0) {
            value |= this.m_blob[arrayIndex - 1] >>> 64 + lastValidBitInLong;
        }
        cursor[0] = bitIndex - (long)numBits;
        return value;
    }

    public final long unpackEliasDelta(boolean decodeZero, long[] cursor) throws ArrayIndexOutOfBoundsException {
        int availableBitsInThisLong = (int)cursor[0] & 0x3F;
        int arrayIndex = availableBitsInThisLong >>> 6;
        if (availableBitsInThisLong == 0) {
            --arrayIndex;
            availableBitsInThisLong = 64;
        }
        long bits = this.m_blob[arrayIndex] << 64 - availableBitsInThisLong;
        int msbOfMSB = availableBitsInThisLong;
        while (bits >= 0L && availableBitsInThisLong >= 0) {
            --availableBitsInThisLong;
            bits <<= 1;
        }
        if (bits >= 0L) {
            bits = this.m_blob[--arrayIndex];
            availableBitsInThisLong = 64;
            msbOfMSB += 64;
            while (bits >= 0L && availableBitsInThisLong >= 0) {
                --availableBitsInThisLong;
                bits <<= 1;
            }
        }
        if ((msbOfMSB -= availableBitsInThisLong) == 0) {
            --availableBitsInThisLong;
            if (decodeZero) {
                bits <<= 1;
                if (availableBitsInThisLong == 0) {
                    bits = this.m_blob[--arrayIndex];
                    availableBitsInThisLong = 64;
                }
                --availableBitsInThisLong;
                if (bits >= 0L) {
                    cursor[0] = (long)arrayIndex << 6 | (long)availableBitsInThisLong;
                    return 0L;
                }
            }
            cursor[0] = (long)arrayIndex << 6 | (long)availableBitsInThisLong;
            return 1L;
        }
        int msbOfValue = (int)(bits >>> 64 - ++msbOfMSB);
        if (msbOfMSB <= availableBitsInThisLong) {
            availableBitsInThisLong -= msbOfMSB;
            bits <<= msbOfMSB;
        } else {
            int bitsInNextLong = msbOfMSB - availableBitsInThisLong;
            bits = this.m_blob[--arrayIndex];
            availableBitsInThisLong = 64;
            msbOfValue |= (int)(bits >>> 64 - bitsInNextLong);
            availableBitsInThisLong -= bitsInNextLong;
            bits <<= bitsInNextLong;
        }
        long valueToReturn = bits >>> 64 - --msbOfValue;
        if ((availableBitsInThisLong -= msbOfValue) < 0) {
            valueToReturn |= this.m_blob[--arrayIndex] >>> (availableBitsInThisLong += 64);
        }
        cursor[0] = (long)arrayIndex << 6 | (long)availableBitsInThisLong;
        return 1L << msbOfValue | valueToReturn;
    }

    protected final long[] getStackCopy() {
        long[] copyBlob = new long[this.m_blob.length + 1];
        System.arraycopy(this.m_blob, 0, copyBlob, 0, this.m_blob.length);
        copyBlob[this.m_blob.length] = this.m_stackTop;
        return copyBlob;
    }

    public void writeObject(ObjectOutputStream out) throws IOException {
        out.writeLong(this.m_stackTop - (long)(this.m_bottomIdx << 6));
        int i = this.m_blob.length - 2;
        while (i >= this.m_bottomIdx) {
            out.writeLong(this.m_blob[i]);
            --i;
        }
    }

    public void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.m_stackTop = in.readLong();
        int dataLen = (int)(this.m_stackTop >>> 6);
        this.m_blob = new long[dataLen];
        int i = dataLen;
        while (i >= 0) {
            this.m_blob[i] = in.readLong();
            --i;
        }
    }
}

