/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.jmx;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.jmx.AJMXDataView;
import com.wily.introscope.agent.jmx.ANameConverter;
import com.wily.introscope.agent.jmx.AllSortedKeysNameConverter;
import com.wily.introscope.agent.jmx.DataViewFactory;
import com.wily.introscope.agent.jmx.Filter;
import com.wily.introscope.agent.jmx.IJMXCustomizer;
import com.wily.introscope.agent.jmx.IJMXDataView;
import com.wily.introscope.agent.jmx.IMBeanNameConverter;
import com.wily.introscope.agent.jmx.IMBeanServerLocator;
import com.wily.introscope.agent.jmx.IntroscopeProtocolAdaptorMBean;
import com.wily.introscope.agent.jmx.JMXDelegatingService;
import com.wily.introscope.agent.jmx.JSR77NameConverter;
import com.wily.introscope.agent.jmx.MBeanInterpreterJMXDataView;
import com.wily.introscope.agent.jmx.MBeanInterpreterJSR77;
import com.wily.introscope.agent.jmx.PrimaryKeysNameConverter;
import com.wily.introscope.agent.jmx.StandardMBeanServerLocator;
import com.wily.introscope.agent.jmx.WebLogicMBeanServerLocator;
import com.wily.introscope.agent.stat.AccumulatorAlreadyExistsException;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.heartbeat.IntervalHeartbeat;
import com.wily.util.properties.IndexedProperties;
import com.wily.util.properties.hot.BooleanConfigurationProperty;
import com.wily.util.task.ASimpleExecutableItem;
import com.wily.util.text.IStringLocalizer;
import com.wily.wilyassert.Assertion;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.management.AttributeChangeNotification;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerNotification;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.monitor.MonitorNotification;
import javax.management.relation.RelationNotification;
import javax.management.timer.TimerNotification;
import javax.security.auth.Subject;

public final class IntroscopeProtocolAdaptor
implements IntroscopeProtocolAdaptorMBean {
    private static final Module sModule = new Module("JMX Service");
    public static final String kProtocolAdaptorDomain = "com.wily.introscope.agent";
    public static final String kProtocolAdaptorNameKey = "name";
    public static final String kProtocolAdaptorNameValue = "IntroscopeProtocolAdaptor";
    public static boolean kNoSubStringMatch = false;
    private static final String kExcludeStringMetricsPropKey = "introscope.agent.jmx.excludeStringMetrics";
    public static MBeanInterpreterJSR77 interpreterJSR77 = new MBeanInterpreterJSR77();
    public static final String kRateCounterExtension = "_rate (per interval)";
    private static final String kDescription = "Introscope JMX Agent Protocol Adaptor";
    private static final String kJMXBehaviorName = "Introscope JMX Protocol Adaptor";
    private static final String kMBeanServerDelegateName = "JMImplementation:type=MBeanServerDelegate";
    private static IAgent fAgent;
    private ObjectName fDelegateObjectName;
    private IMBeanNameConverter fPrimaryNameConverter;
    private IMBeanNameConverter fSecondaryNameConverter;
    private final IMBeanServerLocator[] fServerLocators;
    private Filter[] fFilters;
    private Filter[] fRateCounterFilters;
    private HashSet fIgnoreAttributes;
    private HashMap fViewsHashMap;
    private HashMap fEmptyViewsHashMap;
    private HashSet fServersHashSet;
    private final IntroscopeNotificationListener fNotificationListener;
    private final IntroscopeProtocolAdaptorHeartbeatBehavior fBehavior;
    private final ClassLoader fContextClassLoader;
    private IJMXCustomizer fJMXCustomizer = null;
    private static Object fSubject;
    private final FindServersAndPollViewsAction fFindServersAndPollViewsAction;
    private AccessControlContext fAccessControlContext;
    private boolean allowLegacyJSR77 = false;
    private boolean fExcludeStringMetrics;
    private String fSecurityClassName;
    private String fPrivelegedMethodName;
    private Method fPrivelegedMethod;
    private static final String kSyncWithAllMbeanServersForcibly = "com.wily.introcope.agent.jmx.syncWithAllMbeanServersForcibly";
    private static boolean fSyncWithAllMbeanServersForcibly;
    private static boolean fCanRunForcedDiscovery;
    private static long fLastTime;
    boolean fForceDebugToInfo = false;

    static {
        fSyncWithAllMbeanServersForcibly = false;
        fCanRunForcedDiscovery = false;
        fLastTime = 0L;
    }

    public IntroscopeProtocolAdaptor(IAgent agent) {
        this(agent, null);
    }

    public IntroscopeProtocolAdaptor(IAgent agent, IJMXCustomizer customizer) {
        this(agent, customizer, null, null, null, null);
    }

    public IntroscopeProtocolAdaptor(IAgent agent, IJMXCustomizer customizer, Object shouldBeSubject, String securityClassName, String privelegedMethodName, AccessControlContext acc) {
        this.fJMXCustomizer = customizer;
        fAgent = agent;
        this.fNotificationListener = new IntroscopeNotificationListener();
        fSubject = (Subject)shouldBeSubject;
        this.fSecurityClassName = securityClassName;
        this.fPrivelegedMethodName = privelegedMethodName;
        this.fAccessControlContext = acc;
        this.fServerLocators = this.fJMXCustomizer != null ? this.fJMXCustomizer.getMBeanServerLocators(fAgent) : new IMBeanServerLocator[]{new WebLogicMBeanServerLocator(agent), new StandardMBeanServerLocator()};
        try {
            this.fDelegateObjectName = new ObjectName(kMBeanServerDelegateName);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            Assertion.wilyAssert(false);
        }
        this.parseConfigProperties(agent.IAgent_getIndexedProperties());
        Assertion.wilyAssert(false);
        Assertion.wilyAssert(false);
        Assertion.wilyAssert(false);
        Assertion.wilyAssert(false);
        this.fViewsHashMap = new HashMap();
        this.fEmptyViewsHashMap = new HashMap();
        this.fServersHashSet = new HashSet();
        try {
            fAgent.IAgent_getConfigurationManager().add(new MBeanForcedPollingEnabledProperty(fAgent), false);
        }
        catch (Exception exception) {}
        this.fBehavior = new IntroscopeProtocolAdaptorHeartbeatBehavior();
        this.fContextClassLoader = this.getClass().getClassLoader();
        this.fFindServersAndPollViewsAction = new FindServersAndPollViewsAction();
        this.fExcludeStringMetrics = agent.IAgent_getIndexedProperties().getBooleanProperty(kExcludeStringMetricsPropKey, true);
        this.fExcludeStringMetrics = agent.IAgent_getIndexedProperties().getBooleanProperty(kExcludeStringMetricsPropKey, true);
        MBeanForcedDiscoveryControllingService mbeanForcedDiscoveryControllingBehavior = new MBeanForcedDiscoveryControllingService();
        agent.IAgent_getCommonHeartbeat().addBehavior((ITimestampedRunnable)mbeanForcedDiscoveryControllingBehavior, "MBean Forced Discovery Controlling Behaviour", true, 300000L, false);
    }

    private void parseConfigProperties(IndexedProperties props) {
        String[] defaultVal;
        String[] filterKeys = defaultVal = new String[0];
        String[] rateCounterFilterKeys = defaultVal;
        this.fIgnoreAttributes = new HashSet();
        String[] primaryKeys = defaultVal;
        String filterMessage = "";
        String primaryKeysMessage = "";
        boolean useJsr77Formatter = false;
        IModuleFeedbackChannel feedback = fAgent.IAgent_getModuleFeedback();
        IStringLocalizer localizer = fAgent.IAgent_getStringLocalizer();
        if (props != null) {
            useJsr77Formatter = !props.getBooleanProperty("introscope.agent.jmx.name.jsr77.disable", true);
            this.allowLegacyJSR77 = props.getBooleanProperty("introscope.agent.jmx.name.jsr77.legacy.enable", true);
            MBeanInterpreterJSR77.setEnabled(useJsr77Formatter);
            String[] ignoreAttributes = props.safeGetSeparatedProperty("introscope.agent.jmx.ignore.attributes", ",", defaultVal);
            int i = 0;
            while (i < ignoreAttributes.length) {
                this.fIgnoreAttributes.add(ignoreAttributes[i]);
                feedback.debug(sModule, "Ignoring MBean attribute: " + ignoreAttributes[i]);
                ++i;
            }
            filterKeys = props.safeGetSeparatedProperty("introscope.agent.jmx.name.filter", ",", defaultVal);
            rateCounterFilterKeys = props.safeGetSeparatedProperty("introscope.agent.jmx.ratecounter.name.filter", ",", defaultVal);
            primaryKeys = props.safeGetSeparatedProperty("introscope.agent.jmx.name.primarykeys", ",", defaultVal);
            kNoSubStringMatch = props.getBooleanProperty("introscope.agent.jmx.filter.nosubstringmatch", false);
            primaryKeysMessage = props.getTrimmedProperty("introscope.agent.jmx.name.primarykeys", "");
            filterMessage = props.getTrimmedProperty("introscope.agent.jmx.name.filter", "");
            fSyncWithAllMbeanServersForcibly = props.getBooleanProperty(kSyncWithAllMbeanServersForcibly);
        }
        if (this.fJMXCustomizer != null) {
            filterKeys = this.fJMXCustomizer.modifyFilters(fAgent, filterKeys);
            rateCounterFilterKeys = this.fJMXCustomizer.modifyFilters(fAgent, rateCounterFilterKeys);
        }
        this.fFilters = new Filter[filterKeys.length];
        int i = 0;
        while (i < filterKeys.length) {
            this.fFilters[i] = new Filter(filterKeys[i]);
            ++i;
        }
        this.fRateCounterFilters = new Filter[rateCounterFilterKeys.length];
        i = 0;
        while (i < rateCounterFilterKeys.length) {
            this.fRateCounterFilters[i] = new Filter(rateCounterFilterKeys[i]);
            ++i;
        }
        if (useJsr77Formatter) {
            this.fPrimaryNameConverter = new JSR77NameConverter(primaryKeys);
        } else {
            this.fPrimaryNameConverter = new PrimaryKeysNameConverter(primaryKeys);
            String localizedPrimaryKeysMessage = localizer.IStringLocalizer_getFormattedLocalizedString("Agent_JMX_Primary_Keys_Info_Message", primaryKeysMessage);
            feedback.info(localizedPrimaryKeysMessage);
        }
        this.fSecondaryNameConverter = new AllSortedKeysNameConverter();
        String localizedFilterMessage = localizer.IStringLocalizer_getFormattedLocalizedString("Agent_JMX_Filter_Info_Message", filterMessage);
        feedback.info(localizedFilterMessage);
    }

    void registerHeartbeatBehavior(IntervalHeartbeat heartbeat) {
        Assertion.wilyAssert(false);
        if (JMXDelegatingService.sIsJMXMaxPollDurationEnabled) {
            heartbeat.addBehavior((ITimestampedRunnable)this.fBehavior, kJMXBehaviorName, true, 15000L, false);
        } else {
            heartbeat.addBehavior((ITimestampedRunnable)this.fBehavior, kJMXBehaviorName, true, 7500L, false);
        }
    }

    @Override
    public String getDescription() {
        return kDescription;
    }

    public static String getIntroscopeProtocolAdaptorDomain() {
        return kProtocolAdaptorDomain;
    }

    public static ObjectName getIntroscopeProtocolAdaptorMBeanName() {
        try {
            return new ObjectName(kProtocolAdaptorDomain, kProtocolAdaptorNameKey, kProtocolAdaptorNameValue);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            Assertion.wilyAssert(false, "Protocol Adaptor name is malformed");
            return null;
        }
    }

    private void setContextAndPoll() {
        boolean isDebugEnabled;
        boolean allowForced;
        long startTime;
        block12: {
            startTime = System.currentTimeMillis();
            allowForced = fCanRunForcedDiscovery;
            isDebugEnabled = this.isDebugEnabled(sModule);
            if (isDebugEnabled) {
                this.debugTrace(sModule, "DIAG: setContextAndPoll entry called - fCanRunForcedDiscovery = " + allowForced);
            }
            Thread currentThread = Thread.currentThread();
            ClassLoader savedContext = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(this.fContextClassLoader);
                if (this.fAccessControlContext != null) {
                    AccessController.doPrivileged(this.fFindServersAndPollViewsAction, this.fAccessControlContext);
                    break block12;
                }
                if (fSubject == null) {
                    this.findServersAndPollViews();
                    break block12;
                }
                try {
                    Class<?> subjectClass = null;
                    subjectClass = Class.forName("javax.security.auth.Subject");
                    if (subjectClass.isInstance(fSubject)) {
                        if (this.fSecurityClassName != null && this.fPrivelegedMethodName != null) {
                            this.debugTrace(sModule, "Found Subject = " + fSubject);
                            Class<?> securityClass = Class.forName(this.fSecurityClassName);
                            if (this.fPrivelegedMethod == null) {
                                this.fPrivelegedMethod = securityClass.getMethod(this.fPrivelegedMethodName, subjectClass, PrivilegedAction.class);
                            }
                            this.fPrivelegedMethod.invoke(null, fSubject, this.fFindServersAndPollViewsAction);
                        }
                        break block12;
                    }
                    fAgent.IAgent_getModuleFeedback().error(sModule, "Got a Subject not an instance of javax.security.auth.Subject");
                }
                catch (Throwable t) {
                    fAgent.IAgent_getModuleFeedback().debug(sModule, "Unable to determine credentials, caught Throwable: ", t);
                }
            }
            finally {
                currentThread.setContextClassLoader(savedContext);
            }
        }
        long endTime = System.currentTimeMillis();
        if (isDebugEnabled) {
            this.debugTrace(sModule, "DIAG: setContextAndPoll exit called - fCanRunForcedDiscovery = " + allowForced + "(" + (endTime - startTime) + " uS)");
        }
    }

    private synchronized void findServersAndPollViews() {
        boolean canWeForce = fCanRunForcedDiscovery;
        boolean isDebugEnabled = this.isDebugEnabled(sModule);
        try {
            int locatorIndex = 0;
            while (locatorIndex < this.fServerLocators.length) {
                int serversLength;
                MBeanServer[] servers = this.fServerLocators[locatorIndex].IMBeanServerLocator_locate();
                int n = serversLength = servers != null ? servers.length : 0;
                if (serversLength > 0) {
                    long startTime = 0L;
                    long endTime = 0L;
                    if (isDebugEnabled) {
                        startTime = System.currentTimeMillis();
                    }
                    this.findAndAddMBeans(servers);
                    if (isDebugEnabled) {
                        endTime = System.currentTimeMillis();
                        this.debugTrace(sModule, "DIAG: findAndAddMBeans for '" + serversLength + "' servers took " + (endTime - startTime) + " uS");
                    }
                }
                ++locatorIndex;
            }
            long s2 = 0L;
            long e2 = 0L;
            if (isDebugEnabled) {
                s2 = System.currentTimeMillis();
            }
            this.pollViews();
            if (isDebugEnabled) {
                e2 = System.currentTimeMillis();
                this.debugTrace(sModule, "DIAG: pollViews took " + (e2 - s2) + " uS");
            }
            if (canWeForce) {
                this.DumpViewsStats();
            }
        }
        catch (Exception e) {
            fAgent.IAgent_getModuleFeedback().error("An error occurred polling JMX data.");
            fAgent.IAgent_getModuleFeedback().verbose(e);
        }
    }

    private void DumpViewsStats() {
        if (this.isDebugEnabled(sModule)) {
            Iterator objectNameItr = this.fViewsHashMap.keySet().iterator();
            this.debugTrace(sModule, "DIAG: Dump of JMX View ================================================================================");
            while (objectNameItr.hasNext()) {
                Object objName = objectNameItr.next();
                this.debugTrace(sModule, "DIAG: JMX Object Name [" + objName.toString() + "]");
                Set viewsHash = (Set)this.fViewsHashMap.get(objName);
                for (IJMXDataView view : viewsHash) {
                    this.debugTrace(sModule, "DIAG: JMX View: Average:" + view.getAveragePollTime() + " uS, Counts (" + view.getSuccessfulPollCount() + "/" + view.getPollCount() + ") Repeats (" + view.getRepeatedValuePollCount() + ") Name: '" + view.getFullMetricName() + "'");
                }
            }
            this.debugTrace(sModule, "DIAG: End dump of JMX View ================================================================================");
        }
    }

    private void findAndAddMBeans(MBeanServer[] servers) {
        if (servers.length == 0) {
            return;
        }
        boolean isDebugEnabled = this.isDebugEnabled(sModule);
        int addedBeans = 0;
        int serverII = 0;
        while (serverII < servers.length) {
            MBeanServer currentServer = servers[serverII];
            boolean newServer = false;
            if (!this.fServersHashSet.contains(currentServer)) {
                this.fServersHashSet.add(currentServer);
                try {
                    currentServer.addNotificationListener(this.fDelegateObjectName, this.fNotificationListener, null, (Object)currentServer);
                    newServer = true;
                    if (isDebugEnabled) {
                        this.debugTrace(sModule, "DIAG: add new server to list " + currentServer);
                    }
                }
                catch (InstanceNotFoundException instanceNotFoundException) {
                    Assertion.wilyAssert(false);
                }
            }
            if (newServer || fSyncWithAllMbeanServersForcibly && fCanRunForcedDiscovery) {
                long endTime;
                Set<Object> objectNames;
                block19: {
                    fCanRunForcedDiscovery = false;
                    objectNames = new HashSet();
                    try {
                        if (isDebugEnabled) {
                            this.debugTrace(sModule, "DIAG: query start " + currentServer.toString());
                        }
                        long startTime = 0L;
                        endTime = 0L;
                        if (isDebugEnabled) {
                            startTime = System.currentTimeMillis();
                        }
                        objectNames = currentServer.queryNames(null, null);
                        if (isDebugEnabled) {
                            endTime = System.currentTimeMillis();
                            this.debugTrace(sModule, "DIAG: queryNames took " + (endTime - startTime) + " uS");
                        }
                        if (isDebugEnabled) {
                            this.debugTrace(sModule, "DIAG: query  end  " + currentServer.toString() + " returned " + objectNames.size() + " object names");
                        }
                    }
                    catch (Exception e) {
                        if (!isDebugEnabled) break block19;
                        this.debugTrace(sModule, "Error querying the m bean server" + currentServer, e);
                    }
                }
                try {
                    long startTime = 0L;
                    endTime = 0L;
                    if (isDebugEnabled) {
                        startTime = System.currentTimeMillis();
                    }
                    Iterator iterator = objectNames.iterator();
                    while (iterator.hasNext()) {
                        if (!this.addMBean((ObjectName)iterator.next(), currentServer)) continue;
                        ++addedBeans;
                    }
                    if (isDebugEnabled) {
                        endTime = System.currentTimeMillis();
                        this.debugTrace(sModule, "DIAG: addMBean(s) took " + (endTime - startTime) + " uS");
                    }
                }
                catch (Exception exception) {}
            }
            ++serverII;
        }
        if (isDebugEnabled) {
            this.debugTrace(sModule, "DIAG: addedBeans = " + addedBeans);
        }
    }

    private void pollViews() {
        long accumulatedFailTime = 0L;
        long accumulatedExceptionTime = 0L;
        long longestTime = 0L;
        long shortestTime = 0L;
        String longestName = null;
        String shortestName = null;
        int totalIterations = 0;
        int totalObjectsIterated = 0;
        int transientFailures = 0;
        int exceptionFailures = 0;
        int objectNameRemovals = 0;
        int pollSkips = 0;
        int totalViews = 0;
        boolean isDebugEnabled = this.isDebugEnabled(sModule);
        boolean isTraceEnabled = fAgent.IAgent_getModuleFeedback().isTraceEnabled();
        Iterator objectNameItr = this.fViewsHashMap.keySet().iterator();
        while (objectNameItr.hasNext()) {
            Object objName = objectNameItr.next();
            Set viewsHash = (Set)this.fViewsHashMap.get(objName);
            Iterator iterator = viewsHash.iterator();
            if (isTraceEnabled) {
                fAgent.IAgent_getModuleFeedback().trace(sModule, "DIAG: viewsHash " + objName.toString() + " has " + viewsHash.size());
            }
            totalViews += viewsHash.size();
            ++totalObjectsIterated;
            while (iterator.hasNext()) {
                long timeTaken;
                ++totalIterations;
                IJMXDataView view = (IJMXDataView)iterator.next();
                try {
                    boolean didWork = view.IJMXDataView_update();
                    timeTaken = view.getLastPollTime();
                    if (timeTaken > longestTime) {
                        longestTime = timeTaken;
                        longestName = view.getFullMetricName();
                    }
                    if (timeTaken < shortestTime || shortestTime == 0L) {
                        shortestTime = timeTaken;
                        shortestName = view.getFullMetricName();
                    }
                    if (!didWork) {
                        if (isDebugEnabled) {
                            this.debugTrace(sModule, "JMX data unavailable for '" + view.getFullMetricName() + "', this may be a transient failure");
                            this.debugTrace(sModule, "DIAG: Total poll count: " + view.getPollCount() + " SuccessfulPollCount: " + view.getSuccessfulPollCount() + " and took " + timeTaken + " uS");
                            accumulatedFailTime += timeTaken;
                        }
                        view.IJMXDataView_clear();
                        ++transientFailures;
                        continue;
                    }
                    if (isTraceEnabled) {
                        fAgent.IAgent_getModuleFeedback().trace(sModule, "JMX data available for '" + view.getFullMetricName());
                    }
                    if (!view.wasLastPollSkipped()) continue;
                    ++pollSkips;
                }
                catch (Throwable t) {
                    timeTaken = view.getLastPollTime();
                    accumulatedExceptionTime += timeTaken;
                    if (timeTaken > longestTime) {
                        longestTime = timeTaken;
                        longestName = view.getFullMetricName();
                    }
                    if (timeTaken < shortestTime || shortestTime == 0L) {
                        shortestTime = timeTaken;
                        shortestName = view.getFullMetricName();
                    }
                    if (isDebugEnabled) {
                        this.debugTrace(sModule, "Error getting MBean info, this may be a transient failure '" + view.getFullMetricName() + "' " + t.toString());
                    }
                    if (isTraceEnabled) {
                        fAgent.IAgent_getModuleFeedback().trace(sModule, view.getFullMetricName(), t);
                    }
                    view.IJMXDataView_destroy();
                    iterator.remove();
                    ++exceptionFailures;
                }
            }
            if (!viewsHash.isEmpty()) continue;
            if (isDebugEnabled) {
                this.debugTrace(sModule, "DIAG: clear for '" + objName.toString() + "'");
            }
            objectNameItr.remove();
            ++objectNameRemovals;
        }
        if (isDebugEnabled) {
            this.debugTrace(sModule, "DIAG: total viewsHash = " + totalViews);
            this.debugTrace(sModule, "DIAG: longest poll = " + longestTime + " uS " + longestName);
            this.debugTrace(sModule, "DIAG: shortest poll = " + shortestTime + " uS " + shortestName);
            this.debugTrace(sModule, "DIAG: total poll time for transient fails = " + accumulatedFailTime + " uS");
            this.debugTrace(sModule, "DIAG: total poll time for exception fails = " + accumulatedExceptionTime + " uS");
            this.debugTrace(sModule, "DIAG: total object iterations = " + totalObjectsIterated);
            this.debugTrace(sModule, "DIAG: total view iterations = " + totalIterations);
            this.debugTrace(sModule, "DIAG: transientFailures = " + transientFailures);
            this.debugTrace(sModule, "DIAG: exceptionFailures = " + exceptionFailures);
            this.debugTrace(sModule, "DIAG: objectNameRemovals = " + objectNameRemovals);
            this.debugTrace(sModule, "DIAG: pollSkips = " + pollSkips);
        }
    }

    private void addMBean2(ObjectName objectName, MBeanServer server) {
        if (this.fAccessControlContext != null) {
            AccessController.doPrivileged(new AddMBeanAction(objectName, server), this.fAccessControlContext);
        } else if (fSubject == null) {
            this.addMBean(objectName, server);
        } else {
            try {
                Class<?> subjectClass = null;
                subjectClass = Class.forName("javax.security.auth.Subject");
                if (subjectClass.isInstance(fSubject)) {
                    if (this.fSecurityClassName != null && this.fPrivelegedMethodName != null) {
                        fAgent.IAgent_getModuleFeedback().info(sModule, "Found Subject = " + fSubject);
                        Class<?> securityClass = Class.forName(this.fSecurityClassName);
                        if (this.fPrivelegedMethod == null) {
                            this.fPrivelegedMethod = securityClass.getMethod(this.fPrivelegedMethodName, subjectClass, PrivilegedAction.class);
                        }
                        this.fPrivelegedMethod.invoke(null, fSubject, new AddMBeanAction(objectName, server));
                        this.debugTrace(sModule, "Successfully invoked javax.security.auth.Subject.doAs(subject, AddMBeanAction)");
                    }
                } else {
                    fAgent.IAgent_getModuleFeedback().info(sModule, "Got a Subject not an instance of javax.security.auth.Subject");
                }
            }
            catch (Throwable t) {
                fAgent.IAgent_getModuleFeedback().info(sModule, "Unable to determine credentials, caught Throwable: ", t);
            }
        }
    }

    private void removeMBean2(ObjectName objectName, MBeanServer server) {
        if (this.fAccessControlContext != null) {
            AccessController.doPrivileged(new RemoveMBeanAction(objectName, server), this.fAccessControlContext);
        } else if (fSubject == null) {
            this.removeMBean(objectName, server);
        } else {
            try {
                Class<?> subjectClass = null;
                subjectClass = Class.forName("javax.security.auth.Subject");
                if (subjectClass.isInstance(fSubject)) {
                    if (this.fSecurityClassName != null && this.fPrivelegedMethodName != null) {
                        fAgent.IAgent_getModuleFeedback().info(sModule, "Found Subject = " + fSubject);
                        Class<?> securityClass = Class.forName(this.fSecurityClassName);
                        if (this.fPrivelegedMethod == null) {
                            this.fPrivelegedMethod = securityClass.getMethod(this.fPrivelegedMethodName, subjectClass, PrivilegedAction.class);
                        }
                        this.fPrivelegedMethod.invoke(null, fSubject, new RemoveMBeanAction(objectName, server));
                        this.debugTrace(sModule, "Successfully invoked javax.security.auth.Subject.doAs(subject, RemoveMBeanAction)");
                    }
                } else {
                    fAgent.IAgent_getModuleFeedback().info(sModule, "Got a Subject not an instance of javax.security.auth.Subject");
                }
            }
            catch (Throwable t) {
                fAgent.IAgent_getModuleFeedback().info(sModule, "Unable to determine credentials, caught Throwable: ", t);
            }
        }
    }

    private synchronized boolean addMBean(ObjectName objectName, MBeanServer server) {
        MBeanNotificationInfo[] notificationList;
        boolean isDebugEnabled = this.isDebugEnabled(sModule);
        String domain = objectName.getDomain();
        if (domain != null && IntroscopeProtocolAdaptor.getIntroscopeProtocolAdaptorDomain().equals(domain)) {
            return false;
        }
        if (objectName.isPattern()) {
            return false;
        }
        if (objectName.equals(this.fDelegateObjectName)) {
            return false;
        }
        if (this.haveAlreadySeenObjectName(objectName)) {
            return false;
        }
        if (this.haveAlreadySeenObjectNameWithEmptyViews(objectName)) {
            return false;
        }
        if (isDebugEnabled) {
            this.debugTrace(sModule, "DIAG: adding '" + objectName.toString() + "'");
        }
        String resourceName = this.getIntroscopeResourceName(objectName);
        MBeanInfo beanInfo = null;
        try {
            beanInfo = server.getMBeanInfo(objectName);
        }
        catch (Exception e) {
            if (isDebugEnabled) {
                this.debugTrace(sModule, "Error getting MBeanInfo", e);
            }
            return false;
        }
        if (beanInfo == null) {
            if (isDebugEnabled) {
                this.debugTrace(sModule, "DIAG: no bean info for '" + objectName.toString());
            }
            return false;
        }
        MBeanAttributeInfo[] attInfo = beanInfo.getAttributes();
        if (attInfo == null) {
            if (isDebugEnabled) {
                this.debugTrace(sModule, "DIAG: no bean attributes for '" + objectName.toString());
            }
            return false;
        }
        if (isDebugEnabled && (notificationList = beanInfo.getNotifications()) != null) {
            int nl = 0;
            while (nl < notificationList.length) {
                this.debugTrace(sModule, "DIAG: notification info for '" + objectName.toString() + "' has " + ((Object)notificationList[nl]).toString());
                ++nl;
            }
        }
        HashSet<AJMXDataView> viewsSet = new HashSet<AJMXDataView>();
        int attributeII = 0;
        while (attributeII < attInfo.length) {
            block38: {
                if (attInfo[attributeII].isReadable()) {
                    String attName = attInfo[attributeII].getName();
                    String attType = attInfo[attributeII].getType();
                    if (attName == null || attType == null) {
                        if (isDebugEnabled) {
                            this.debugTrace(sModule, "DIAG: attribute name or type was null " + attName + " : " + attType);
                        }
                    } else {
                        StringBuffer tmpName = new StringBuffer(resourceName);
                        tmpName.append(':');
                        tmpName.append(attName);
                        ANameConverter.replaceTrailingWhitespace(tmpName);
                        String fullIntroscopeMetricName = tmpName.toString();
                        boolean bShouldPollMetric = this.shouldPollMetric(fullIntroscopeMetricName, attName);
                        boolean bShouldPollRateCounterMetric = false;
                        bShouldPollRateCounterMetric = this.shouldPollRateCounterMetric(fullIntroscopeMetricName, attName);
                        if (bShouldPollMetric || bShouldPollRateCounterMetric) {
                            try {
                                boolean isLegacyJSR77;
                                if (interpreterJSR77.isAvailable() && interpreterJSR77.isQualified(attType)) {
                                    int colonPos = fullIntroscopeMetricName.lastIndexOf(":");
                                    String rootIntroscopeMetricName = colonPos < 0 ? fullIntroscopeMetricName : fullIntroscopeMetricName.substring(0, colonPos);
                                    MBeanInterpreterJMXDataView view = null;
                                    if (!this.haveAlreadySeenObjectName(objectName)) {
                                        if (bShouldPollMetric && (view = new MBeanInterpreterJMXDataView(fAgent, objectName, server, attName, rootIntroscopeMetricName, interpreterJSR77, false)) != null) {
                                            if (isDebugEnabled) {
                                                this.debugTrace(sModule, "DIAG: new polled MBeanInterpreterJMXDataView + " + fullIntroscopeMetricName);
                                            }
                                            viewsSet.add(view);
                                        }
                                        if (bShouldPollRateCounterMetric && (view = new MBeanInterpreterJMXDataView(fAgent, objectName, server, attName, rootIntroscopeMetricName = String.valueOf(rootIntroscopeMetricName) + kRateCounterExtension, interpreterJSR77, true)) != null) {
                                            if (isDebugEnabled) {
                                                this.debugTrace(sModule, "DIAG: new rate counter MBeanInterpreterJMXDataView + " + fullIntroscopeMetricName);
                                            }
                                            viewsSet.add(view);
                                        }
                                    }
                                    break block38;
                                }
                                boolean bl = isLegacyJSR77 = fullIntroscopeMetricName.indexOf("|JSR77|") >= 0;
                                if (!this.allowLegacyJSR77 && isLegacyJSR77) break block38;
                                AJMXDataView view = null;
                                if (this.haveAlreadySeenObjectName(objectName)) break block38;
                                try {
                                    if (bShouldPollMetric && (view = DataViewFactory.createView(fAgent, objectName, attType, attName, server, fullIntroscopeMetricName, this.fExcludeStringMetrics, false)) != null) {
                                        if (isDebugEnabled) {
                                            this.debugTrace(sModule, "DIAG: new legacy polled view (" + attType + ") " + fullIntroscopeMetricName);
                                        }
                                        viewsSet.add(view);
                                    }
                                    if (bShouldPollRateCounterMetric && (view = DataViewFactory.createView(fAgent, objectName, attType, attName, server, fullIntroscopeMetricName = String.valueOf(fullIntroscopeMetricName) + kRateCounterExtension, this.fExcludeStringMetrics, true)) != null) {
                                        if (isDebugEnabled) {
                                            this.debugTrace(sModule, "DIAG: new legacy rate counter polled view (" + attType + ") " + fullIntroscopeMetricName);
                                        }
                                        viewsSet.add(view);
                                    }
                                }
                                catch (AccumulatorAlreadyExistsException ae) {
                                    if (isDebugEnabled) {
                                        this.debugTrace(sModule, ae.getLocalizedMessage());
                                    }
                                }
                            }
                            catch (Exception e) {
                                IStringLocalizer localizer = fAgent.IAgent_getStringLocalizer();
                                String message = localizer.IStringLocalizer_getFormattedLocalizedString("Agent_JMX_Could_Not_Create_View_Message", fullIntroscopeMetricName, String.valueOf(objectName.toString()) + " " + attName + " " + attType);
                                fAgent.IAgent_safeReportError(message, (Throwable)e);
                            }
                        }
                    }
                }
            }
            ++attributeII;
        }
        if (viewsSet.size() == 0) {
            if (isDebugEnabled) {
                this.debugTrace(sModule, "DIAG: adding empty viewsSet for:" + objectName);
            }
            this.addEmptyView(objectName);
            return false;
        }
        return this.addViews(objectName, viewsSet);
    }

    private boolean shouldPollMetric(String metricName, String attName) {
        Assertion.wilyAssert(false);
        Assertion.wilyAssert(false);
        if (this.fIgnoreAttributes.contains(attName)) {
            return false;
        }
        if (this.fFilters.length == 0) {
            return true;
        }
        int i = 0;
        while (i < this.fFilters.length) {
            Filter filter = this.fFilters[i];
            if (filter.matches(metricName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean shouldPollRateCounterMetric(String metricName, String attName) {
        Assertion.wilyAssert(false);
        if (!JMXDelegatingService.sIsJMXRateCounterEnabled) {
            return false;
        }
        if (this.fRateCounterFilters.length == 0) {
            return this.shouldPollMetric(metricName, attName);
        }
        int i = 0;
        while (i < this.fRateCounterFilters.length) {
            Filter filter = this.fRateCounterFilters[i];
            if (filter.matches(metricName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private String getIntroscopeResourceName(ObjectName on) {
        String result = null;
        if (this.fPrimaryNameConverter.IMBeanNameConverter_canConvert(on)) {
            result = this.fPrimaryNameConverter.IMBeanNameConverter_convert(on);
        } else {
            Assertion.wilyAssert(false);
            result = this.fSecondaryNameConverter.IMBeanNameConverter_convert(on);
        }
        return result;
    }

    private synchronized boolean addViews(ObjectName on, Set viewsSet) {
        if (!this.haveAlreadySeenObjectName(on)) {
            Assertion.wilyAssert(false);
            this.fViewsHashMap.put(on, viewsSet);
            return true;
        }
        return false;
    }

    private synchronized boolean addEmptyView(ObjectName on) {
        if (!this.haveAlreadySeenObjectNameWithEmptyViews(on)) {
            this.fEmptyViewsHashMap.put(on, null);
            return true;
        }
        return false;
    }

    private synchronized HashSet removeViews(ObjectName on) {
        Assertion.wilyAssert(false);
        return (HashSet)this.fViewsHashMap.remove(on);
    }

    private synchronized HashSet removeEmptyViews(ObjectName on) {
        Assertion.wilyAssert(false);
        return (HashSet)this.fEmptyViewsHashMap.remove(on);
    }

    private synchronized boolean haveAlreadySeenObjectName(ObjectName on) {
        return this.fViewsHashMap.containsKey(on);
    }

    private synchronized boolean haveAlreadySeenObjectNameWithEmptyViews(ObjectName on) {
        return this.fEmptyViewsHashMap.containsKey(on);
    }

    private synchronized void removeMBean(ObjectName on, MBeanServer server) {
        Iterator iterator;
        boolean isDebugEnabled = this.isDebugEnabled(sModule);
        boolean isTraceEnabled = fAgent.IAgent_getModuleFeedback().isTraceEnabled(sModule);
        HashSet views = this.removeViews(on);
        HashSet emptyViews = this.removeEmptyViews(on);
        if (views != null) {
            if (isDebugEnabled) {
                this.debugTrace(sModule, "DIAG: removeMBean " + (on != null ? on.toString() : "null object") + " with " + views.size() + " views");
            }
            iterator = views.iterator();
            while (iterator.hasNext()) {
                IJMXDataView view = (IJMXDataView)iterator.next();
                if (isTraceEnabled) {
                    fAgent.IAgent_getModuleFeedback().trace(sModule, "DIAG: removeMBean removing view " + view.getFullMetricName() + "  " + views.size());
                }
                view.IJMXDataView_destroy();
                iterator.remove();
            }
        }
        if (emptyViews != null) {
            if (isDebugEnabled) {
                this.debugTrace(sModule, "DIAG: removeMBean " + (on != null ? on.toString() : "null object") + " with no view set");
            }
            iterator = emptyViews.iterator();
            while (iterator.hasNext()) {
                iterator.remove();
            }
        }
    }

    boolean isDebugEnabled(Module sModule) {
        return this.fForceDebugToInfo || fAgent.IAgent_getModuleFeedback().isDebugEnabled(sModule);
    }

    void debugTrace(Module module, String string) {
        if (this.fForceDebugToInfo) {
            fAgent.IAgent_getModuleFeedback().info(module, string);
        } else {
            fAgent.IAgent_getModuleFeedback().debug(module, string);
        }
    }

    void debugTrace(Module module, String string, Throwable t) {
        if (this.fForceDebugToInfo) {
            fAgent.IAgent_getModuleFeedback().info(module, string, t);
        } else {
            fAgent.IAgent_getModuleFeedback().debug(module, string, t);
        }
    }

    void debug_ForceDebugAtInfo(boolean value) {
        this.fForceDebugToInfo = value;
    }

    IMBeanNameConverter debug_getSecondaryNameConverter() {
        return this.fSecondaryNameConverter;
    }

    int debug_getNumberOfMBeans() {
        return this.fViewsHashMap.size();
    }

    int debug_getNumberOfViewsForMBean(ObjectName on, MBeanServer server) {
        HashSet views = (HashSet)this.fViewsHashMap.get(on);
        return views.size();
    }

    boolean debug_locatedMBeanServer(MBeanServer server) {
        return this.fServersHashSet.contains(server);
    }

    int debug_getNumberLocatedMBeanServers() {
        return this.fServersHashSet.size();
    }

    void debug_parseConfigProperties(IndexedProperties props) {
        this.parseConfigProperties(props);
    }

    boolean debug_shouldPollMetric(String fullIntroscopeMetricName) {
        return this.shouldPollMetric(fullIntroscopeMetricName, null);
    }

    void debug_findServersAndPollViews() {
        this.setContextAndPoll();
    }

    void debug_DumpViewsStats() {
        this.DumpViewsStats();
    }

    private class AddMBeanAction
    implements PrivilegedAction {
        final ObjectName fObjectName;
        final MBeanServer fMBeanServer;

        private AddMBeanAction(ObjectName objectName, MBeanServer server) {
            this.fObjectName = objectName;
            this.fMBeanServer = server;
        }

        public Object run() {
            IntroscopeProtocolAdaptor.this.addMBean(this.fObjectName, this.fMBeanServer);
            return null;
        }
    }

    private class FindServersAndPollViewsAction
    implements PrivilegedAction {
        private FindServersAndPollViewsAction() {
        }

        public Object run() {
            IntroscopeProtocolAdaptor.this.findServersAndPollViews();
            return null;
        }
    }

    private final class IntroscopeNotificationListener
    implements NotificationListener {
        private IntroscopeNotificationListener() {
        }

        @Override
        public void handleNotification(Notification notification, final Object server) {
            try {
                boolean isDebugEnabled = IntroscopeProtocolAdaptor.this.isDebugEnabled(sModule);
                Assertion.wilyAssert(false);
                Assertion.wilyAssert(false);
                if (notification instanceof MBeanServerNotification) {
                    final MBeanServerNotification mbsn = (MBeanServerNotification)notification;
                    if (mbsn.getType().equals("JMX.mbean.registered")) {
                        if (isDebugEnabled) {
                            IntroscopeProtocolAdaptor.this.debugTrace(sModule, "DIAG: MBeanServerNotification.REGISTRATION_NOTIFICATION");
                        }
                        fAgent.IAgent_getSharedAsyncQueue().IExecutionQueue_addExecutableItem(new ASimpleExecutableItem(){

                            @Override
                            public void IExecutableItem_execute() {
                                IntroscopeProtocolAdaptor.this.addMBean2(mbsn.getMBeanName(), (MBeanServer)server);
                            }
                        });
                    } else if (notification.getType().equals("JMX.mbean.unregistered")) {
                        if (isDebugEnabled) {
                            IntroscopeProtocolAdaptor.this.debugTrace(sModule, "DIAG: MBeanServerNotification.UNREGISTRATION_NOTIFICATION");
                        }
                        fAgent.IAgent_getSharedAsyncQueue().IExecutionQueue_addExecutableItem(new ASimpleExecutableItem(){

                            @Override
                            public void IExecutableItem_execute() {
                                IntroscopeProtocolAdaptor.this.removeMBean2(mbsn.getMBeanName(), (MBeanServer)server);
                            }
                        });
                    } else if (isDebugEnabled) {
                        IntroscopeProtocolAdaptor.this.debugTrace(sModule, "DIAG: MBeanServerNotification = " + mbsn.getType());
                    }
                } else if (isDebugEnabled) {
                    if (notification instanceof AttributeChangeNotification) {
                        IntroscopeProtocolAdaptor.this.debugTrace(sModule, "DIAG: JMX Notification AttributeChangeNotification from " + notification.getSource().toString());
                    } else if (notification instanceof MonitorNotification) {
                        IntroscopeProtocolAdaptor.this.debugTrace(sModule, "DIAG: JMX Notification MonitorNotification from " + notification.getSource().toString());
                    } else if (notification instanceof RelationNotification) {
                        IntroscopeProtocolAdaptor.this.debugTrace(sModule, "DIAG: JMX Notification RelationNotification from " + notification.getSource().toString());
                    } else if (notification instanceof TimerNotification) {
                        IntroscopeProtocolAdaptor.this.debugTrace(sModule, "DIAG: JMX Notification TimerNotification from " + notification.getSource().toString());
                    } else if (notification instanceof Notification) {
                        IntroscopeProtocolAdaptor.this.debugTrace(sModule, "DIAG: JMX Notification - javax.management.Notification from " + notification.getSource().toString());
                        IntroscopeProtocolAdaptor.this.debugTrace(sModule, "DIAG: JMX Notification - javax.management.Notification value " + notification.getMessage().toString());
                    } else {
                        IntroscopeProtocolAdaptor.this.debugTrace(sModule, "DIAG: JMX Notification UNKNOWN!" + notification.getClass().toString());
                    }
                }
            }
            catch (Throwable t) {
                try {
                    fAgent.IAgent_safeReportError(fAgent.IAgent_getStringLocalizer().IStringLocalizer_getLocalizedString("Agent_JMX_Error_Handling_Notification_Message"), t);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private final class IntroscopeProtocolAdaptorHeartbeatBehavior
    implements ITimestampedRunnable {
        private IntroscopeProtocolAdaptorHeartbeatBehavior() {
        }

        @Override
        public void ITimestampedRunnable_execute(long nowInMillis) {
            IntroscopeProtocolAdaptor.this.setContextAndPoll();
        }
    }

    private final class MBeanForcedDiscoveryControllingService
    implements ITimestampedRunnable {
        private MBeanForcedDiscoveryControllingService() {
        }

        @Override
        public void ITimestampedRunnable_execute(long nowInMillis) {
            fCanRunForcedDiscovery = true;
            long interval = nowInMillis - fLastTime;
            if (fLastTime == 0L) {
                interval = 0L;
            }
            if (IntroscopeProtocolAdaptor.this.isDebugEnabled(sModule)) {
                IntroscopeProtocolAdaptor.this.debugTrace(sModule, "DIAG: MBeanForcedDiscoveryControllingService called - fCanRunForcedDiscovery = " + fCanRunForcedDiscovery + "(" + interval + " mS)");
            }
            fLastTime = nowInMillis;
        }
    }

    static final class MBeanForcedPollingEnabledProperty
    extends BooleanConfigurationProperty {
        public MBeanForcedPollingEnabledProperty(IAgent agent) {
            super(IntroscopeProtocolAdaptor.kSyncWithAllMbeanServersForcibly, Boolean.FALSE, fAgent.IAgent_getModuleFeedback(), sModule, fAgent.IAgent_getStringLocalizer());
        }

        @Override
        public void set(Object newValue) {
            fSyncWithAllMbeanServersForcibly = (Boolean)newValue;
        }
    }

    private class RemoveMBeanAction
    implements PrivilegedAction {
        final ObjectName fObjectName;
        final MBeanServer fMBeanServer;

        private RemoveMBeanAction(ObjectName objectName, MBeanServer server) {
            this.fObjectName = objectName;
            this.fMBeanServer = server;
        }

        public Object run() {
            IntroscopeProtocolAdaptor.this.removeMBean(this.fObjectName, this.fMBeanServer);
            return null;
        }
    }
}

