/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.jmx;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.jmx.AJMXDataView;
import com.wily.introscope.agent.stat.AccumulatorAlreadyExistsException;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.agent.stat.ILongFluctuatingCounterDataAccumulator;
import com.wily.introscope.spec.metric.BadlyFormedNameException;
import com.wily.introscope.spec.metric.ConflictingTypesException;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public final class LongJMXDataView
extends AJMXDataView {
    private ILongFluctuatingCounterDataAccumulator fAccumulator;
    private String fFullIntroscopeMetricName;
    private long fLastValue = 0L;
    private long fCurrentValue = 0L;
    private boolean fWasSame = false;

    public LongJMXDataView(IAgent agent, ObjectName on, MBeanServer server, String attributeName, String fullIntroscopeMetricName) {
        super(agent, on, server, attributeName);
        this.fFullIntroscopeMetricName = fullIntroscopeMetricName;
    }

    @Override
    protected void doUpdate(Object currentValue) throws BadlyFormedNameException, ConflictingTypesException, AccumulatorAlreadyExistsException {
        Number numberValue;
        if (currentValue instanceof Attribute) {
            Attribute att = (Attribute)currentValue;
            numberValue = (Number)att.getValue();
        } else {
            numberValue = (Number)currentValue;
        }
        long longValue = numberValue.longValue();
        ILongFluctuatingCounterDataAccumulator accumulator = this.getTypedAccumulator();
        if (accumulator != null) {
            this.fLastValue = this.fCurrentValue;
            this.fCurrentValue = longValue;
            boolean bl = this.fWasSame = this.fCurrentValue == this.fLastValue;
            if (this.fWasSame) {
                this.setSawSameValue();
            } else {
                this.resetSawSameValue();
            }
            accumulator.ILongCounterDataAccumulator_setValue(longValue);
        }
    }

    @Override
    protected IDataAccumulator getAccumulator(boolean forceCreate) throws BadlyFormedNameException, ConflictingTypesException, AccumulatorAlreadyExistsException {
        if (forceCreate && this.fAccumulator == null) {
            this.fAccumulator = this.getAgent().IAgent_getDataAccumulatorFactory().createLongFluctuatingCounterDataAccumulator(this.fFullIntroscopeMetricName);
        }
        return this.fAccumulator;
    }

    private ILongFluctuatingCounterDataAccumulator getTypedAccumulator() throws BadlyFormedNameException, ConflictingTypesException, AccumulatorAlreadyExistsException {
        return (ILongFluctuatingCounterDataAccumulator)this.getAccumulator(true);
    }

    @Override
    protected void doDestroy() {
        try {
            if (this.fAccumulator != null) {
                this.getAgent().IAgent_getDataAccumulatorFactory().removeDataAccumulator((IDataAccumulator)this.fAccumulator);
            }
        }
        finally {
            this.fAccumulator = null;
        }
    }

    @Override
    public String getFullMetricName() {
        return this.fFullIntroscopeMetricName;
    }
}

