/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.webappsupport.weblogic;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.environment.CallbackFailedPermanentlyException;
import com.wily.introscope.agent.environment.CallbackFailedTemporarilyException;
import com.wily.introscope.agent.webappsupport.AWebAppAgentNamer;
import com.wily.introscope.agent.webappsupport.weblogic.WebLogicMBeanHelper;
import com.wily.util.StringUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.text.ILocalizableMessage;
import com.wily.util.text.SimpleLocalizableMessage;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class WebLogicAgentNamer
extends AWebAppAgentNamer {
    IModuleFeedbackChannel fFeedback = this.getAgent().IAgent_getModuleFeedback();

    public WebLogicAgentNamer(IAgent agent) {
        super(agent);
    }

    public String IAppserverEnvironmentInfoCallback_getAgentName() throws CallbackFailedTemporarilyException, CallbackFailedPermanentlyException {
        String serverName = System.getProperty("weblogic.Name");
        if (StringUtils.isEmpty(serverName)) {
            throw new CallbackFailedTemporarilyException((ILocalizableMessage)new SimpleLocalizableMessage("WebLogic_Server_System_Property_Missing_Or_Empty_Message"));
        }
        String agentName = this.getNameFromRuntimeServiceMBean();
        if (agentName == null && (agentName = this.getNameFromMBeanHome(serverName)) == null) {
            throw new CallbackFailedTemporarilyException((ILocalizableMessage)new SimpleLocalizableMessage("Null_WebLogic_Home_MBean_And_Runtime_MBean_Server_Message"));
        }
        return agentName;
    }

    private String getNameFromMBeanHome(String serverName) throws CallbackFailedTemporarilyException, CallbackFailedPermanentlyException {
        String domainName = null;
        String clusterName = null;
        Object home = WebLogicMBeanHelper.getMBeanHome();
        if (home == null) {
            return null;
        }
        domainName = this.getDomainName(home);
        clusterName = this.getClusterName(home, serverName);
        return StringUtils.concatAndEscapeStrings(domainName, clusterName, serverName, '/', '_');
    }

    private String getNameFromRuntimeServiceMBean() {
        String resultName;
        block15: {
            InitialContext context = null;
            MBeanServer resultServer = null;
            String serverName = null;
            String domainName = null;
            String clusterName = null;
            resultName = null;
            try {
                try {
                    context = new InitialContext();
                    resultServer = (MBeanServer)context.lookup("java:comp/jmx/runtime");
                    if (resultServer == null) {
                        throw new CallbackFailedTemporarilyException((ILocalizableMessage)new SimpleLocalizableMessage("Null_WebLogic_Runtime_MBean_Server_Message"));
                    }
                    ObjectName rs = new ObjectName("com.bea:Name=RuntimeService,Type=weblogic.management.mbeanservers.runtime.RuntimeServiceMBean");
                    serverName = (String)resultServer.getAttribute(rs, "ServerName");
                    this.fFeedback.debug("WLAN: server name = -->" + (serverName == null ? "null" : serverName) + "<--");
                    ObjectName domainMBean = (ObjectName)resultServer.getAttribute(rs, "DomainConfiguration");
                    domainName = (String)resultServer.getAttribute(domainMBean, "Name");
                    this.fFeedback.debug("WLAN: domain name = -->" + (domainName == null ? "null" : domainName) + "<--");
                    ObjectName serverMBeanON = (ObjectName)resultServer.getAttribute(rs, "ServerConfiguration");
                    ObjectName clusterMBeanON = (ObjectName)resultServer.getAttribute(serverMBeanON, "Cluster");
                    if (clusterMBeanON != null) {
                        clusterName = (String)resultServer.getAttribute(clusterMBeanON, "Name");
                        this.fFeedback.debug("WLAN: cluster name = -->" + (clusterName == null ? "null" : clusterName) + "<--");
                    } else {
                        this.fFeedback.debug("cluster name is null");
                    }
                    resultName = StringUtils.concatAndEscapeStrings(domainName, clusterName, serverName, '/', '_');
                    this.fFeedback.debug("WLAN: result name = -->" + (resultName == null ? "null" : resultName) + "<--");
                }
                catch (Exception e) {
                    this.fFeedback.debug("caught exception trying to determine agent name.", e);
                    if (context == null) break block15;
                    try {
                        context.close();
                    }
                    catch (NamingException e2) {
                        this.fFeedback.debug("could not close context.", e2);
                    }
                }
            }
            finally {
                if (context != null) {
                    try {
                        context.close();
                    }
                    catch (NamingException e) {
                        this.fFeedback.debug("could not close context.", e);
                    }
                }
            }
        }
        return resultName;
    }

    private String getClusterName(Object mBeanHome, String serverName) throws CallbackFailedTemporarilyException, CallbackFailedPermanentlyException {
        Method getNameMethod;
        Object clusterObject;
        block25: {
            Class<?> clusterClass;
            block24: {
                block23: {
                    Method getClusterMethod;
                    Object serverMBeanObject;
                    block22: {
                        Class<?> serverMBeanClass;
                        block21: {
                            block20: {
                                Method getLocalServerMethod;
                                Object adminObj;
                                block19: {
                                    Class<?> adminObjClass;
                                    block18: {
                                        block17: {
                                            Method getInstanceMethod;
                                            block16: {
                                                Class<?> adminClass;
                                                block15: {
                                                    adminClass = Class.forName("weblogic.management.Admin");
                                                    if (adminClass != null) break block15;
                                                    return null;
                                                }
                                                getInstanceMethod = adminClass.getMethod("getInstance", new Class[0]);
                                                if (getInstanceMethod != null && Modifier.isStatic(getInstanceMethod.getModifiers())) break block16;
                                                return null;
                                            }
                                            adminObj = getInstanceMethod.invoke(null, new Object[0]);
                                            if (adminObj != null) break block17;
                                            return null;
                                        }
                                        adminObjClass = adminObj.getClass();
                                        if (adminObjClass != null) break block18;
                                        return null;
                                    }
                                    getLocalServerMethod = adminObjClass.getMethod("getLocalServer", new Class[0]);
                                    if (getLocalServerMethod != null && !Modifier.isStatic(getLocalServerMethod.getModifiers())) break block19;
                                    return null;
                                }
                                serverMBeanObject = getLocalServerMethod.invoke(adminObj, new Object[0]);
                                if (serverMBeanObject != null) break block20;
                                return null;
                            }
                            serverMBeanClass = serverMBeanObject.getClass();
                            if (serverMBeanClass != null) break block21;
                            return null;
                        }
                        getClusterMethod = serverMBeanClass.getMethod("getCluster", new Class[0]);
                        if (getClusterMethod != null && !Modifier.isStatic(getClusterMethod.getModifiers())) break block22;
                        return null;
                    }
                    clusterObject = getClusterMethod.invoke(serverMBeanObject, new Object[0]);
                    if (clusterObject != null) break block23;
                    return null;
                }
                clusterClass = clusterObject.getClass();
                if (clusterClass != null) break block24;
                return null;
            }
            getNameMethod = clusterClass.getMethod("getName", new Class[0]);
            if (getNameMethod != null && !Modifier.isStatic(getNameMethod.getModifiers())) break block25;
            return null;
        }
        try {
            String clusterName = (String)getNameMethod.invoke(clusterObject, new Object[0]);
            return clusterName;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            return null;
        }
        catch (Exception e) {
            this.fFeedback.warn("caught exception trying to determine cluster name.", e);
            return null;
        }
    }

    private String getDomainName(Object home) throws CallbackFailedPermanentlyException {
        Method getNameMethod;
        Method getActiveDomainMethod;
        if (home == null) {
            return null;
        }
        Class<?> homeClass = home.getClass();
        try {
            getActiveDomainMethod = homeClass.getMethod("getActiveDomain", new Class[0]);
        }
        catch (Exception e) {
            throw new CallbackFailedPermanentlyException((Throwable)e);
        }
        if (getActiveDomainMethod == null || Modifier.isStatic(getActiveDomainMethod.getModifiers())) {
            throw new CallbackFailedPermanentlyException((ILocalizableMessage)new SimpleLocalizableMessage("MBean_Home_Get_Active_Domain_Method_Not_Found_Message"));
        }
        Object domainObject = null;
        try {
            domainObject = getActiveDomainMethod.invoke(home, new Object[0]);
        }
        catch (Exception e) {
            throw new CallbackFailedPermanentlyException((Throwable)e);
        }
        if (domainObject == null) {
            return null;
        }
        Class<?> domainClass = domainObject.getClass();
        if (domainClass == null) {
            return null;
        }
        try {
            getNameMethod = domainClass.getMethod("getName", new Class[0]);
        }
        catch (Exception e) {
            throw new CallbackFailedPermanentlyException((Throwable)e);
        }
        if (getNameMethod == null || Modifier.isStatic(getNameMethod.getModifiers())) {
            return null;
        }
        Object nameObj = null;
        try {
            nameObj = getNameMethod.invoke(domainObject, new Object[0]);
        }
        catch (Exception e) {
            throw new CallbackFailedPermanentlyException((Throwable)e);
        }
        if (nameObj == null || !(nameObj instanceof String)) {
            return null;
        }
        return (String)nameObj;
    }
}

