/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.wldf;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.jmx.IMBeanServerLocator;
import com.wily.introscope.agent.webappsupport.weblogic.WebLogicMBeanHelper;
import com.wily.introscope.agent.wldf.ANameConverter;
import com.wily.introscope.agent.wldf.AllSortedKeysNameConverter;
import com.wily.introscope.agent.wldf.DataViewFactory;
import com.wily.introscope.agent.wldf.IMBeanNameConverter;
import com.wily.introscope.agent.wldf.IWLDFDataView;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.heartbeat.IntervalHeartbeat;
import com.wily.util.text.IStringLocalizer;
import com.wily.wilyassert.Assertion;
import java.lang.reflect.Method;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public final class IntroscopeProtocolWLDFAdaptor {
    public static final String kProtocolAdaptorDomain = "com.wily.introscope.agent";
    public static final String kProtocolAdaptorNameKey = "name";
    public static final String kProtocolAdaptorNameValue = "IntroscopeProtocolWLDFAdaptor";
    private static final String kWLDFBehaviorName = "Introscope WLDF Protocol Adaptor";
    private static final String kMBeanServerDelegateName = "JMImplementation:type=MBeanServerDelegate";
    private final IAgent fAgent;
    private ObjectName fDelegateObjectName;
    private IMBeanNameConverter fNameConverter;
    private final IMBeanServerLocator fServerLocator;
    private HashMap fViewsHashMap;
    private MBeanServer fWLDFMBeanServer;
    private final IntroscopeProtocolWLDFAdaptorHeartbeatBehavior fBehavior;
    private final ClassLoader fContextClassLoader;
    private final Object fSubject;
    private final FindServersAndPollViewsAction fFindServersAndPollViewsAction;

    public IntroscopeProtocolWLDFAdaptor(IAgent agent, Object shouldBeSubject) {
        this.fAgent = agent;
        this.fSubject = shouldBeSubject;
        this.fServerLocator = new IMBeanServerLocator(){

            @Override
            public MBeanServer[] IMBeanServerLocator_locate() {
                return new MBeanServer[]{WebLogicMBeanHelper.getWebLogic9MBeanServer()};
            }
        };
        this.fWLDFMBeanServer = null;
        try {
            this.fDelegateObjectName = new ObjectName(kMBeanServerDelegateName);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            Assertion.wilyAssert(false);
        }
        this.fNameConverter = new AllSortedKeysNameConverter();
        Assertion.wilyAssert(false);
        this.fViewsHashMap = new HashMap();
        this.fBehavior = new IntroscopeProtocolWLDFAdaptorHeartbeatBehavior();
        this.fContextClassLoader = this.getClass().getClassLoader();
        this.fFindServersAndPollViewsAction = new FindServersAndPollViewsAction();
    }

    void registerHeartbeatBehavior(IntervalHeartbeat heartbeat) {
        Assertion.wilyAssert(false);
        heartbeat.addBehavior((ITimestampedRunnable)this.fBehavior, kWLDFBehaviorName, true, 7500L, false);
    }

    private void setContextAndPoll() {
        block6: {
            Thread currentThread = Thread.currentThread();
            ClassLoader savedContext = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(this.fContextClassLoader);
                try {
                    Class<?> subjectClass = null;
                    subjectClass = Class.forName("javax.security.auth.Subject");
                    if (subjectClass.isInstance(this.fSubject)) {
                        this.fAgent.IAgent_getModuleFeedback().debug("[WLDF Service] Found Subject = " + this.fSubject);
                        Class<?> securityClass = Class.forName("weblogic.security.Security");
                        Method runAs = securityClass.getMethod("runAs", subjectClass, PrivilegedAction.class);
                        runAs.invoke(null, this.fSubject, this.fFindServersAndPollViewsAction);
                        break block6;
                    }
                    this.fAgent.IAgent_getModuleFeedback().error("[WLDF Service] Got a Subject not an instance of javax.security.auth.Subject");
                }
                catch (Throwable t) {
                    this.fAgent.IAgent_getModuleFeedback().debug("Unable to determine credentials, caught Throwable: ", t);
                }
            }
            finally {
                currentThread.setContextClassLoader(savedContext);
            }
        }
    }

    private synchronized void findServersAndPollViews() {
        MBeanServer server = this.fServerLocator.IMBeanServerLocator_locate()[0];
        if (server == null) {
            return;
        }
        this.fWLDFMBeanServer = server;
        this.findAndAddMBeanAndDataAccessors();
        this.pollViews();
    }

    private void findAndAddMBeanAndDataAccessors() {
        String[] dataAccessorNames;
        this.fAgent.IAgent_getModuleFeedback().debug("before call to getWLDFAccessRuntime(" + this.fWLDFMBeanServer + ")");
        ObjectName wldfAccessRuntime = this.getWLDFAccessRuntime(this.fWLDFMBeanServer);
        this.fAgent.IAgent_getModuleFeedback().debug("after call to getWLDFAccessRuntime(" + this.fWLDFMBeanServer + ")");
        if (wldfAccessRuntime != null && (dataAccessorNames = (String[])this.getAttribute(this.fWLDFMBeanServer, wldfAccessRuntime, "AvailableDiagnosticDataAccessorNames")) != null) {
            this.fAgent.IAgent_getModuleFeedback().debug("Found " + dataAccessorNames.length + " data accessor names");
            int dan = 0;
            while (dan < dataAccessorNames.length) {
                String dataAccessorName = dataAccessorNames[dan];
                this.fAgent.IAgent_getModuleFeedback().debug("Accessing data accessor '" + dataAccessorName + "'");
                Object[] args = new Object[]{dataAccessorName};
                String[] argTypes = new String[]{"java.lang.String"};
                ObjectName wldfDataAccessRuntime = (ObjectName)this.invoke(this.fWLDFMBeanServer, wldfAccessRuntime, "lookupWLDFDataAccessRuntime", args, argTypes);
                this.addWLDFAccessor(wldfDataAccessRuntime, this.fWLDFMBeanServer);
                ++dan;
            }
        }
    }

    private void pollViews() {
        block2: for (CompositeMBeanIdentifier cmbi : this.fViewsHashMap.keySet()) {
            Object[] os;
            MBeanServer server = cmbi.getFServer();
            ObjectName on = cmbi.getFObjectName();
            long curTime = System.currentTimeMillis();
            Object[] objectArray = new Object[3];
            objectArray[0] = curTime - 15000L;
            objectArray[1] = curTime;
            Object[] args = objectArray;
            String[] argTypes = new String[]{"java.lang.Long", "java.lang.Long", "java.lang.String"};
            String cursor = (String)this.invoke(server, on, "openCursor", args, argTypes);
            Map columnIndexMap = (Map)this.getAttribute(server, on, "ColumnIndexMap");
            if (columnIndexMap == null) {
                return;
            }
            if (!((Boolean)this.invoke(server, on, "hasMoreData", new Object[]{cursor}, new String[]{"java.lang.String"})).booleanValue() || (os = (Object[])this.invoke(server, on, "fetch", new Object[]{cursor}, new String[]{"java.lang.String"})).length <= 0) continue;
            Object[] values = (Object[])os[os.length - 1];
            HashSet viewsHash = (HashSet)this.fViewsHashMap.get(cmbi);
            Iterator dataview_it = viewsHash.iterator();
            while (dataview_it.hasNext()) {
                IWLDFDataView view = (IWLDFDataView)dataview_it.next();
                try {
                    Object value;
                    int index = (Integer)columnIndexMap.get(view.getFSourceAttribute());
                    if (index >= values.length || view.IWLDFDataView_update(value = values[index])) continue;
                    view.IWLDFDataView_destroy();
                    dataview_it.remove();
                    this.fAgent.IAgent_getModuleFeedback().info("WLDF data unavailable for " + view.getFullMetricName() + ", agent will no longer poll for value");
                }
                catch (Throwable t) {
                    this.fAgent.IAgent_getModuleFeedback().debug("WLDF generated an error getting info for " + view.getFullMetricName() + ", agent will no longer poll for value");
                    this.fAgent.IAgent_getModuleFeedback().verbose(t);
                    view.IWLDFDataView_destroy();
                    dataview_it.remove();
                }
                continue block2;
            }
        }
    }

    private ObjectName createObjectName(String name) {
        try {
            return new ObjectName(name);
        }
        catch (MalformedObjectNameException mone) {
            this.fAgent.IAgent_getModuleFeedback().debug("MalformedObjectNameException: " + mone.toString());
            return null;
        }
    }

    private ObjectName getWLDFAccessRuntime(MBeanServer server) {
        this.fAgent.IAgent_getModuleFeedback().debug("Looking up ServerRuntime");
        ObjectName service = this.createObjectName("com.bea:Name=RuntimeService,Type=weblogic.management.mbeanservers.runtime.RuntimeServiceMBean");
        ObjectName serverRuntime = (ObjectName)this.getAttribute(server, service, "ServerRuntime");
        if (serverRuntime == null) {
            this.fAgent.IAgent_getModuleFeedback().debug("ServerRuntime attribute is null");
            return null;
        }
        this.fAgent.IAgent_getModuleFeedback().debug("Looking up WLDFRuntime");
        ObjectName wldfRuntime = (ObjectName)this.getAttribute(server, serverRuntime, "WLDFRuntime");
        if (wldfRuntime == null) {
            this.fAgent.IAgent_getModuleFeedback().debug("WLDFRuntime attribute is null");
            return null;
        }
        this.fAgent.IAgent_getModuleFeedback().debug("Looking up WLDFAccessRuntime");
        ObjectName wldfAccessRuntime = (ObjectName)this.getAttribute(server, wldfRuntime, "WLDFAccessRuntime");
        if (wldfRuntime == null) {
            this.fAgent.IAgent_getModuleFeedback().debug("WLDFAccessRuntime attribute is null");
            return null;
        }
        return wldfAccessRuntime;
    }

    private Object getAttribute(MBeanServer server, ObjectName objectName, String attributeName) {
        try {
            return server.getAttribute(objectName, attributeName);
        }
        catch (AttributeNotFoundException anfe) {
            this.fAgent.IAgent_getModuleFeedback().debug("AttributeNotFoundException: " + anfe.toString());
        }
        catch (InstanceNotFoundException infe) {
            this.fAgent.IAgent_getModuleFeedback().debug("InstanceNotFoundException: " + infe.toString());
        }
        catch (MBeanException mbe) {
            this.fAgent.IAgent_getModuleFeedback().debug("MBeanException: " + mbe.toString());
        }
        catch (ReflectionException re) {
            this.fAgent.IAgent_getModuleFeedback().debug("ReflectionException: " + re.toString());
        }
        return null;
    }

    private Object invoke(MBeanServer server, ObjectName objectName, String operationName, Object[] parameters, String[] signature) {
        try {
            return server.invoke(objectName, operationName, parameters, signature);
        }
        catch (InstanceNotFoundException infe) {
            this.fAgent.IAgent_getModuleFeedback().debug("InstanceNotFoundException: " + infe.toString());
        }
        catch (MBeanException mbe) {
            this.fAgent.IAgent_getModuleFeedback().debug("MBeanException: " + mbe.toString());
        }
        catch (ReflectionException re) {
            this.fAgent.IAgent_getModuleFeedback().debug("ReflectionException: " + re.toString());
        }
        return null;
    }

    private synchronized void addWLDFAccessor(ObjectName on, MBeanServer server) {
        if (on.equals(this.fDelegateObjectName)) {
            return;
        }
        CompositeMBeanIdentifier cmbi = new CompositeMBeanIdentifier(on, server);
        if (this.haveAlreadySeenCompositeMBeanIdentifier(cmbi)) {
            return;
        }
        String resourceName = this.getIntroscopeResourceName(on);
        Map columnIndexMap = (Map)this.getAttribute(server, on, "ColumnIndexMap");
        if (columnIndexMap == null) {
            return;
        }
        Map columnTypeMap = (Map)this.getAttribute(server, on, "ColumnTypeMap");
        if (columnTypeMap == null) {
            return;
        }
        HashSet viewsSet = new HashSet();
        this.createAndAddViewsToSet(on, server, resourceName, columnIndexMap, columnTypeMap, viewsSet);
        this.addViews(cmbi, viewsSet);
    }

    private void createAndAddViewsToSet(ObjectName on, MBeanServer server, String resourceName, Map ciMap, Map ctMap, HashSet viewsSet) {
        Iterator it = ciMap.keySet().iterator();
        boolean debugEnabled = this.fAgent.IAgent_getModuleFeedback().isDebugEnabled();
        while (it.hasNext()) {
            String attName = (String)it.next();
            String attType = (String)ctMap.get(attName);
            if (debugEnabled) {
                this.fAgent.IAgent_getModuleFeedback().debug("IPWLDFA: creating view for object name -->" + on + "<-- attName -->" + attName + "<-- attType -->" + attType + "<--");
            }
            StringBuffer tmpName = new StringBuffer(resourceName);
            tmpName.append(':');
            tmpName.append(attName);
            ANameConverter.replaceTrailingWhitespace(tmpName);
            String fullIntroscopeMetricName = tmpName.toString();
            try {
                IWLDFDataView view = DataViewFactory.createView(this.fAgent, on, attType, attName, server, fullIntroscopeMetricName);
                viewsSet.add(view);
            }
            catch (Exception e) {
                IStringLocalizer localizer = this.fAgent.IAgent_getStringLocalizer();
                String message = localizer.IStringLocalizer_getFormattedLocalizedString("Agent_WLDF_Could_Not_Create_View_Message", fullIntroscopeMetricName, String.valueOf(on.toString()) + " " + attName + " " + attType);
                this.fAgent.IAgent_safeReportError(message, (Throwable)e);
            }
        }
    }

    private String getIntroscopeResourceName(ObjectName on) {
        Assertion.wilyAssert(false);
        return this.fNameConverter.IMBeanNameConverter_convert(on);
    }

    private synchronized void addViews(CompositeMBeanIdentifier cmbi, HashSet viewsSet) {
        if (!this.haveAlreadySeenCompositeMBeanIdentifier(cmbi)) {
            Assertion.wilyAssert(false);
            this.fViewsHashMap.put(cmbi, viewsSet);
        }
    }

    private synchronized boolean haveAlreadySeenCompositeMBeanIdentifier(CompositeMBeanIdentifier cmbi) {
        return this.fViewsHashMap.containsKey(cmbi);
    }

    IMBeanNameConverter debug_getSecondaryNameConverter() {
        return this.fNameConverter;
    }

    int debug_getNumberOfMBeans() {
        return this.fViewsHashMap.size();
    }

    int debug_getNumberOfViewsForMBean(ObjectName on, MBeanServer server) {
        CompositeMBeanIdentifier cmbi = new CompositeMBeanIdentifier(on, server);
        HashSet views = (HashSet)this.fViewsHashMap.get(cmbi);
        return views.size();
    }

    void debug_findServersAndPollViews() {
        this.setContextAndPoll();
    }

    static final class CompositeMBeanIdentifier {
        private final MBeanServer fServer;
        private final ObjectName fObjectName;

        ObjectName getFObjectName() {
            return this.fObjectName;
        }

        MBeanServer getFServer() {
            return this.fServer;
        }

        public CompositeMBeanIdentifier(ObjectName on, MBeanServer server) {
            Assertion.wilyAssert(false);
            Assertion.wilyAssert(false);
            this.fServer = server;
            this.fObjectName = on;
        }

        public int hashCode() {
            return this.fServer.hashCode() ^ this.fObjectName.hashCode();
        }

        public String toString() {
            return String.valueOf(this.fServer.toString()) + " " + this.fObjectName.toString();
        }

        public boolean equals(Object o) {
            if (o == null || o.getClass() != CompositeMBeanIdentifier.class) {
                return false;
            }
            CompositeMBeanIdentifier cmbi = (CompositeMBeanIdentifier)o;
            return this.fServer.equals(cmbi.fServer) && this.fObjectName.equals(cmbi.fObjectName);
        }
    }

    private class FindServersAndPollViewsAction
    implements PrivilegedAction {
        private FindServersAndPollViewsAction() {
        }

        public Object run() {
            IntroscopeProtocolWLDFAdaptor.this.findServersAndPollViews();
            return null;
        }
    }

    private final class IntroscopeProtocolWLDFAdaptorHeartbeatBehavior
    implements ITimestampedRunnable {
        private IntroscopeProtocolWLDFAdaptorHeartbeatBehavior() {
        }

        @Override
        public void ITimestampedRunnable_execute(long nowInMillis) {
            IntroscopeProtocolWLDFAdaptor.this.setContextAndPoll();
        }
    }
}

