/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.wldf;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.webappsupport.AWebAppSupportReflectionDelegatingService;
import com.wily.util.properties.IndexedProperties;
import com.wily.wilyassert.Assertion;

public final class WLDFDelegatingService
extends AWebAppSupportReflectionDelegatingService {
    public WLDFDelegatingService() {
        super("WLDF", "com.wily.introscope.agent.wldf.WLDFService", WLDFDelegatingService.class.getClassLoader());
    }

    @Override
    protected boolean doShouldAttemptDelegateLoad(IAgent agent) {
        boolean result = false;
        String[] kJMXClassNames = new String[]{"javax.management.ObjectName", "javax.management.MBeanServer", "javax.management.MBeanServerFactory", "weblogic.management.runtime.WLDFDataAccessRuntimeMBean"};
        IndexedProperties props = agent.IAgent_getIndexedProperties();
        Assertion.wilyAssert(props != null);
        boolean wldfOn = props.getBooleanProperty("introscope.agent.wldf.enable");
        if (wldfOn) {
            try {
                agent.IAgent_getModuleFeedback().info(agent.IAgent_getStringLocalizer().IStringLocalizer_getLocalizedString("Agent_WLDF_Activating_WLDF_Message"));
                int i = 0;
                while (i < kJMXClassNames.length) {
                    Assertion.wilyAssert(false);
                    Class.forName(kJMXClassNames[i]);
                    ++i;
                }
                result = true;
            }
            catch (Throwable t) {
                this.reportFailure(agent, t);
            }
        }
        return result;
    }

    @Override
    protected void doHandleDelegateLoadException(IAgent agent, Throwable t) {
        this.reportFailure(agent, t);
    }

    private void reportFailure(IAgent agent, Throwable t) {
        agent.IAgent_safeReportError(agent.IAgent_getStringLocalizer().IStringLocalizer_getLocalizedString("Agent_WLDF_Failed_To_Activate_WLDF_Message"), t);
    }
}

