/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.api.websphere;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.api.websphere.IntroscopeCustomService;
import com.wily.util.extension.JarExtension;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.AttributeListing;
import com.wily.util.properties.PropertiesUtils;
import java.util.Properties;

public class WASStartupTracer
extends ASingleInstanceTracerFactory {
    protected final Module module;
    protected final IModuleFeedbackChannel logger;
    private volatile IAgent agent = null;
    private ReentrancyLevel reentrancyLevel = this.calculateReentrancyLevel(ReentrancyLevel.kNone);

    public WASStartupTracer(IAgent agent, AttributeListing attributeListing, ProbeIdentification probeIdentification, Object sample) {
        super(agent, attributeListing, probeIdentification, sample);
        this.agent = agent;
        this.module = new Module(((Object)((Object)this)).getClass().getName());
        this.logger = agent.IAgent_getModuleFeedback();
    }

    public void ITracer_finishTrace(int i, InvocationData invocationData) {
        JarExtension.AllPermissionsClassLoader cl = (JarExtension.AllPermissionsClassLoader)((Object)((Object)this)).getClass().getClassLoader();
        cl.setHelperClassLoader(invocationData.getInvocationObject().getClass().getClassLoader());
        String userName = (String)this.agent.IAgent_getIndexedProperties().get("introscope.agent.jmx.username");
        String password = (String)this.agent.IAgent_getIndexedProperties().get("introscope.agent.jmx.password");
        if (password != null && password.trim().length() != 0) {
            password = PropertiesUtils.decryptPassword(password);
        }
        Properties properties = new Properties();
        if (WASStartupTracer.isValidString(userName) && WASStartupTracer.isValidString(password)) {
            properties.put("jmxusername", userName);
            properties.put("jmxpassword", password);
        }
        try {
            new IntroscopeCustomService().initialize(properties);
        }
        catch (ThreadDeath td) {
            this.logger.error(this.module, "ThreadDeath occured while running WASStartupTracer ", td);
        }
        catch (Throwable t) {
            this.logger.error(this.module, "Exception occured while running WASStartupTracer ", t);
        }
    }

    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return this.reentrancyLevel;
    }

    public boolean ITracerFactory_isShutoff() {
        return false;
    }

    public void ITracer_startTrace(int arg0, InvocationData arg1) {
    }

    private static boolean isValidString(String input) {
        return input != null && input.trim().length() != 0;
    }
}

