/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.adt;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class NonSyncLRUCache {
    private final int fMaxSize;
    private final HashMap fLookup;
    private HashMap fSnapshot;
    private ValueWrapper fFirst;
    private ValueWrapper fLast;

    public NonSyncLRUCache() {
        this(-1);
    }

    public NonSyncLRUCache(int maxSize) {
        if (maxSize < -1) {
            throw new IllegalArgumentException("the cache size must be at least zero (or -1 if no max size)");
        }
        this.fMaxSize = maxSize;
        this.fLookup = new HashMap();
        this.fFirst = null;
        this.fLast = null;
    }

    public void clear() {
        Iterator it = this.fLookup.values().iterator();
        while (it.hasNext()) {
            this.objectRemoved(it.next());
        }
        this.fLookup.clear();
    }

    public int size() {
        return this.fLookup.size();
    }

    public Object get(Object key) {
        ValueWrapper wrapper = (ValueWrapper)this.fLookup.get(key);
        if (wrapper == null) {
            return null;
        }
        this.updateItem(wrapper);
        return wrapper.fValue;
    }

    protected HashMap getLookup() {
        return this.fLookup;
    }

    public Set keySnapshot() {
        this.fSnapshot = (HashMap)this.fLookup.clone();
        return this.fSnapshot.keySet();
    }

    public void put(Object key, Object value) {
        ValueWrapper wrapper;
        ValueWrapper removed;
        if (this.fMaxSize == 0) {
            return;
        }
        if (this.fMaxSize != -1 && this.size() == this.fMaxSize && (removed = this.removeItem()) != null) {
            this.remove(removed.fKey);
        }
        if ((wrapper = (ValueWrapper)this.fLookup.get(key)) != null) {
            this.removeItem(wrapper);
        }
        wrapper = new ValueWrapper(key, value);
        this.fLookup.put(key, wrapper);
        this.addItem(wrapper);
    }

    protected void objectRemoved(Object value) {
    }

    public Object remove(Object key) {
        ValueWrapper wrapper = (ValueWrapper)this.fLookup.remove(key);
        if (wrapper == null) {
            return null;
        }
        this.removeItem(wrapper);
        this.objectRemoved(wrapper.fValue);
        return wrapper.fValue;
    }

    private void addItem(ValueWrapper wrapper) {
        if (this.fFirst == null) {
            this.fFirst = wrapper;
            this.fLast = wrapper;
        } else {
            wrapper.fPrev = this.fLast;
            if (this.fLast != null) {
                this.fLast.fNext = wrapper;
            }
            this.fLast = wrapper;
        }
    }

    private void updateItem(ValueWrapper wrapper) {
        this.removeItem(wrapper);
        this.addItem(wrapper);
    }

    private ValueWrapper removeItem() {
        ValueWrapper item = this.fFirst;
        if (item != null) {
            this.removeItem(item);
        }
        return item;
    }

    private void removeItem(ValueWrapper wrapper) {
        if (wrapper.fPrev == null) {
            if (wrapper.fNext == null) {
                this.fFirst = null;
                this.fLast = null;
            } else {
                this.fFirst = wrapper.fNext;
                this.fFirst.fPrev = null;
            }
        } else if (wrapper.fNext == null) {
            this.fLast = wrapper.fPrev;
            this.fLast.fNext = null;
        } else {
            wrapper.fNext.fPrev = wrapper.fPrev;
            wrapper.fPrev.fNext = wrapper.fNext;
        }
        wrapper.fPrev = null;
        wrapper.fNext = null;
    }

    private class ValueWrapper {
        public Object fKey;
        public Object fValue;
        public ValueWrapper fPrev;
        public ValueWrapper fNext;

        public ValueWrapper(Object key, Object value) {
            this.fKey = key;
            this.fValue = value;
            this.fPrev = null;
            this.fNext = null;
        }
    }
}

