/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.interactivecommand;

import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.interactivecommand.IInteractiveCommand;
import com.wily.util.interactivecommand.InteractiveCommandException;
import com.wily.util.interactivecommand.InteractiveCommandParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;

public class InteractiveCommandEngine {
    private final CommandThread fCommandThread;
    private final BufferedReader fReader;
    private final InteractiveCommandParser fParser;
    private final IModuleFeedbackChannel fFeedback;

    public InteractiveCommandEngine(InputStream in, IModuleFeedbackChannel feedback, String tokens) {
        this.fParser = new InteractiveCommandParser(tokens);
        this.fReader = new BufferedReader(new InputStreamReader(in));
        this.fFeedback = feedback;
        this.fCommandThread = new CommandThread();
    }

    private IModuleFeedbackChannel getModuleFeedback() {
        return this.fFeedback;
    }

    public void registerCommand(IInteractiveCommand command) {
        this.fParser.registerCommand(command);
    }

    public void printHelp(PrintWriter outputChannel) {
        this.fParser.printHelp(outputChannel);
    }

    public void start() {
        this.fCommandThread.start();
    }

    private void waitForOneCommandAndHandle(long commandNum) {
        try {
            String commandString = this.fReader.readLine();
            if (commandString != null) {
                this.fFeedback.info(this.fParser.executeCommandString(commandString));
            }
        }
        catch (IOException ioe) {
            this.getModuleFeedback().error(ioe.getMessage());
        }
        catch (InteractiveCommandException ce) {
            this.getModuleFeedback().error(ce.getMessage());
            this.printHelp(new PrintWriter(System.out, true));
        }
    }

    private class CommandThread
    extends Thread {
        public CommandThread() {
            super("interactive command parser");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            long commandNum = 0L;
            while (true) {
                InteractiveCommandEngine.this.waitForOneCommandAndHandle(++commandNum);
            }
        }
    }
}

