/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util;

import com.wily.util.ICloseable;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public class CloseableTracker {
    private final Collection fCloseables = new HashSet();
    private boolean fTorndown;

    public CloseableTracker(IModuleFeedbackChannel feedbackChannel) {
    }

    public synchronized void addCloseable(ICloseable closeable) {
        if (this.fTorndown) {
            closeable.close();
        } else {
            this.fCloseables.add(closeable);
        }
    }

    public synchronized void closeAll() {
        Iterator iter = this.fCloseables.iterator();
        while (iter.hasNext()) {
            ICloseable closeable = (ICloseable)iter.next();
            closeable.close();
        }
        this.fCloseables.clear();
    }

    public synchronized void teardown() {
        this.closeAll();
        this.fTorndown = true;
    }

    public synchronized boolean isTorndown() {
        return this.fTorndown;
    }

    public Object getSynchronizationLock() {
        return this;
    }
}

