/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.version;

import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class VersionPrinter {
    public static final String kReleaseStringKey = "Release_String_Key";
    public static final String kBuildNumberStringKey = "Build_Number_String_Key";
    private static final String kProductNameAndReleaseAndBuildString = "Version_Printer_Product_Name_And_Release_And_Build_String";
    private static final String kReleaseAndBuildString = "Version_Printer_Release_And_Build_String";
    private static final String kJavaVersionAndVendorString = "Version_Printer_Java_Version_And_Vendor_String";
    private static final String kFullProductName = "Version_Printer_Full_Product_Name";
    private static final String kLongCopyright = "Version_Printer_Long_Copyright";
    private static final String kProductIsARegisteredTrademark = "Version_Printer_Product_Is_A_Registered_Trademark";
    private final DateFormat fTimeFormat = DateFormat.getDateTimeInstance(3, 1);
    private final ResourceBundle[] fResources;
    private final String fLocalizedFullName;

    public static void print(ClassLoader loader, String extraResourceKey, String fullNameKey) {
        VersionPrinter printer = new VersionPrinter(loader, extraResourceKey, fullNameKey);
        printer.printBanner();
    }

    private VersionPrinter(ClassLoader loader, String extraResourceKey, String fullNameKey) {
        this.fResources = this.makeResourceBundles(loader, this.getResources(extraResourceKey));
        this.fLocalizedFullName = this.localize(fullNameKey);
    }

    private void printBanner() {
        String releaseString = this.localize(kReleaseStringKey);
        String buildNumberString = this.localize(kBuildNumberStringKey);
        String buildAndReleaseString = this.localize(kReleaseAndBuildString, releaseString, buildNumberString);
        String productVersion = this.localize(kProductNameAndReleaseAndBuildString, this.fLocalizedFullName, buildAndReleaseString);
        String vmVendor = System.getProperty("java.vendor");
        String vmVersion = "\"" + System.getProperty("java.vm.name") + " " + System.getProperty("java.version") + "\"";
        String vmVendorAndVersion = this.localize(kJavaVersionAndVendorString, vmVersion, vmVendor);
        this.logInfo(productVersion);
        this.logInfo(vmVendorAndVersion);
        this.logInfo(this.localize(kFullProductName));
        this.logInfo(this.localize(kLongCopyright));
        this.logInfo(this.localize(kProductIsARegisteredTrademark));
    }

    private String[] getResources(String extraResource) {
        return new String[]{"com.wily.properties.VersionPrinterStrings", extraResource};
    }

    private ResourceBundle[] makeResourceBundles(ClassLoader classLoaderToUse, String[] fullyQualifiedNames) {
        ResourceBundle[] result = new ResourceBundle[fullyQualifiedNames.length];
        for (int i = 0; i < fullyQualifiedNames.length; ++i) {
            try {
                result[i] = ResourceBundle.getBundle(fullyQualifiedNames[i], Locale.getDefault(), classLoaderToUse);
                continue;
            }
            catch (MissingResourceException mre) {
                this.logError("Can't find localization resource: \"" + fullyQualifiedNames[i] + "\".");
            }
        }
        return result;
    }

    public String localize(String key) {
        for (int i = 0; i < this.fResources.length; ++i) {
            if (this.fResources[i] == null) continue;
            try {
                return this.fResources[i].getString(key);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        this.logError("Can't find localized string: \"" + key + "\".");
        return key;
    }

    public String localize(String key, String parameter1, String parameter2) {
        String message = this.localize(key);
        if (message != null) {
            return MessageFormat.format(message, parameter1, parameter2);
        }
        return key;
    }

    private void logInfo(String message) {
        this.log("INFO", message);
    }

    private void logError(String message) {
        this.log("ERROR", message);
    }

    private void log(String severity, String message) {
        System.out.print(this.fTimeFormat.format(new Date()));
        System.out.print(" [");
        System.out.print(severity);
        System.out.print("] ");
        System.out.println(message);
    }
}

