/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.postofficehub.link.http.client;

import com.wily.isengard.postofficehub.link.http.client.HTTPNotRunningException;
import com.wily.isengard.postofficehub.link.http.client.IHttpTunnelingClient;
import com.wily.isengard.postofficehub.link.http.client.ProxyConfiguration;
import com.wily.isengard.postofficehub.link.http.client.TrustingSSLProtocolSocketFactory;
import com.wily.org.apache.commons.codec.binary.Base64;
import com.wily.org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import com.wily.org.apache.commons.httpclient.HttpClient;
import com.wily.org.apache.commons.httpclient.HttpConnectionManager;
import com.wily.org.apache.commons.httpclient.HttpMethod;
import com.wily.org.apache.commons.httpclient.HttpVersion;
import com.wily.org.apache.commons.httpclient.NTCredentials;
import com.wily.org.apache.commons.httpclient.SimpleHttpConnectionManager;
import com.wily.org.apache.commons.httpclient.UsernamePasswordCredentials;
import com.wily.org.apache.commons.httpclient.auth.AuthChallengeProcessor;
import com.wily.org.apache.commons.httpclient.auth.AuthScope;
import com.wily.org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import com.wily.org.apache.commons.httpclient.methods.PostMethod;
import com.wily.org.apache.commons.httpclient.methods.StringRequestEntity;
import com.wily.org.apache.commons.httpclient.params.DefaultHttpParams;
import com.wily.org.apache.commons.httpclient.params.HttpParams;
import com.wily.org.apache.commons.httpclient.protocol.Protocol;
import com.wily.org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.io.NonSyncByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;

public class CommonsHttpTunnelingClient
implements IHttpTunnelingClient {
    private static Module sModule = new Module("CommonsHttpTunnelingClient");
    private static final byte[] kEmptyArray = new byte[0];
    private static final String kTunnelingServiceContext = "/em/transport/services/IsengardHttpTunnelingService";
    private static final String kContentType = "text/xml";
    private static final String kCharset = "UTF-8";
    private static final String kConnectSOAPRequest = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><soapenv:Body><ns1:connect soapenv:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:ns1=\"urn:isengard.wily.com\"/></soapenv:Body></soapenv:Envelope>";
    private static final String kDisconnectSOAPRequest = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><soapenv:Body><ns1:disconnect soapenv:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:ns1=\"urn:isengard.wily.com\"/></soapenv:Body></soapenv:Envelope>";
    private static final String kTransferSOAPRequestStart = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><soapenv:Body><ns1:transfer soapenv:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:ns1=\"urn:isengard.wily.com\"><in0 xsi:type=\"soapenc:base64Binary\" xmlns:soapenc=\"http://schemas.xmlsoap.org/soap/encoding/\">";
    private static final String kTransferSOAPRequestEnd = "</in0></ns1:transfer></soapenv:Body></soapenv:Envelope>";
    private static final String kEmptyTransferSOAPRequest = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><soapenv:Body><ns1:transfer soapenv:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:ns1=\"urn:isengard.wily.com\"><in0 xsi:type=\"soapenc:base64Binary\" xmlns:soapenc=\"http://schemas.xmlsoap.org/soap/encoding/\"></in0></ns1:transfer></soapenv:Body></soapenv:Envelope>";
    private static final String kTransferSOAPResponseStart = "<?xml version=\"1.0\" encoding=\"utf-8\"?><soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><soapenv:Body><ns1:transferResponse soapenv:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:ns1=\"urn:isengard.wily.com\"><transferReturn xsi:type=\"soapenc:base64Binary\" xmlns:soapenc=\"http://schemas.xmlsoap.org/soap/encoding/\">";
    private static final String kTransferSOAPResponseEnd = "</transferReturn></ns1:transferResponse></soapenv:Body></soapenv:Envelope>";
    private static final String kErrorSOAPResponseStart = "<?xml version=\"1.0\" encoding=\"utf-8\"?><soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><soapenv:Body><soapenv:Fault>";
    private static final String kErrorSOAPResponseEnd = "</soapenv:Fault></soapenv:Body></soapenv:Envelope>";
    private static byte[] sTransferSOAPRequestStartBytes;
    private static byte[] sTransferSOAPRequestEndBytes;
    private static byte[] sEmptyTransferSOAPRequestBytes;
    private static int sTransferSOAPResponseStartNumBytes;
    private static int sTransferSOAPResponseEndNumBytes;
    private HttpClient fHttpClient;
    private HttpConnectionManager fConnManager;
    private ProxyConfiguration fProxyConfig;
    private String fTunnelingServiceAddress;
    private PostMethod fMethod;
    private NonSyncByteArrayOutputStream fOutStream;
    private final String fHostName;
    private final int fPort;
    private SSLContext fSSLContext;
    private String[] fCipherSuites;
    private String[] fProtocols;
    private IModuleFeedbackChannel fFeedback;

    static {
        try {
            sTransferSOAPRequestStartBytes = kTransferSOAPRequestStart.getBytes(kCharset);
            sTransferSOAPRequestEndBytes = kTransferSOAPRequestEnd.getBytes(kCharset);
            sEmptyTransferSOAPRequestBytes = kEmptyTransferSOAPRequest.getBytes(kCharset);
            sTransferSOAPResponseStartNumBytes = kTransferSOAPResponseStart.getBytes(kCharset).length;
            sTransferSOAPResponseEndNumBytes = kTransferSOAPResponseEnd.getBytes(kCharset).length;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException("Charset UTF-8 is not supported.");
        }
    }

    public CommonsHttpTunnelingClient(String hostName, int port, int socketSendBufferSize, int socketRecieveBufferSize, SSLContext context, String[] cipherSuites, String[] protocols, IModuleFeedbackChannel feedback) {
        System.setProperty("com.wily.org.apache.commons.logging.Log", "com.wily.org.apache.commons.logging.impl.NoOpLog");
        this.fHostName = hostName;
        this.fPort = port;
        this.fSSLContext = context;
        this.fCipherSuites = cipherSuites;
        this.fProtocols = protocols;
        this.fFeedback = feedback;
        this.setSocketSendBufferSize(socketSendBufferSize);
        this.setSocketReceiveBufferSize(socketRecieveBufferSize);
        this.setUseKeepAliveConnections();
        this.setNoConnectRetries();
        this.setConnectionTimeout(1000);
        this.setSocketTimeout(1000);
    }

    @Override
    public void connect() throws HTTPNotRunningException {
        InetAddress[] addresses = new InetAddress[]{};
        try {
            addresses = InetAddress.getAllByName(this.fHostName);
        }
        catch (UnknownHostException unknownHostException) {}
        if (addresses.length >= 1) {
            HTTPNotRunningException thrownException = null;
            int i = 0;
            while (i < addresses.length) {
                InetAddress address = addresses[i];
                String ipAddress = address.getHostAddress();
                try {
                    this.connect2(ipAddress);
                    return;
                }
                catch (HTTPNotRunningException e) {
                    thrownException = e;
                    ++i;
                }
            }
            throw thrownException;
        }
        this.connect2(this.fHostName);
    }

    private void connect2(String host) throws HTTPNotRunningException {
        host = this.determineAndFormatIPv6HostAddress(host);
        if (this.fSSLContext == null) {
            this.fTunnelingServiceAddress = "http://" + host + ":" + this.fPort + kTunnelingServiceContext;
        } else {
            TrustingSSLProtocolSocketFactory socketFactory = new TrustingSSLProtocolSocketFactory(this.fSSLContext, this.fCipherSuites, this.fProtocols);
            Protocol.registerProtocol("https", new Protocol("https", (ProtocolSocketFactory)socketFactory, this.fPort));
            this.fTunnelingServiceAddress = "https://" + host + ":" + this.fPort + kTunnelingServiceContext;
        }
        boolean connected = false;
        this.fMethod = new PostMethod(this.fTunnelingServiceAddress);
        this.fMethod.setContentChunked(true);
        this.fMethod.setRequestHeader("SOAPAction", "\"\"");
        this.fMethod.getParams().setVirtualHost(this.fHostName);
        this.fOutStream = new NonSyncByteArrayOutputStream();
        this.fConnManager = new SimpleHttpConnectionManager();
        ArrayList<String> authPrefs = new ArrayList<String>(3);
        authPrefs.add("Basic");
        authPrefs.add("NTLM");
        authPrefs.add("Digest");
        try {
            try {
                HttpClient httpClient = new HttpClient(this.fConnManager);
                httpClient.getParams().setParameter("http.auth.scheme-priority", authPrefs);
                this.enableProxyServerSupport(httpClient);
                StringRequestEntity requestEntity = new StringRequestEntity(kConnectSOAPRequest, kContentType, kCharset);
                this.fMethod.setRequestEntity(requestEntity);
                int status = httpClient.executeMethod(this.fMethod);
                this.fHttpClient = httpClient;
                if (status != 200) {
                    String faultMsg = this.getFaultMessageAsString(this.fMethod, kCharset);
                    throw new RemoteException("Error when connecting to tunneling server: " + faultMsg);
                }
                connected = true;
            }
            catch (Exception e) {
                throw new HTTPNotRunningException("The HTTP Tunneling server cannot be reached at: " + this.fTunnelingServiceAddress + ": " + e);
            }
        }
        finally {
            this.fMethod.releaseConnection();
            if (!connected) {
                this.closeHttpConnection();
                this.fHttpClient = null;
            }
        }
    }

    private String determineAndFormatIPv6HostAddress(String host) {
        try {
            InetAddress address = InetAddress.getByName(host);
            ClassLoader classLoader = address.getClass().getClassLoader();
            Class<?> inet6AddressCls = Class.forName("java.net.Inet6Address", true, classLoader);
            if (inet6AddressCls.isInstance(address) && (host = address.getHostName()).equals(address.getHostAddress())) {
                host = new StringBuffer("[").append(URLEncoder.encode(host, kCharset)).append("]").toString();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (UnknownHostException unknownHostException) {
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        return host;
    }

    @Override
    public void connect(ProxyConfiguration config) throws HTTPNotRunningException {
        this.fProxyConfig = config;
        this.connect();
    }

    @Override
    public void disconnect() throws IOException {
        if (this.fHttpClient != null) {
            try {
                StringRequestEntity requestEntity = new StringRequestEntity(kDisconnectSOAPRequest, kContentType, kCharset);
                this.fMethod.setRequestEntity(requestEntity);
                int status = this.fHttpClient.executeMethod(this.fMethod);
                if (status != 200) {
                    String faultMsg = this.getFaultMessageAsString(this.fMethod, kCharset);
                    throw new RemoteException("Error when disconnecting from tunneling server: " + faultMsg);
                }
            }
            finally {
                this.fMethod.releaseConnection();
                this.closeHttpConnection();
            }
        }
    }

    @Override
    public byte[] transfer(byte[] serverData) throws IOException {
        byte[] result = kEmptyArray;
        if (this.fHttpClient != null) {
            try {
                byte[] requestBytes = this.getTransferRequest(serverData);
                ByteArrayRequestEntity requestEntity = new ByteArrayRequestEntity(requestBytes, kContentType);
                this.fMethod.setRequestEntity(requestEntity);
                int status = this.fHttpClient.executeMethod(this.fMethod);
                if (status != 200) {
                    String faultMsg = this.getFaultMessageAsString(this.fMethod, kCharset);
                    throw new RemoteException("Error when transfering data to/from tunneling server: " + faultMsg);
                }
                byte[] responseBytes = this.getResponse(this.fMethod);
                int transferedDataLength = responseBytes.length - sTransferSOAPResponseStartNumBytes - sTransferSOAPResponseEndNumBytes;
                if (transferedDataLength == 0) {
                    result = kEmptyArray;
                } else {
                    byte[] transferedData = new byte[transferedDataLength];
                    System.arraycopy(responseBytes, sTransferSOAPResponseStartNumBytes, transferedData, 0, transferedDataLength);
                    result = Base64.decodeBase64(transferedData);
                }
            }
            finally {
                this.fMethod.releaseConnection();
            }
        }
        return result;
    }

    private void enableProxyServerSupport(HttpClient httpClient) {
        if (this.fProxyConfig != null) {
            Logger.getLogger(AuthChallengeProcessor.class.getName()).setLevel(Level.WARNING);
            httpClient.getHostConfiguration().setProxy(this.fProxyConfig.getHostName(), this.fProxyConfig.getPort());
            if (this.fProxyConfig.requiresAuthentication()) {
                UsernamePasswordCredentials creds;
                AuthScope scope = new AuthScope(this.fProxyConfig.getHostName(), -1, this.fProxyConfig.getRealm());
                String username = this.fProxyConfig.getUserName();
                if (username.indexOf("\\") == -1) {
                    creds = new UsernamePasswordCredentials(username, this.fProxyConfig.getPassword());
                } else {
                    String[] domainUsername = username.split("\\\\");
                    String hostname = "";
                    try {
                        InetAddress addr = InetAddress.getLocalHost();
                        hostname = addr.getHostName();
                        if (hostname != null) {
                            if (hostname.indexOf(".") != -1) {
                                int hostIndex = hostname.lastIndexOf(".");
                                hostname = hostname.substring(hostIndex);
                            }
                        } else {
                            hostname = addr.getHostAddress();
                        }
                    }
                    catch (UnknownHostException unknownHostException) {
                        hostname = "";
                    }
                    creds = new NTCredentials(domainUsername[1], this.fProxyConfig.getPassword(), hostname, domainUsername[0]);
                    this.fFeedback.verbose(sModule, "NTLM Proxy Credentials: Domain: " + domainUsername[0] + ", Host:" + hostname + ", User Name: " + domainUsername[1]);
                }
                httpClient.getState().setProxyCredentials(scope, creds);
            }
        }
    }

    private byte[] getTransferRequest(byte[] serverData) {
        byte[] requestBytes = null;
        if (serverData.length > 0) {
            byte[] encodedData = Base64.encodeBase64(serverData);
            requestBytes = new byte[sTransferSOAPRequestStartBytes.length + encodedData.length + sTransferSOAPRequestEndBytes.length];
            System.arraycopy(sTransferSOAPRequestStartBytes, 0, requestBytes, 0, sTransferSOAPRequestStartBytes.length);
            System.arraycopy(encodedData, 0, requestBytes, sTransferSOAPRequestStartBytes.length, encodedData.length);
            System.arraycopy(sTransferSOAPRequestEndBytes, 0, requestBytes, sTransferSOAPRequestStartBytes.length + encodedData.length, sTransferSOAPRequestEndBytes.length);
        } else {
            requestBytes = sEmptyTransferSOAPRequestBytes;
        }
        return requestBytes;
    }

    private String getFaultMessageAsString(HttpMethod method, String charset) throws UnsupportedEncodingException, IOException {
        String response = this.getResponseAsString(method, charset);
        return response.substring(kErrorSOAPResponseStart.length(), response.length() - kErrorSOAPResponseEnd.length());
    }

    private String getResponseAsString(HttpMethod method, String charset) throws IOException, UnsupportedEncodingException {
        return new String(this.getResponse(method), charset);
    }

    private byte[] getResponse(HttpMethod method) throws IOException {
        InputStream inStream = method.getResponseBodyAsStream();
        NonSyncByteArrayOutputStream outStream = this.fOutStream;
        byte[] responseBytes = null;
        try {
            byte[] buffer = new byte[4096];
            int len = 0;
            while ((len = inStream.read(buffer)) > 0) {
                outStream.write(buffer, 0, len);
            }
            responseBytes = outStream.toByteArray();
        }
        finally {
            outStream.reset();
        }
        return responseBytes;
    }

    private void setUseKeepAliveConnections() {
        HttpParams params = DefaultHttpParams.getDefaultParams();
        params.setParameter("http.protocol.version", HttpVersion.HTTP_1_1);
    }

    private void setNoConnectRetries() {
        HttpParams params = DefaultHttpParams.getDefaultParams();
        params.setParameter("http.method.retry-handler", new DefaultHttpMethodRetryHandler(0, false));
    }

    private void setSocketSendBufferSize(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("illegal socket send buffer size: " + size);
        }
        HttpParams params = DefaultHttpParams.getDefaultParams();
        params.setIntParameter("http.socket.sendbuffer", size);
    }

    private void setConnectionTimeout(int timeout) {
        if (timeout <= 0) {
            throw new IllegalArgumentException("illegal connection timeout: " + timeout);
        }
        HttpParams params = DefaultHttpParams.getDefaultParams();
        params.setIntParameter("http.connection.timeout", timeout);
    }

    private void setSocketTimeout(int timeout) {
        if (timeout <= 0) {
            throw new IllegalArgumentException("illegal socket timeout: " + timeout);
        }
        HttpParams params = DefaultHttpParams.getDefaultParams();
        params.setIntParameter("http.socket.timeout", timeout);
    }

    private void setSocketReceiveBufferSize(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("illegal socket receive buffer size: " + size);
        }
        HttpParams params = DefaultHttpParams.getDefaultParams();
        params.setIntParameter("http.socket.receivebuffer", size);
    }

    private void logSocketBufferSizes() {
        System.out.println("HttpClient Tunneling Client Connecting:  SO_SNDBUF=" + DefaultHttpParams.getDefaultParams().getParameter("http.socket.sendbuffer") + ", SO_RCVBUF=" + DefaultHttpParams.getDefaultParams().getParameter("http.socket.receivebuffer"));
    }

    private void closeHttpConnection() {
        this.fConnManager.closeIdleConnections(0L);
    }
}

