/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.gcmonitor.agent;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.service.IAgentService;
import com.wily.introscope.gcmonitor.agent.GCMonitor;
import com.wily.introscope.gcmonitor.agent.jvmprovider.JVMProvider;
import com.wily.introscope.gcmonitor.agent.jvmprovider.JVMProviderFactory;
import com.wily.introscope.gcmonitor.metricpublisher.MetricPublisherFactory;
import com.wily.introscope.gcmonitor.ui.Messages;
import com.wily.util.feedback.Module;
import com.wily.util.heartbeat.IRegisteredBehavior;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.properties.hot.BooleanConfigurationProperty;
import com.wily.util.properties.hot.ConfigurationManager;
import com.wily.util.properties.hot.ConfigurationProperty;
import com.wily.util.properties.hot.IntegerConfigurationProperty;
import java.util.Map;

public class GCMonitorAgentService
implements IAgentService {
    public static final String kGCMonitorEnabledKey = "introscope.agent.gcmonitor.enable";
    public static final String kGCMonitorFrequencyKey = "introscope.agent.gcmonitor.frequency";
    private static final String kGCMONITOR_NAME = Messages.getString("GCMonitorTypeViewer.RootNode");
    private static final Module kGCMonitorServiceModule = new Module("GCMonitorAgentService");
    private static IAgent fAgent;
    private static volatile GCMonitorEnabledConfigurationProperty fGCMonitorEnabledConfigurationProperty;
    private static volatile GCMonitorFrequencyConfigurationProperty fGCMonitorFrequencyConfigurationProperty;
    private static volatile int fGCMonitorJMXQueryFrequency;
    private GCMonitor fGCMonitor;
    private IRegisteredBehavior fBehavior;

    static {
        fGCMonitorJMXQueryFrequency = 15000;
    }

    public int IAgentService_getServiceVersion() {
        return 2;
    }

    public void IAgentService_startService(IAgent agent, Map map) throws Exception {
        fAgent = agent;
        MetricPublisherFactory.getInstance().useAgentMetricPublisher(fAgent);
        fAgent.IAgent_getModuleFeedback().verbose(kGCMonitorServiceModule, Messages.getString("GCMonitorExtn.AgentPublisher"));
        fGCMonitorEnabledConfigurationProperty = new GCMonitorEnabledConfigurationProperty(agent);
        ConfigurationManager cm = fAgent.IAgent_getConfigurationManager();
        cm.add((ConfigurationProperty)fGCMonitorEnabledConfigurationProperty, true);
        fAgent.IAgent_getModuleFeedback().verbose(kGCMonitorServiceModule, String.valueOf(Messages.getString("GCMonitorExtn.ConfigProperty")) + GCMonitorAgentService.isGCMonitorEnabled());
        fGCMonitorFrequencyConfigurationProperty = new GCMonitorFrequencyConfigurationProperty(agent);
        cm.add((ConfigurationProperty)fGCMonitorFrequencyConfigurationProperty, true);
        fGCMonitorJMXQueryFrequency = GCMonitorAgentService.fGCMonitorFrequencyConfigurationProperty.value;
    }

    public static void main(String[] args) throws Throwable {
        long start = System.currentTimeMillis();
        MetricPublisherFactory.getInstance().useSystemOutMetricPublisher();
        JVMProvider provider = JVMProviderFactory.getInstance().getJVMProvider(fAgent);
        provider.getGCInformation();
        provider.publishMetricValues(false);
        long stop = System.currentTimeMillis();
        long timeInMs = stop - start;
        System.out.println("It took " + timeInMs + " ms");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        Class<GCMonitorAgentService> clazz = GCMonitorAgentService.class;
        synchronized (GCMonitorAgentService.class) {
            if (this.fGCMonitor == null) {
                this.fGCMonitor = new GCMonitor(fAgent, fGCMonitorJMXQueryFrequency);
                int frequency = 7500;
                if (this.fGCMonitor.getProvider() != null) {
                    this.fBehavior = fAgent.IAgent_getCommonHeartbeat().addBehavior((ITimestampedRunnable)this.fGCMonitor, kGCMONITOR_NAME, true, (long)frequency, false);
                    fAgent.IAgent_getModuleFeedback().info(kGCMonitorServiceModule, Messages.getString("GCMonitorExtn.StartMessage"));
                } else {
                    fAgent.IAgent_getModuleFeedback().verbose(kGCMonitorServiceModule, Messages.getString("GCMonitorExtn.ProviderNotInitialised"));
                }
            } else {
                fAgent.IAgent_getModuleFeedback().verbose(kGCMonitorServiceModule, Messages.getString("GCMonitorExtn.ProviderNotInitialised"));
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static boolean isGCMonitorEnabled() {
        return fGCMonitorEnabledConfigurationProperty.isEnabled();
    }

    private final class GCMonitorEnabledConfigurationProperty
    extends BooleanConfigurationProperty {
        volatile boolean value;

        private GCMonitorEnabledConfigurationProperty(IAgent agent) {
            super(GCMonitorAgentService.kGCMonitorEnabledKey, Boolean.TRUE, agent.IAgent_getModuleFeedback(), kGCMonitorServiceModule, agent.IAgent_getStringLocalizer());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void set(Object newValue) {
            this.value = (Boolean)newValue;
            if (this.value) {
                GCMonitorAgentService.this.initialize();
                return;
            }
            Class<GCMonitorAgentService> clazz = GCMonitorAgentService.class;
            synchronized (GCMonitorAgentService.class) {
                if (GCMonitorAgentService.this.fGCMonitor == null) return;
                if (GCMonitorAgentService.this.fBehavior != null) {
                    GCMonitorAgentService.this.fGCMonitor.turnOffAllMetrics();
                    fAgent.IAgent_getCommonHeartbeat().removeBehavior(GCMonitorAgentService.this.fBehavior);
                    fAgent.IAgent_getModuleFeedback().info(kGCMonitorServiceModule, Messages.getString("GCMonitorExtn.StopMessage"));
                }
                GCMonitorAgentService.this.fGCMonitor = null;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        public final boolean isEnabled() {
            return this.value;
        }
    }

    private static final class GCMonitorFrequencyConfigurationProperty
    extends IntegerConfigurationProperty {
        volatile int value;

        private GCMonitorFrequencyConfigurationProperty(IAgent agent) {
            super(GCMonitorAgentService.kGCMonitorFrequencyKey, Integer.valueOf(15000), agent.IAgent_getModuleFeedback(), kGCMonitorServiceModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            this.value = (Integer)newValue;
        }
    }
}

