/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.extension;

import com.wily.util.extension.IExtensionLocator;
import com.wily.util.extension.IExtensionProxy;
import com.wily.util.extension.InvalidExtensionException;
import com.wily.util.extension.JarExtensionProxy;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.IValidationFeedbackChannel;
import com.wily.util.io.ExtendedFile;
import com.wily.util.text.IStringLocalizer;
import com.wily.wilyassert.Assertion;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;

public final class ShallowJarExtensionLocator
implements IExtensionLocator {
    private final IModuleFeedbackChannel fFeedback;
    private final ExtendedFile fDirectory;
    private final boolean fLoadEclipsePlugins;
    private final IValidationFeedbackChannel fValidationFeedback;

    public ShallowJarExtensionLocator(IModuleFeedbackChannel feedback, IStringLocalizer localizer, ExtendedFile directoryWithJars) {
        this(feedback, localizer, directoryWithJars, false);
    }

    public ShallowJarExtensionLocator(IModuleFeedbackChannel feedback, IStringLocalizer localizer, ExtendedFile directoryWithJars, boolean loadEclipsePluginsAsExtensions) {
        this(feedback, localizer, directoryWithJars, false, null);
    }

    public ShallowJarExtensionLocator(IModuleFeedbackChannel feedback, IStringLocalizer localizer, ExtendedFile directoryWithJars, boolean loadEclipsePluginsAsExtensions, IValidationFeedbackChannel validationFeedback) {
        Assertion.wilyAssert(false);
        Assertion.wilyAssert(false);
        Assertion.wilyAssert(false);
        this.fFeedback = feedback;
        this.fDirectory = directoryWithJars;
        this.fLoadEclipsePlugins = loadEclipsePluginsAsExtensions;
        this.fValidationFeedback = validationFeedback;
    }

    private void logInfoValidationFeedback(String message) {
        if (this.fValidationFeedback != null) {
            this.fValidationFeedback.info(message);
        }
    }

    private void logErrorValidationFeedback(String message, Throwable cause) {
        if (this.fValidationFeedback != null) {
            this.fValidationFeedback.error(message, cause);
        }
    }

    private final IModuleFeedbackChannel getFeedback() {
        return this.fFeedback;
    }

    @Override
    public IExtensionProxy[] IExtensionLocator_locateExtensionProxies() {
        ArrayList<JarExtensionProxy> extensionProxies = new ArrayList<JarExtensionProxy>();
        File[] jars = this.fDirectory.listFiles(new JarFilenameFilter());
        int x = 0;
        while (x < jars.length) {
            ExtendedFile jar = new ExtendedFile(jars[x].getPath());
            try {
                JarExtensionProxy jarExtensionProxy = new JarExtensionProxy(jar, this.fLoadEclipsePlugins);
                extensionProxies.add(jarExtensionProxy);
                this.logInfoValidationFeedback("Artifact: " + jar.getCanonicalPath() + " name: " + this.getAttribute(jarExtensionProxy, "com-wily-Name", "<Unknown Name>") + " release: " + this.getAttribute(jarExtensionProxy, "com-wily-Release", "<Unknown Release>") + " build: " + this.getAttribute(jarExtensionProxy, "com-wily-Build", "<Unknown Build>"));
            }
            catch (InvalidExtensionException ioe) {
                this.getFeedback().error("Candidate jar file " + jar + " is not a legal extension: " + ioe);
                this.getFeedback().debug(ioe);
                this.logErrorValidationFeedback("Candidate jar file " + jar + " is not a legal extension: ", ioe);
            }
            catch (Throwable t) {
                this.getFeedback().error("Unexpected exception while loading candidate jar file " + jar, t);
                this.logErrorValidationFeedback("Unexpected exception while loading candidate jar file " + jar, t);
            }
            ++x;
        }
        return extensionProxies.toArray(new IExtensionProxy[extensionProxies.size()]);
    }

    private final String getAttribute(JarExtensionProxy jarExtensionProxy, String attributeName, String defaultValue) {
        String result = jarExtensionProxy.getMainAttributeValue(attributeName);
        return result == null ? defaultValue : result;
    }

    private static class JarFilenameFilter
    implements FilenameFilter {
        private JarFilenameFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".jar");
        }
    }
}

