/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.xml;

import com.wily.util.xml.NodeListIterator;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NodeListElementIterator
implements Enumeration {
    private final NodeListIterator fHelperIterator;
    private Element fNextElement;

    public NodeListElementIterator(NodeList list) {
        this.fHelperIterator = new NodeListIterator(list);
        this.prefetchNextElement();
    }

    public NodeListElementIterator(Element element) {
        this.fHelperIterator = new NodeListIterator(element);
        this.prefetchNextElement();
    }

    private void prefetchNextElement() {
        while (this.fHelperIterator.hasMoreElements()) {
            Node currentNode = this.fHelperIterator.nextNode();
            if (currentNode.getNodeType() != 1) continue;
            this.fNextElement = (Element)currentNode;
            return;
        }
        this.fNextElement = null;
    }

    @Override
    public boolean hasMoreElements() {
        return this.fNextElement != null;
    }

    public Element nextXMLElement() throws NoSuchElementException {
        if (!this.hasMoreElements()) {
            throw new NoSuchElementException();
        }
        Element result = this.fNextElement;
        this.prefetchNextElement();
        return result;
    }

    public Object nextElement() throws NoSuchElementException {
        return this.nextXMLElement();
    }
}

