/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.introscope.upgrade;

import com.ca.apm.introscope.launch.AgentUpdateInfo;
import com.ca.apm.introscope.upgrade.ALauncherAlgorithm;
import com.ca.apm.introscope.upgrade.LauncherException;
import com.ca.apm.introscope.upgrade.LauncherOrderOracle;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.util.logging.Logger;

public class MultiLauncherAlgorithm
extends ALauncherAlgorithm {
    private LauncherOrderOracle fOracle;
    private boolean fPerformedUpdate;

    public MultiLauncherAlgorithm(String agentArgs, Instrumentation inst, File launchPropertyFile, Logger logger) throws FileNotFoundException, IOException {
        super(agentArgs, inst, launchPropertyFile, logger);
    }

    @Override
    protected boolean onStart() {
        AgentUpdateInfo info;
        boolean success;
        block8: {
            success = false;
            boolean agentStarted = Boolean.parseBoolean(System.getProperty("com.ca.apm.introscope.launch.agent.started", "false"));
            if (agentStarted) {
                return success;
            }
            info = this.getUpdateInfo();
            String orderRange = this.getProperty("com.ca.apm.introscope.launch.agent.order", "0-1");
            this.fOracle = new LauncherOrderOracle(orderRange, info.getAgentDirectory(), this.getAgentJarName(), this.getAgentName(), this.getOrder());
            if (this.waitForOngoingUpdate()) break block8;
            return false;
        }
        try {
            if (info.isRequestingUpdate()) {
                ALauncherAlgorithm.UpdateStatusType status;
                if (this.fOracle.isLauncherTurnToUpdate() && info.isRequestingUpdate() && ((status = this.update(false)) == ALauncherAlgorithm.UpdateStatusType.SUCCESSFUL || status == ALauncherAlgorithm.UpdateStatusType.FAILED_BUT_CAN_START)) {
                    this.fPerformedUpdate = success = true;
                }
            } else if (this.fOracle.isLauncherTurnToStart()) {
                success = true;
            }
        }
        catch (LauncherException e) {
            this.getLogger().warning(e.getMessage());
        }
        return success;
    }

    @Override
    protected void onShutdown() {
        super.onShutdown();
        if (this.fPerformedUpdate) {
            // empty if block
        }
    }
}

