/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.autoprobe.dynamic;

import com.wily.diagnos.cmp.classmatcher.IClassMatcher;
import com.wily.diagnos.cmp.methodmatcher.IMethodMatcher;
import com.wily.introscope.autoprobe.dynamic.MethodMatcherInfo;
import com.wily.util.HashCodeUtils;
import com.wily.util.classfile.IModeledMethod;
import java.util.HashSet;
import java.util.Set;

public class FlagMatcher {
    private String fFlagName;
    private IClassMatcher fClassMatcher;
    private Set fMethodMatcherInfos = new HashSet();
    private boolean fIsEnabled;

    public FlagMatcher(String flagName, IClassMatcher classMatcher, boolean isEnabled) {
        this.fFlagName = flagName;
        this.fClassMatcher = classMatcher;
        this.fIsEnabled = isEnabled;
    }

    public String getFlagName() {
        return this.fFlagName;
    }

    public IClassMatcher getClassMatcher() {
        return this.fClassMatcher;
    }

    public void addMethodMatcherInfo(MethodMatcherInfo matcherInfo) {
        this.fMethodMatcherInfos.add(matcherInfo);
    }

    public Set getMethodMatcherInfo() {
        return this.fMethodMatcherInfos;
    }

    public Set getClonedMethodMatcherSet() {
        return (Set)((HashSet)this.fMethodMatcherInfos).clone();
    }

    public boolean isEnabled() {
        return this.fIsEnabled;
    }

    public boolean matchesMethod(IModeledMethod modeledMethod) {
        for (MethodMatcherInfo methodMatcherInfo : this.fMethodMatcherInfos) {
            IMethodMatcher methodMatcher = methodMatcherInfo.getMethodMatcher();
            if (!methodMatcher.IMethodMatcher_matches(modeledMethod)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        FlagMatcher other = (FlagMatcher)obj;
        if (!other.getFlagName().equals(this.fFlagName)) {
            return false;
        }
        if (other.isEnabled() != this.fIsEnabled) {
            return false;
        }
        return other.getClassMatcher().equals(this.fClassMatcher);
    }

    public String toString() {
        return "Flag Matcher for flag [" + this.fFlagName + "]" + " is Enabled :" + this.fIsEnabled;
    }

    public int hashCode() {
        return HashCodeUtils.accumulateHashCode((int)this.fFlagName.hashCode(), (boolean)this.fIsEnabled);
    }
}

