/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.autoprobe.dynamic;

import com.wily.diagnos.cmp.directives.DGCompilerSettings;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.connection.ConnectedServer;
import com.wily.introscope.agent.connection.IServerConnectionNotification;
import com.wily.introscope.agent.connection.IsengardServerConnectionManager;
import com.wily.introscope.agent.trace.intelligent.HighPerformanceTransactionCache;
import com.wily.introscope.agent.transformer.dynamic.IDynamicInstrumentationManager;
import com.wily.introscope.agent.transformer.dynamic.IDynamicInstrumentationTransformer;
import com.wily.introscope.agent.transformer.dynamic.UpdateDIStatusBehavior;
import com.wily.introscope.agent.util.ByteClassUtil;
import com.wily.introscope.api.instrument.dynamic.ADynamicInstrumentationPropertyDelegate;
import com.wily.introscope.autoprobe.IAutoProbeConfig;
import com.wily.introscope.autoprobe.ICompilerLogger;
import com.wily.introscope.autoprobe.dynamic.AgentDynamicInstrumentationBean;
import com.wily.introscope.autoprobe.dynamic.SettingsDiff;
import com.wily.introscope.autoprobe.dynamic.Util;
import com.wily.isengard.container.BeanActivationException;
import com.wily.util.INameChangeListener;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.heartbeat.IRegisteredBehavior;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.heartbeat.IntervalHeartbeat;
import com.wily.util.properties.hot.BooleanConfigurationProperty;
import com.wily.util.properties.hot.ConfigurationManager;
import com.wily.util.properties.hot.ConfigurationProperty;
import com.wily.util.text.IStringLocalizer;
import java.io.IOException;
import java.lang.instrument.ClassDefinition;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;

public class InstrumentationManager
implements IDynamicInstrumentationManager {
    public static final char kDotSeparator = '.';
    public static final char kJarSeparator = '/';
    public static final String kClassExtension = ".class";
    private static final String kDynamicInstrumentBehaviorName = "Introscope Dynamic Instrumentation Behavior";
    private static final String kDynamicInstrumentationBatchBehaviorName = "Introscope Dynamic Instrumentation Batch Behavior";
    private static final String kSimpleClassSearchEnabledName = "Enables searching of class resource using simple class name during redefinition of classes in DI";
    public static final String kDynamicInstrumentationEnabled = "introscope.autoprobe.dynamicinstrument.enabled";
    public static final String ksimpleClassNameSearchEnabled = "introscope.autoprobe.dynamicinstrument.simpleClassNameSearch.enabled";
    public static final String kDynamicInstrumentationPollingInterval = "introscope.autoprobe.dynamicinstrument.pollIntervalMinutes";
    public static final String kDynamicInstrumentationBatchLimit = "introscope.autoprobe.dynamic.limitRedefinedClassesPerBatchTo";
    public static final String kClassFileSizeLimit = "introscope.autoprobe.dynamicinstrument.classFileSizeLimitInMegs";
    private static long sBehaviorInterval = 60000L;
    private static long sBatchInterval = 30000L;
    private static int sBatchLimit = 10;
    private volatile IRegisteredBehavior fBatchBehavior;
    private int fClassFileSizeLimit;
    private int fRedefineClassLimit;
    private final IAgent fAgent;
    private final IAutoProbeConfig fAutoProbeConfig;
    private final Instrumentation fInstrumentation;
    private final IModuleFeedbackChannel fFeedback;
    private final IStringLocalizer fLocalizer;
    private final IntervalHeartbeat fHeartbeat;
    private final IDynamicInstrumentationTransformer fTransformer;
    public ConfigurationManager fConfigurationManager;
    private DGCompilerSettings fCompilerSettings;
    private int fCurrentClassesIndex;
    private Class[] fAllClassesInVM;
    private volatile boolean fRedefinitionInProgress;
    private volatile boolean fSimpleClassNameSearchEnabled;
    private SettingsDiff fSettingsDiff;
    private IRegisteredBehavior fDirectivesBehaviorNode;
    protected static boolean fHasInitialized = false;
    private static Module fModule = new Module("Instrumentation Manager");

    public InstrumentationManager(IAgent agent, IDynamicInstrumentationTransformer transformer, ICompilerLogger logger, IAutoProbeConfig configRepository, Instrumentation instrumentation) {
        this.fAgent = agent;
        this.fTransformer = transformer;
        this.fAutoProbeConfig = configRepository;
        this.fInstrumentation = instrumentation;
        this.fFeedback = this.fAgent.IAgent_getModuleFeedback();
        this.fLocalizer = this.fAgent.IAgent_getStringLocalizer();
        this.fHeartbeat = this.fAgent.IAgent_getConfigHeartbeat();
        this.fConfigurationManager = this.fAgent.IAgent_getConfigurationManager();
        if (this.fAgent.IAgent_getIndexedProperties().getBooleanProperty(kDynamicInstrumentationEnabled, false)) {
            long pollingInterval = this.fAgent.IAgent_getIndexedProperties().getLongProperty(kDynamicInstrumentationPollingInterval);
            if (pollingInterval > 0L) {
                sBehaviorInterval = pollingInterval * 60L * 1000L;
            }
            this.fFeedback.debug("Dynamic Instrument Polling interval set to :" + sBehaviorInterval / 60000L + "minutes");
            this.fCompilerSettings = this.fAutoProbeConfig.getCompilerSettings();
            this.fClassFileSizeLimit = ADynamicInstrumentationPropertyDelegate.getClassFileSizeLimit((IAgent)this.fAgent);
            this.fFeedback.debug("Class File Limit set to :" + this.fClassFileSizeLimit);
            this.fRedefineClassLimit = this.fAgent.IAgent_getIndexedProperties().safeGetPositiveIntProperty(kDynamicInstrumentationBatchLimit, sBatchLimit, this.fFeedback, this.fLocalizer);
            this.fFeedback.debug("Re-define Batch limit set to :" + this.fRedefineClassLimit);
            this.registerHeartBeat();
            this.doSimpleClassNameSearchInitialization();
        } else {
            this.fFeedback.warn("Dynamic Instrumentation is turned off");
        }
        this.registerAgentBean(agent, transformer);
    }

    private void doSimpleClassNameSearchInitialization() {
        BooleanConfigurationProperty simpleClassNameSearchEnabled = new BooleanConfigurationProperty(ksimpleClassNameSearchEnabled, Boolean.FALSE, kSimpleClassSearchEnabledName, true, false, this.fFeedback, fModule, this.fLocalizer){

            public void set(Object newValue) {
                InstrumentationManager.this.fSimpleClassNameSearchEnabled = (Boolean)newValue;
            }
        };
        this.fConfigurationManager.add((ConfigurationProperty)simpleClassNameSearchEnabled, true);
    }

    private void registerAgentBean(final IAgent agent, final IDynamicInstrumentationTransformer transformer) {
        IRegisteredBehavior behavior;
        WaitForConnectionRunnable target = new WaitForConnectionRunnable(){

            public void ITimestampedRunnable_execute(long nowInMillis) {
                IsengardServerConnectionManager manager = agent.IAgent_getIsengardServerConnection();
                if (manager != null && manager.getConnectedServer() != null && manager.getConnectedServer().isConnected() && transformer.getClassRedefinitionDelegate() != null) {
                    if (!fHasInitialized) {
                        manager.addConnectionObserver(new IServerConnectionNotification(){

                            public void connectionUp() {
                                InstrumentationManager.this.registerDynamicInstrumentationBeans(agent.IAgent_getIsengardServerConnection(), agent);
                            }

                            public void connectionDown() {
                            }
                        });
                        new UpdateDIStatusBehavior(agent, transformer).start();
                        agent.IAgent_addNameChangeListener(new INameChangeListener(){

                            public void INameChangeListener_nameChanged(String newName) {
                                InstrumentationManager.this.fFeedback.debug("Dynamic Instrumentation is noticing that the name of the agent changed");
                                agent.IAgent_getTransformerAdministrator().getDynamicInstrumentationTransformer().getDynamicInstrumentationService().forceBroadcast();
                                InstrumentationManager.this.fFeedback.debug("Dynamic Instrumentation has reset the DI status");
                            }
                        });
                        agent.IAgent_addNegotiatedNameChangeListener(new INameChangeListener(){

                            public void INameChangeListener_nameChanged(String newName) {
                                InstrumentationManager.this.fFeedback.debug("Dynamic Instrumentation is noticing that the negotiated name of the agent changed");
                                agent.IAgent_getTransformerAdministrator().getDynamicInstrumentationTransformer().getDynamicInstrumentationService().forceBroadcast();
                                InstrumentationManager.this.fFeedback.debug("Dynamic Instrumentation has reset the DI status");
                            }
                        });
                        fHasInitialized = true;
                    }
                    if (fHasInitialized && this.behaviorHandle != null) {
                        this.behaviorHandle.close();
                    }
                }
            }
        };
        target.behaviorHandle = behavior = agent.IAgent_getCommonHeartbeat().addBehavior((ITimestampedRunnable)target, "Waiting for Dynamic", true, 1000L, System.currentTimeMillis() + 5000L);
    }

    private boolean registerDynamicInstrumentationBeans(IsengardServerConnectionManager serverConnection, IAgent agent) {
        this.fFeedback.verbose(fModule, "Registering agent beans");
        ConnectedServer server = serverConnection.getConnectedServer();
        if (server == null) {
            return false;
        }
        try {
            server.addBean(AgentDynamicInstrumentationBean.class, (Object)agent);
            agent.IAgent_getModuleFeedback().info(fModule, this.fLocalizer.IStringLocalizer_getLocalizedString("Dynamic_Instrumentation_Bean_deployed"));
            return true;
        }
        catch (BeanActivationException e) {
            this.fFeedback.error(fModule, "Unable to register Dynamic Instrumentation bean");
            this.fFeedback.verbose(fModule, "Unable to register Dynamic Instrumentation bean", (Throwable)e);
            return false;
        }
    }

    private void registerHeartBeat() {
        if (!this.fInstrumentation.isRedefineClassesSupported()) {
            this.fFeedback.warn(this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("Dynamic_Instrumentation_Disabled", ""));
        } else {
            this.fFeedback.info(this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("Dynamic_Instrumentation_Enabled", ""));
            DirectivesSyncBehavior directivesBehavior = new DirectivesSyncBehavior();
            this.fDirectivesBehaviorNode = this.fHeartbeat.addBehavior((ITimestampedRunnable)directivesBehavior, kDynamicInstrumentBehaviorName, true, sBehaviorInterval, System.currentTimeMillis() + sBehaviorInterval + 10000L);
            BatchBehavior behavior = new BatchBehavior();
            this.fBatchBehavior = this.fHeartbeat.addBehavior((ITimestampedRunnable)behavior, kDynamicInstrumentationBatchBehaviorName, false, sBatchInterval, false);
        }
    }

    public void checkDirectivesNow() {
        IntervalHeartbeat.BehaviorNode node = (IntervalHeartbeat.BehaviorNode)this.fDirectivesBehaviorNode;
        if (node != null) {
            node.scheduleForNow(System.currentTimeMillis());
            node.IRegisteredBehavior_setEnableState(false);
            node.IRegisteredBehavior_setEnableState(true);
        }
    }

    private boolean syncDirectives() {
        this.fFeedback.debug("Syncing up directives");
        if (this.fAutoProbeConfig.getCompilerSettings() == this.fCompilerSettings) {
            this.fFeedback.debug("[Dynamic Instrumentation]Compiler Settings did not change");
            return false;
        }
        this.fFeedback.info(this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("Detected_Changed_Directives", ""));
        this.fFeedback.debug("[Dynamic Instrumentation]Compiler Settings changed");
        return true;
    }

    /*
     * Exception decompiling
     */
    private void processAllClasses() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[WHILELOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void setupForRedefinition() {
        this.fFeedback.debug("Setting up for re-definition");
        if (this.fSettingsDiff == null) {
            this.fSettingsDiff = new SettingsDiff(this.fCompilerSettings, this.fAutoProbeConfig.getCompilerSettings(), this.fFeedback);
            this.fAllClassesInVM = this.fInstrumentation.getAllLoadedClasses();
            this.fRedefinitionInProgress = true;
            this.fCurrentClassesIndex = 0;
            this.fFeedback.debug("total classes in the VM->" + this.fAllClassesInVM.length);
        }
    }

    private void wrapUpRedefinition() {
        this.fFeedback.info(this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("Finished_Processing_All_Classes", ""));
        this.fSettingsDiff = null;
        this.fAllClassesInVM = null;
        this.fCurrentClassesIndex = 0;
        this.fCompilerSettings = this.fAutoProbeConfig.getCompilerSettings();
        if (this.fBatchBehavior.IRegisteredBehavior_isActive()) {
            this.fBatchBehavior.IRegisteredBehavior_setEnableState(false);
        }
        this.fTransformer.redefinitionComplete();
        if (this.fAgent.IAgent_getTracerAdministrator() != null) {
            this.fAgent.IAgent_getTracerAdministrator().clearProbeLookupTable();
        }
        if (HighPerformanceTransactionCache.getInstance() != null) {
            HighPerformanceTransactionCache.getInstance().clearAll();
        }
    }

    private boolean needsRedefine(Class cls) {
        if (Util.shouldSkip(cls, this.fCompilerSettings)) {
            return false;
        }
        if (this.fFeedback.isDebugEnabled()) {
            this.fFeedback.debug("Checking to see if class " + cls.getName() + " needs to be re-defined.");
        }
        if (this.fSettingsDiff.doesClassNeedRedefine(cls)) {
            this.fFeedback.debug("Class " + cls.getName() + " needs to be re-defined.");
            return true;
        }
        return false;
    }

    private void redefineClass(Class cls) {
        if (this.fFeedback.isTraceEnabled()) {
            this.fFeedback.trace("[Dynamic Instrumentation]Attempting to re-define Class " + cls.getName());
        }
        byte[] classBytes = null;
        try {
            classBytes = ByteClassUtil.getBytesForClass((Class)cls, (int)this.fClassFileSizeLimit, (IModuleFeedbackChannel)this.fFeedback, (boolean)this.fSimpleClassNameSearchEnabled);
            if (classBytes != null) {
                if (ByteClassUtil.byteArrayToInt((byte[])classBytes, (int)0) == -889275714) {
                    ClassDefinition classDef = new ClassDefinition(cls, classBytes);
                    this.fInstrumentation.redefineClasses(classDef);
                    this.fFeedback.info(this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("Redefined_Class", cls.getName()));
                } else {
                    this.fFeedback.info(this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("Redefined_Class_Skipped", cls.getName()));
                }
            }
        }
        catch (ClassNotFoundException e) {
            this.fFeedback.warn(this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("Class_Redefine_Failed", ""), (Throwable)e);
        }
        catch (UnmodifiableClassException e) {
            this.fFeedback.warn(this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("Class_Redefine_Failed", ""), (Throwable)e);
        }
        catch (IOException e) {
            this.fFeedback.debug("Could not obtain class bytes for the class -" + cls.getName(), (Throwable)e);
        }
        catch (Throwable e) {
            this.fFeedback.debug("Re-define failed for class-" + cls.getName(), e);
        }
    }

    private final class BatchBehavior
    implements ITimestampedRunnable {
        private BatchBehavior() {
        }

        public void ITimestampedRunnable_execute(long nowInMillis) {
            InstrumentationManager.this.processAllClasses();
        }
    }

    private final class DirectivesSyncBehavior
    implements ITimestampedRunnable {
        private DirectivesSyncBehavior() {
        }

        public void ITimestampedRunnable_execute(long nowInMillis) {
            if (InstrumentationManager.this.fRedefinitionInProgress) {
                return;
            }
            boolean settingsChanged = InstrumentationManager.this.syncDirectives();
            if (settingsChanged) {
                InstrumentationManager.this.processAllClasses();
            }
        }
    }

    static abstract class WaitForConnectionRunnable
    implements ITimestampedRunnable {
        IRegisteredBehavior behaviorHandle;

        WaitForConnectionRunnable() {
        }
    }
}

