/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.event;

import com.wily.util.event.AListenerEvent;
import com.wily.util.event.BadEventException;
import com.wily.util.event.ITrackableListener;
import com.wily.util.event.ITrackableListenerAllListeners;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.io.PrintWriter;
import java.util.Vector;

public class ListenerTracker {
    public static final ITrackableListener kBroadcastToAllListeners = new DummyListener();
    private static final ITrackableListener[] kZeroLengthTrackableListenerArray = new ITrackableListener[0];
    private final IModuleFeedbackChannel fFeedback;
    private final Class fListenerClass;
    private final Vector fAsyncListeners;
    private static final boolean sDebug = false;
    private static Vector sTrackers;

    public ListenerTracker(IModuleFeedbackChannel feedback, String name, Class listenerClass) {
        this.fFeedback = feedback;
        this.fListenerClass = listenerClass;
        this.fAsyncListeners = new Vector(2);
        ListenerTracker.debug_track(this);
    }

    private IModuleFeedbackChannel getModuleFeedback() {
        return this.fFeedback;
    }

    public boolean isListener(ITrackableListener listener) {
        return this.fAsyncListeners.contains(listener);
    }

    String getName() {
        return "ListenerTracker";
    }

    void addBroadcastListener(ITrackableListener newListener) {
        if (!this.fListenerClass.isInstance(newListener)) {
            throw new IllegalArgumentException("Listener " + newListener + " is not of type " + this.fListenerClass);
        }
        this.fAsyncListeners.addElement(newListener);
    }

    void removeBroadcastListener(ITrackableListener listenerToRemove) {
        if (!this.fListenerClass.isInstance(listenerToRemove)) {
            throw new IllegalArgumentException("Listener " + listenerToRemove + " is not of type " + this.fListenerClass);
        }
        this.fAsyncListeners.removeElement(listenerToRemove);
    }

    void sendEventToAllAsyncListeners(AListenerEvent event) {
        Vector asyncListenersSnapshot = (Vector)this.fAsyncListeners.clone();
        for (int i = asyncListenersSnapshot.size() - 1; i >= 0; --i) {
            this.sendEventToOneListener((ITrackableListener)asyncListenersSnapshot.elementAt(i), event);
        }
    }

    ITrackableListener[] getBroadcastListenerSnapshot() {
        return this.fAsyncListeners.toArray(kZeroLengthTrackableListenerArray);
    }

    void sendEventToOneListener(ITrackableListener listener, AListenerEvent event) {
        try {
            listener.handleEvent(event);
        }
        catch (Throwable e) {
            IModuleFeedbackChannel feedbackChannel = this.getModuleFeedback();
            feedbackChannel.error("ListenerTracker.sendEventToOneListener threw delivering: " + event + " to: " + listener, e);
        }
    }

    private static void debug_init() {
    }

    private static void debug_track(ListenerTracker tracker) {
    }

    public static void debugLogAll(IModuleFeedbackChannel feedback) {
        feedback.debug("ListenerTracker debugLog facility not available. Turn debug on to use.");
    }

    public void debugLog(IModuleFeedbackChannel feedback) {
        feedback.debug("ListenerTracker debugLog: " + this.getName());
        feedback.debug("\tlistener class: " + this.fListenerClass.getName());
        feedback.debug("\tlistener count: " + this.fAsyncListeners.size());
        for (int i = 0; i < this.fAsyncListeners.size(); ++i) {
            feedback.debug("\t" + i + "\t" + this.fAsyncListeners.elementAt(i).toString());
        }
    }

    public void debugLog(PrintWriter log) {
        log.println("ListenerTracker debugLog: " + this.getName());
        log.println("\tlistener class: " + this.fListenerClass.getName());
        log.println("\tlistener count: " + this.fAsyncListeners.size());
        for (int i = 0; i < this.fAsyncListeners.size(); ++i) {
            log.println("\t" + i + "\t" + this.fAsyncListeners.elementAt(i).toString());
        }
    }

    static {
        ListenerTracker.debug_init();
    }

    private static class DummyListener
    implements ITrackableListener,
    ITrackableListenerAllListeners {
        private DummyListener() {
        }

        public void handleEvent(AListenerEvent event) throws BadEventException {
        }

        public String getTrackableListenerName() {
            return "DummyListener";
        }
    }
}

