/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.finder;

import com.wily.util.finder.IIndexedPropertiesFinder;
import com.wily.util.finder.IIndexedPropertiesFinderFeedback;
import com.wily.util.io.ExtendedFile;
import com.wily.util.properties.IndexedProperties;
import com.wily.util.text.IStringLocalizer;
import com.wily.wilyassert.Assertion;
import java.io.FileInputStream;

public class WorkingDirectoryProfileFinder
implements IIndexedPropertiesFinder {
    private final IStringLocalizer fLocalizer;
    private final String fProfileFileName;

    public WorkingDirectoryProfileFinder(IStringLocalizer local, String profileFileName) {
        Assertion.wilyAssert(local != null);
        Assertion.wilyAssert(profileFileName != null);
        this.fLocalizer = local;
        this.fProfileFileName = profileFileName;
    }

    public IndexedProperties IIndexedPropertiesFinder_findProperties(IIndexedPropertiesFinderFeedback feedback) {
        IndexedProperties resultProps = null;
        String statusMessage = "";
        String fullPath = new ExtendedFile(this.fProfileFileName).safeGetCanonicalPath();
        try {
            statusMessage = this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("Profile_Search_Working_Directory_Attempt_Message", fullPath);
            feedback.IIndexedPropertiesFinderFeedback_feedbackStatus(statusMessage);
            resultProps = new IndexedProperties();
            resultProps.load(new FileInputStream(this.fProfileFileName));
            statusMessage = this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("Profile_Search_Working_Directory_Succeeded_Message", fullPath);
            feedback.IIndexedPropertiesFinderFeedback_feedbackStatus(statusMessage);
        }
        catch (Throwable t) {
            statusMessage = this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("Profile_Search_Working_Directory_Failed_Message", fullPath, t.getClass().getName(), t.getMessage());
            feedback.IIndexedPropertiesFinderFeedback_feedbackFailure(statusMessage);
            resultProps = null;
        }
        return resultProps;
    }
}

