/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.text;

import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.text.AStringLocalizer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class MultipleResourceBundleStringLocalizer
extends AStringLocalizer {
    private final IModuleFeedbackChannel fFeedback;
    private final boolean fLogMissingKeys;
    private final List fLocalizedStringsBundleList;
    private final Map fCache;

    public MultipleResourceBundleStringLocalizer(IModuleFeedbackChannel moduleFeedback, ClassLoader classLoaderToUse, String[] fullyQualifiedNames) {
        this(moduleFeedback, classLoaderToUse, fullyQualifiedNames, true);
    }

    public MultipleResourceBundleStringLocalizer(IModuleFeedbackChannel moduleFeedback, ClassLoader classLoaderToUse, String[] fullyQualifiedNames, boolean logMissingKeys) {
        this.fFeedback = moduleFeedback;
        this.fLogMissingKeys = logMissingKeys;
        this.fLocalizedStringsBundleList = new ArrayList(fullyQualifiedNames.length);
        this.makeResourceBundles(classLoaderToUse, fullyQualifiedNames);
        this.fCache = Collections.synchronizedMap(new HashMap());
    }

    public IModuleFeedbackChannel getModuleFeedback() {
        return this.fFeedback;
    }

    public boolean shouldLogMissingKeys() {
        return this.fLogMissingKeys;
    }

    public void addResourceBundle(String fullyQualifiedName, ClassLoader classLoaderToUse) {
        ResourceBundle newBundle = null;
        try {
            newBundle = classLoaderToUse != null ? ResourceBundle.getBundle(fullyQualifiedName, Locale.getDefault(), classLoaderToUse) : ResourceBundle.getBundle(fullyQualifiedName, Locale.getDefault());
        }
        catch (MissingResourceException mre) {
            this.fFeedback.error("Can't find localization resource: \"" + fullyQualifiedName + "\". Using defaults...");
        }
        if (newBundle != null) {
            this.fLocalizedStringsBundleList.add(newBundle);
        }
    }

    private void makeResourceBundles(ClassLoader classLoaderToUse, String[] fullyQualifiedNames) {
        for (int x = 0; x < fullyQualifiedNames.length; ++x) {
            this.addResourceBundle(fullyQualifiedNames[x], classLoaderToUse);
        }
    }

    protected String getLocalizedString(String key) {
        String userString = (String)this.fCache.get(key);
        if (userString == null) {
            Iterator i = this.fLocalizedStringsBundleList.iterator();
            while (i.hasNext()) {
                ResourceBundle bundle = (ResourceBundle)i.next();
                try {
                    userString = bundle.getString(key);
                    this.fCache.put(key, userString);
                    return userString;
                }
                catch (MissingResourceException mre) {
                }
            }
            if (this.shouldLogMissingKeys()) {
                this.getModuleFeedback().error("Can't find localized string: \"" + key + "\".");
                if (this.getModuleFeedback().isDebugEnabled()) {
                    Thread.dumpStack();
                }
            }
            this.fCache.put(key, key);
            return key;
        }
        return userString;
    }

    public String getFormattedLocalizedString(String key, String[] arguments) {
        String userString = null;
        String userMessage = this.getLocalizedString(key);
        try {
            userString = MessageFormat.format(userMessage, arguments);
        }
        catch (IllegalArgumentException iae) {
            this.getModuleFeedback().verbose(iae);
        }
        if (userString == null) {
            userString = key;
        }
        return userString;
    }
}

