/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.bizdef.patternDef;

import com.wily.introscope.agent.CEMFilterHelper;
import com.wily.introscope.agent.bizdef.IBizParameterSet;
import com.wily.introscope.agent.bizdef.constants.KBizConstants;
import com.wily.introscope.agent.bizdef.patternDef.BizRulePatternSet;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public final class BizRulePatternArraySet {
    private List patternSetList;
    private BizRulePatternSet[] patternSetAsArray = new BizRulePatternSet[0];

    public BizRulePatternArraySet() {
        this.initialize();
    }

    public synchronized void initialize() {
        this.patternSetList = new ArrayList();
    }

    public synchronized void addPatternAtStart(BizRulePatternSet bizRulePatternSet) {
        this.patternSetList.add(0, bizRulePatternSet);
        this.patternSetAsArray = this.patternSetList.toArray(this.patternSetAsArray);
    }

    public synchronized void addPatternAtEnd(BizRulePatternSet bizRulePatternSet) {
        this.patternSetList.add(bizRulePatternSet);
        this.patternSetAsArray = this.patternSetList.toArray(this.patternSetAsArray);
    }

    public synchronized void removePattern(BizRulePatternSet bizRulePatternSet) {
        this.patternSetList.remove(bizRulePatternSet);
        this.patternSetAsArray = this.patternSetList.toArray(new BizRulePatternSet[0]);
    }

    public synchronized List getPatternList() {
        return this.patternSetList;
    }

    public synchronized boolean contains(BizRulePatternSet bizRulePatternSet) {
        return this.patternSetList.contains(bizRulePatternSet);
    }

    public synchronized boolean containsPostPattern() {
        boolean result = false;
        for (BizRulePatternSet s : this.patternSetList) {
            boolean bl = result = result || s.containsPostParameters();
            if (result) break;
        }
        return result;
    }

    public BizRulePatternSet matches(IBizParameterSet bizParameterSet, IModuleFeedbackChannel feedback, int postFlag, boolean isVerbose, boolean forceTurnOffNonIdentifyingTxn) throws UnsupportedEncodingException {
        if (isVerbose) {
            feedback.verbose(KBizConstants.kBizDefModule, "Attempting to match Business Parameter Set to a Business Pattern Rule Set, postFlag = " + postFlag);
        }
        int length = Integer.MIN_VALUE;
        BizRulePatternSet rulePatternSet = null;
        int index = 0;
        while (index < this.patternSetAsArray.length) {
            int tempLength;
            BizRulePatternSet tempRulePatternSet;
            if (!(tempRulePatternSet = this.patternSetAsArray[index++]).isIdentifying() && (forceTurnOffNonIdentifyingTxn || !CEMFilterHelper.getInstance().isTraceRequestedFor(tempRulePatternSet.getBusinessTxnName())) || !tempRulePatternSet.matches(bizParameterSet, feedback, postFlag, isVerbose)) continue;
            if (isVerbose) {
                feedback.verbose(KBizConstants.kBizDefModule, "Business Parameter Set found a match to a Business Pattern Rule Set");
            }
            if ((tempLength = tempRulePatternSet.getLength()) <= length) continue;
            length = tempLength;
            rulePatternSet = tempRulePatternSet;
        }
        if (isVerbose && rulePatternSet == null) {
            feedback.verbose(KBizConstants.kBizDefModule, "Business Parameter Set did not find a match to any Business Pattern Rule Sets");
        }
        return rulePatternSet;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("");
        for (BizRulePatternSet pattern : this.patternSetList) {
            buffer.append(pattern.toString());
        }
        return buffer.toString();
    }

    public boolean equals(Object arg0) {
        if (arg0 != null) {
            return this.toString().equals(arg0.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public int size() {
        return this.patternSetList.size();
    }
}

