/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util;

import com.wily.wilyassert.Assertion;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

public class StringUtils {
    protected static final String[] kEmptyStringArray = new String[0];
    protected static final String[] kArrayWithEmptyString = new String[]{""};
    public static char kStartingBookend = (char)123;
    public static char kEndingBookend = (char)125;
    private static final char[] kDangerousExecArgumentCharacters = new char[]{'\"', '\''};

    protected StringUtils() {
    }

    public static boolean isEmpty(String string) {
        if (string == null) {
            return true;
        }
        int length = string.length();
        int i = 0;
        while (i < length) {
            if (!Character.isWhitespace(string.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String getNumericalText(Object number) {
        if (number instanceof Integer) {
            return Integer.toString((Integer)number);
        }
        if (number instanceof Long) {
            return Long.toString((Long)number);
        }
        if (number instanceof Float) {
            return Float.toString(((Float)number).floatValue());
        }
        if (number instanceof Double) {
            return Double.toString((Double)number);
        }
        throw new IllegalArgumentException("number must be an Integer, Long, Float or Double");
    }

    public static String addBookends(String s) {
        if (s == null) {
            return null;
        }
        return String.valueOf(kStartingBookend) + s + kEndingBookend;
    }

    public static String removeBookends(String s) {
        if (s == null || s.length() < 2 || s.charAt(0) != kStartingBookend || s.charAt(s.length() - 1) != kEndingBookend) {
            return null;
        }
        return s.substring(1, s.length() - 1);
    }

    public static String byteArrayToString(byte[] byteArray) {
        StringBuilder stringBuffer = new StringBuilder(byteArray.length * 2);
        int i = 0;
        while (i < byteArray.length) {
            String curByteAsHex = Integer.toHexString(byteArray[i] & 0xFF);
            if (curByteAsHex.length() == 1) {
                curByteAsHex = "0" + curByteAsHex;
            }
            Assertion.wilyAssert(curByteAsHex.length() == 2);
            stringBuffer.append(curByteAsHex);
            ++i;
        }
        return stringBuffer.toString();
    }

    public static byte[] stringToByteArray(String original) {
        char[] charArray = original.trim().toCharArray();
        Assertion.wilyAssert(charArray.length % 2 == 0);
        byte[] byteArray = new byte[charArray.length / 2];
        int i = 0;
        while (i < byteArray.length) {
            byte curByte;
            String smallHexBuffer = "" + charArray[i * 2] + charArray[i * 2 + 1];
            int curInt = Integer.parseInt(smallHexBuffer, 16);
            byteArray[i] = curByte = (byte)curInt;
            ++i;
        }
        return byteArray;
    }

    public static String[] parseList(String list, String separators) {
        Vector<String> elements = new Vector<String>();
        StringTokenizer tokenizer = new StringTokenizer(list, separators);
        while (tokenizer.hasMoreTokens()) {
            elements.addElement(tokenizer.nextToken().trim());
        }
        Object[] result = new String[elements.size()];
        elements.copyInto(result);
        return result;
    }

    public static String[] parseAndTrimList(String list, String separators) {
        return StringUtils.parseAndTrimList(list, separators, false);
    }

    public static String[] parseAndTrimList(String list, String separators, boolean includeEmptyStrings) {
        if (list == null) {
            return null;
        }
        if (list.equals("")) {
            if (includeEmptyStrings) {
                return kArrayWithEmptyString;
            }
            return kEmptyStringArray;
        }
        if (separators == null || separators.equals("")) {
            if (list.equals("") && !includeEmptyStrings) {
                return kEmptyStringArray;
            }
            return new String[]{list};
        }
        ArrayList<String> elements = new ArrayList<String>();
        boolean returnDelimiters = includeEmptyStrings;
        boolean lastWasDelimiter = true;
        boolean isFirstToken = true;
        StringTokenizer tokenizer = new StringTokenizer(list, separators, returnDelimiters);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (includeEmptyStrings && separators.indexOf(token) != -1) {
                if (lastWasDelimiter) {
                    elements.add("");
                }
                lastWasDelimiter = true;
            } else {
                elements.add(token.trim());
                lastWasDelimiter = false;
            }
            isFirstToken = false;
        }
        if (includeEmptyStrings && lastWasDelimiter && !isFirstToken) {
            elements.add("");
        }
        String[] result = new String[elements.size()];
        result = elements.toArray(result);
        return result;
    }

    public static Set parseAndTrimListToSet(String list, String separators) {
        return StringUtils.parseAndTrimListToSet(list, separators, false);
    }

    public static Set parseAndTrimListToSet(String list, String separators, boolean includeEmptyStrings) {
        String[] resultArray = StringUtils.parseAndTrimList(list, separators, includeEmptyStrings);
        HashSet<String> result = new HashSet<String>();
        if (resultArray != null) {
            int i = 0;
            while (i < resultArray.length) {
                String s = resultArray[i];
                if (s != null && (includeEmptyStrings || s.length() > 0)) {
                    result.add(s);
                }
                ++i;
            }
        }
        return result;
    }

    public static String[] wordWrap(String source, int length) {
        Vector<String> substrings = new Vector<String>();
        do {
            if (source.length() <= length) {
                substrings.addElement(source);
                break;
            }
            int lineBreak = StringUtils.findBreak(source, length);
            substrings.addElement(source.substring(0, lineBreak));
            source = source.substring(lineBreak);
            if (source.equals("") || source.charAt(0) != ' ') continue;
            source = source.substring(1);
        } while (!source.equals(""));
        Object[] results = new String[substrings.size()];
        substrings.copyInto(results);
        return results;
    }

    public static String wordWrapWithLineBreaks(String source, int length) {
        String[] strArray = StringUtils.wordWrap(source, length);
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < strArray.length) {
            result.append(strArray[i]);
            result.append(System.getProperty("line.separator"));
            ++i;
        }
        return result.toString();
    }

    public static String htmlWordWrap(String source, int length) {
        String[] lines = StringUtils.wordWrap(source, length);
        String wrappedText = "<html>";
        int i = 0;
        while (i < lines.length) {
            wrappedText = String.valueOf(wrappedText) + lines[i] + "<br>";
            ++i;
        }
        wrappedText = String.valueOf(wrappedText) + "</html>";
        return wrappedText;
    }

    private static int findBreak(String source, int index) {
        int i = index;
        while (i >= 0) {
            if (source.charAt(i) == ' ') {
                return i;
            }
            --i;
        }
        return index;
    }

    public static boolean containsTrailingSpaces(String orig) {
        if (orig == null || orig.length() == 0) {
            return false;
        }
        return orig.charAt(orig.length() - 1) == ' ';
    }

    public static String removeTrailingSpaces(String orig) {
        if (orig == null) {
            return orig;
        }
        int numSpaces = 0;
        int cursor = orig.length() - 1;
        while (cursor >= 0 && orig.charAt(cursor) == ' ') {
            --cursor;
            ++numSpaces;
        }
        if (numSpaces > 0) {
            return orig.substring(0, cursor + 1);
        }
        return orig;
    }

    public static String replace(String original, String source, String dest) {
        int end;
        StringBuilder buffer = new StringBuilder(original.length() + dest.length());
        if (source.length() == 0) {
            return original;
        }
        int start = 0;
        while ((end = original.indexOf(source, start)) >= 0) {
            buffer.append(original.substring(start, end));
            buffer.append(dest);
            start = end + source.length();
        }
        buffer.append(original.substring(start));
        return buffer.toString();
    }

    public static String trim(String original) {
        return original == null ? null : original.trim();
    }

    public static String ensureNonNullString(String string) {
        return string == null ? "" : string;
    }

    public static String multipleReplace(String original, String[] source, String[] dest) {
        int start = 0;
        int[] indexPair = new int[2];
        StringUtils.findFirstIndexOf(original, start, source, indexPair);
        if (indexPair[0] < 0) {
            return original;
        }
        StringBuilder buffer = new StringBuilder();
        while (indexPair[0] >= 0) {
            buffer.append(original.substring(start, indexPair[0]));
            buffer.append(dest[indexPair[1]]);
            start = indexPair[0] + source[indexPair[1]].length();
            StringUtils.findFirstIndexOf(original, start, source, indexPair);
        }
        buffer.append(original.substring(start));
        return buffer.toString();
    }

    private static void findFirstIndexOf(String original, int start, String[] source, int[] results) {
        results[0] = -1;
        results[1] = -1;
        int i = 0;
        while (i < source.length) {
            int cur = original.indexOf(source[i], start);
            if (source[i].length() == 0) {
                cur = -1;
            }
            if ((results[0] < 0 || cur < results[0]) && cur >= 0) {
                results[0] = cur;
                results[1] = i;
            }
            ++i;
        }
    }

    public static int stringToMnemonic(String source) {
        if (source == null || source.length() == 0) {
            return -1;
        }
        return Character.toUpperCase(source.charAt(0));
    }

    private static boolean isDangerousExecArgumentCharacter(char c) {
        if (c == ' ') {
            return false;
        }
        if (Character.isWhitespace(c)) {
            return true;
        }
        if (Character.isISOControl(c)) {
            return true;
        }
        int i = 0;
        while (i < kDangerousExecArgumentCharacters.length) {
            if (c == kDangerousExecArgumentCharacters[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String replaceDangerousExecArgumentCharactersWithSpaces(String source) {
        String result = source;
        int length = source.length();
        int i = 0;
        while (i < length) {
            char curChar = source.charAt(i);
            if (StringUtils.isDangerousExecArgumentCharacter(curChar)) {
                result = result.replace(curChar, ' ');
            }
            ++i;
        }
        return result;
    }

    public static int getIndexOfFirstDigit(String source) {
        return StringUtils.getIndexOfFirstDigit(source, 0);
    }

    public static int getIndexOfFirstDigit(String source, int fromIndex) {
        int firstDigitIndex = -1;
        int i = fromIndex;
        while (i < source.length() && firstDigitIndex == -1) {
            firstDigitIndex = Character.isDigit(source.charAt(i)) ? i : -1;
            ++i;
        }
        return firstDigitIndex;
    }

    public static boolean nullHandlingEquals(String str1, String str2) {
        if (str1 == null) {
            return str2 == null;
        }
        return str1.equals(str2);
    }

    public static String replaceCharAndTrim(String stringToClean, char origChar, char destChar) {
        return stringToClean.replace(origChar, destChar).trim();
    }

    public static String replaceIllegalChars(String source, char[] illegalChars, char replacementChar) {
        if (source != null && illegalChars != null) {
            int i = 0;
            while (i < illegalChars.length) {
                if (source.indexOf(illegalChars[i]) != -1) {
                    source = source.replace(illegalChars[i], replacementChar);
                }
                ++i;
            }
        }
        return source;
    }

    public static String replaceNonAlphaNumericCharacters(String originalStr, char replacementChar) {
        if (originalStr == null) {
            return null;
        }
        int originalChars = originalStr.length();
        StringBuilder buff = new StringBuilder(originalChars);
        int i = 0;
        while (i < originalChars) {
            char nextChar = originalStr.charAt(i);
            if (nextChar >= 'a' && nextChar <= 'z' || nextChar >= 'A' && nextChar <= 'Z' || nextChar >= '0' && nextChar <= '9') {
                buff.append(nextChar);
            } else {
                buff.append(replacementChar);
            }
            ++i;
        }
        return buff.toString();
    }

    public static boolean isWhitespace(String string) {
        int i = 0;
        while (i < string.length()) {
            if (!Character.isWhitespace(string.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String escapeHTMLSpecialCharacters(String text) {
        if (text.indexOf(60) == -1 && text.indexOf(62) == -1 && text.indexOf(38) == -1) {
            return text;
        }
        StringBuilder result = new StringBuilder(text.length() + 5);
        int i = 0;
        while (i < text.length()) {
            switch (text.charAt(i)) {
                case '<': {
                    result.append("&lt;");
                    break;
                }
                case '>': {
                    result.append("&gt;");
                    break;
                }
                case '&': {
                    result.append("&amp;");
                    break;
                }
                default: {
                    result.append(text.charAt(i));
                }
            }
            ++i;
        }
        return result.toString();
    }

    public static String concatAndEscapeStrings(String first, String second, char separator, char separatorReplacementChar) {
        String result = "";
        if (first == null) {
            first = "";
        }
        if (second == null) {
            second = "";
        }
        result = first.replace(separator, separatorReplacementChar);
        result = String.valueOf(result) + separator;
        result = String.valueOf(result) + second.replace(separator, separatorReplacementChar);
        return result;
    }

    public static String concatAndEscapeStrings(String first, String second, String third, char separator, char separatorReplacementChar) {
        String result = StringUtils.concatAndEscapeStrings(first, second, separator, separatorReplacementChar);
        if (third == null) {
            third = "";
        }
        result = String.valueOf(result) + separator;
        result = String.valueOf(result) + third.replace(separator, separatorReplacementChar);
        return result;
    }

    public static String stripQuerySpecialChars(String s) {
        return StringUtils.stripQuerySpecialChars(s, ' ');
    }

    public static String stripQuerySpecialChars(String s, char newChar) {
        char[] queryChars = new char[]{'+', '-', '(', ')', '[', ']', '*', '\"', '~', ':', '^', '?'};
        int i = 0;
        while (i < queryChars.length) {
            s = s.replace(queryChars[i], newChar);
            ++i;
        }
        return s;
    }
}

