/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.extension;

import com.wily.util.StringUtils;
import com.wily.util.extension.IJarFile;
import com.wily.util.extension.InMemoryJarClassLoader;
import com.wily.util.extension.InMemoryJarFile;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.io.ExtendedFile;
import com.wily.wilyassert.Assertion;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipInputStream;

final class JarURLPhysicalModule {
    private static final URL[] kZeroLengthURLArray = new URL[0];
    private final URL fTargetURL;
    private final String fParent;
    private final String fProtocol;
    private final Manifest fManifest;
    private final URL[] fClassPath;
    private final URL[] fClassPathIncludingSelf;
    private JarFile fJarFile;

    JarURLPhysicalModule(URL url) throws IOException, MalformedURLException {
        this.fProtocol = url.getProtocol();
        this.fTargetURL = JarURLPhysicalModule.getJarURL(url);
        this.fParent = JarURLPhysicalModule.getParentURLString(this.fTargetURL.toString());
        this.fManifest = this.findManifest();
        this.fClassPath = this.computeClassPath();
        this.fClassPathIncludingSelf = this.computeClassPathWithSelf();
    }

    final URL[] getClassPath() {
        return this.fClassPath;
    }

    final URL[] getClassPathIncludingSelf() {
        return this.fClassPathIncludingSelf;
    }

    final URL getURL() {
        return this.fTargetURL;
    }

    static ClassLoader getBundleClassLoaders(IModuleFeedbackChannel feedback, ClassLoader parentClassLoader, IJarFile jarFile) {
        String classPathString = jarFile.getMainAttributes().getValue("Bundle-ClassPath");
        if (!StringUtils.isEmpty(classPathString)) {
            InMemoryJarFile memFile = null;
            StringTokenizer tokenizer = new StringTokenizer(classPathString, ",");
            while (tokenizer.hasMoreTokens()) {
                String classpath = tokenizer.nextToken().trim();
                if (!classpath.endsWith(".jar")) continue;
                ZipInputStream jarStream = null;
                try {
                    jarStream = new JarInputStream(jarFile.getInputStream(classpath));
                    if (memFile == null) {
                        memFile = new InMemoryJarFile((JarInputStream)jarStream);
                    } else {
                        memFile.appendJarFile((JarInputStream)jarStream);
                    }
                }
                catch (IOException e) {
                    feedback.error(e.toString());
                    feedback.verbose(e);
                    if (jarStream == null) continue;
                    try {
                        jarStream.close();
                    }
                    catch (IOException e2) {
                        feedback.error(e2.toString());
                        feedback.debug(e2);
                    }
                    continue;
                }
                catch (ClassNotFoundException e) {
                    try {
                        feedback.error(e.toString());
                        feedback.verbose(e);
                        continue;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (jarStream != null) {
                            try {
                                jarStream.close();
                            }
                            catch (IOException e3) {
                                feedback.error(e3.toString());
                                feedback.debug(e3);
                            }
                        }
                    }
                }
                if (jarStream == null) continue;
                try {
                    jarStream.close();
                }
                catch (IOException e) {
                    feedback.error(e.toString());
                    feedback.debug(e);
                }
            }
            if (memFile != null) {
                return new InMemoryJarClassLoader(parentClassLoader, memFile);
            }
        }
        return parentClassLoader;
    }

    public String toString() {
        return this.getURL().toString();
    }

    public JarFile getJarFile() {
        return this.fJarFile;
    }

    private Manifest findManifest() throws IOException {
        JarURLConnection conn = (JarURLConnection)this.fTargetURL.openConnection();
        conn.connect();
        this.fJarFile = conn.getJarFile();
        Manifest manifest = conn.getManifest();
        if (manifest == null && (manifest = JarURLPhysicalModule.getManifestFromJarFile(conn.getJarFile())) == null) {
            throw new IOException("manifest not found");
        }
        Assertion.wilyAssert(manifest != null);
        return manifest;
    }

    public Manifest getManifest() {
        Assertion.wilyAssert(this.fManifest != null);
        return this.fManifest;
    }

    private URL[] computeClassPath() throws MalformedURLException {
        URL[] result;
        Manifest manifest = this.getManifest();
        Attributes mainAttributes = manifest.getMainAttributes();
        String classPathString = mainAttributes.getValue("Class-Path");
        if (classPathString == null) {
            result = kZeroLengthURLArray;
        } else {
            Collection urlBag = JarURLPhysicalModule.getStringClassPathElementsAsURLCollection(JarURLPhysicalModule.getStringTokensAsArray(classPathString, " "), this.fParent, this.fProtocol);
            result = urlBag.toArray(kZeroLengthURLArray);
        }
        return result;
    }

    private URL[] computeClassPathWithSelf() {
        ArrayList<URL> completeList = new ArrayList<URL>();
        completeList.add(this.getURL());
        List<URL> deepList = Arrays.asList(this.getClassPath());
        completeList.addAll(deepList);
        return completeList.toArray(kZeroLengthURLArray);
    }

    private static final Collection getStringClassPathElementsAsURLCollection(String[] paths, String parent, String protocol) throws MalformedURLException {
        ArrayList<URL> list = new ArrayList<URL>();
        int x = 0;
        int y = paths.length;
        while (x < y) {
            String path = paths[x];
            URL url = null;
            try {
                url = new URL(JarURLPhysicalModule.getJarURLString(path));
            }
            catch (MalformedURLException malformedURLException) {
                url = ExtendedFile.isAbsolutePath(path) ? new URL(JarURLPhysicalModule.getJarURLString(String.valueOf(protocol) + ":/" + path)) : new URL(JarURLPhysicalModule.getJarURLString(String.valueOf(parent) + "/" + path));
            }
            try {
                url.openConnection().getContentType();
                list.add(url);
            }
            catch (IOException iOException) {}
            ++x;
        }
        return list;
    }

    private static final Manifest getManifestFromJarFile(JarFile jar) throws IOException {
        Enumeration<JarEntry> e = jar.entries();
        JarEntry entry = null;
        while (e.hasMoreElements()) {
            entry = e.nextElement();
            if (!entry.getName().equalsIgnoreCase("META-INF/MANIFEST.MF")) continue;
            return new Manifest(jar.getInputStream(entry));
        }
        return null;
    }

    public static final String getParentURLString(String url) {
        url = url.substring(0, url.lastIndexOf(33));
        url = url.substring(0, url.lastIndexOf(47));
        return url;
    }

    public static final URL getJarURL(URL url) throws MalformedURLException {
        return new URL(JarURLPhysicalModule.getJarURLString(url.toString()));
    }

    public static final String getJarURLString(String urlString) {
        if (!urlString.startsWith("jar:")) {
            urlString = "jar:" + urlString;
        }
        if (urlString.indexOf(33) == -1) {
            urlString = String.valueOf(urlString) + "!/";
        }
        return urlString;
    }

    private static final String[] getStringTokensAsArray(String list, String token) {
        StringTokenizer strTok = new StringTokenizer(list, token);
        String[] array = new String[strTok.countTokens()];
        int x = 0;
        while (x < array.length) {
            array[x] = strTok.nextToken().trim();
            ++x;
        }
        return array;
    }

    public void close() throws IOException {
        this.fJarFile.close();
    }
}

