/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.properties.hot;

import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.hot.ConfigurationProperty;
import com.wily.util.text.IStringLocalizer;

public class EnumConfigurationProperty
extends ConfigurationProperty {
    public EnumConfigurationProperty(String name, Integer defaultValue, String[] validValues, IModuleFeedbackChannel feedback, Module module, IStringLocalizer localizer) {
        this(name, defaultValue, validValues, "Hot_Property_Configuration_Property", null, true, false, feedback, module, localizer);
    }

    public EnumConfigurationProperty(String name, Integer defaultValue, String[] validValues, String descriptionKey, IModuleFeedbackChannel feedback, Module module, IStringLocalizer localizer) {
        this(name, defaultValue, validValues, descriptionKey, null, true, false, feedback, module, localizer);
    }

    public EnumConfigurationProperty(String name, Integer defaultValue, String[] validValues, String descriptionKey, String unitsKey, boolean isHot, boolean isNullValid, IModuleFeedbackChannel feedback, Module module, IStringLocalizer localizer) {
        super(name, (Object)defaultValue, validValues, descriptionKey, unitsKey, isHot, isNullValid, feedback, module, localizer);
        if (validValues.length == 0) {
            throw new IllegalArgumentException("No valid values");
        }
        int dv = defaultValue;
        if (dv < 0 || dv >= validValues.length) {
            throw new IllegalArgumentException("Invalid default value (" + dv + ")");
        }
    }

    @Override
    public Object convert(String s) {
        String v = s.trim();
        String[] validValues = this.getValidValues();
        int i = 0;
        while (i < validValues.length) {
            if (v.equals(validValues[i])) {
                return i;
            }
            ++i;
        }
        StringBuilder validValuesList = new StringBuilder();
        String sep = "";
        int i2 = 0;
        while (i2 < validValues.length) {
            String vv = validValues[i2];
            validValuesList.append(sep);
            if (vv != null) {
                validValuesList.append("'");
            }
            validValuesList.append(vv);
            if (vv != null) {
                validValuesList.append("'");
            }
            sep = ", ";
            ++i2;
        }
        throw new IllegalArgumentException(this.getLocalizer().IStringLocalizer_getFormattedLocalizedString("Hot_Property_Unrecognized_Value", validValuesList.toString()));
    }

    @Override
    public String toString(Object v) {
        return this.toString(v == null ? null : this.getValidValues()[(Integer)v]);
    }
}

