/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.extension.deployer;

import com.wily.introscope.agent.extension.deployer.DeploymentLock;
import com.wily.introscope.agent.extension.deployer.DeploymentManager;
import com.wily.introscope.agent.extension.deployer.IDeploymentWatcher;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.io.ExtendedFile;
import java.io.File;
import java.io.FilenameFilter;
import java.util.HashMap;
import java.util.Map;

public class DeploymentWatcherJdk16
implements Runnable,
IDeploymentWatcher {
    private DeploymentManager fManager;
    private Module kModule;
    private IModuleFeedbackChannel fFeedback;
    private ExtendedFile fExtensionsDir;
    private ExtendedFile fDeploymentDir;
    private File fExtensionProfile;
    private long fProfileWatcherStamp = 0L;

    @Override
    public void start(DeploymentManager manager) {
        this.fManager = manager;
        this.kModule = this.fManager.getModule();
        this.fFeedback = this.fManager.getFeedback();
        this.fExtensionsDir = this.fManager.getExtensionDirectory();
        this.fDeploymentDir = this.fManager.getDeployDirectory();
        this.fExtensionProfile = new File(this.fManager.getExtensionProfileResource().IResource_getLocation());
        new File(this.fDeploymentDir.getAbsolutePath());
        new File(this.fExtensionsDir.getAbsolutePath());
        Thread t = new Thread((Runnable)this, "Deployment Watcher");
        t.setDaemon(true);
        t.start();
        Thread t2 = new Thread(new Runnable(){

            @Override
            public void run() {
                DeploymentWatcherJdk16.this.profileWatcherRun();
            }
        }, "Extension Profile Watcher");
        t2.setDaemon(true);
        t2.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void profileWatcherRun() {
        long timeStamp = this.fExtensionProfile.lastModified();
        long interval = this.fManager.getProfileCheckInterval();
        while (true) {
            if (timeStamp < this.fExtensionProfile.lastModified()) {
                DeploymentLock deploymentLock = this.fManager.getProfileLock();
                synchronized (deploymentLock) {
                    try {
                        this.fManager.getProfileLock().acquireSharedLock();
                        this.fFeedback.info(this.kModule, "Extensios.profile modified, notifying ConfgirationWatcher.");
                        this.fManager.notifyConfigurationWatcher();
                        timeStamp = this.fExtensionProfile.lastModified();
                    }
                    finally {
                        this.fManager.getProfileLock().releaseLock();
                    }
                }
            }
            try {
                Thread.sleep(interval);
                continue;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private HashMap<File, Long> buildTimeStampMap() {
        File[] files;
        HashMap<File, Long> map = new HashMap<File, Long>();
        FilenameFilter filterOnlyExtensions = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".tar.gz");
            }
        };
        File[] fileArray = files = this.fDeploymentDir.listFiles(filterOnlyExtensions);
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            map.put(f, f.lastModified());
            ++n2;
        }
        return map;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        long dirTimeStamp = this.fDeploymentDir.getFile().lastModified();
        long interval = this.fManager.getProfileCheckInterval();
        HashMap<File, Long> timeStampMap = this.buildTimeStampMap();
        try {
            Thread.sleep(15000L);
        }
        catch (InterruptedException interruptedException) {}
        try {
            while (true) {
                if (dirTimeStamp < this.fDeploymentDir.getFile().lastModified()) {
                    this.fFeedback.info(this.kModule, "Extensions deployment directory modified, notifying ConfgirationWatcher.");
                    this.fManager.checkFilesAndDeploy(false);
                    dirTimeStamp = this.fDeploymentDir.getFile().lastModified();
                    timeStampMap = this.buildTimeStampMap();
                }
                File fileModified = null;
                for (Map.Entry<File, Long> e : timeStampMap.entrySet()) {
                    if (e.getValue() >= e.getKey().lastModified()) continue;
                    fileModified = e.getKey();
                    break;
                }
                if (fileModified != null) {
                    this.fFeedback.info(this.kModule, "Extension file " + fileModified + " modified, notifying ConfgirationWatcher.");
                    this.fManager.checkFilesAndDeploy(false);
                    timeStampMap = this.buildTimeStampMap();
                }
                try {
                    Thread.sleep(interval);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                this.fFeedback.error(this.kModule, "Error occured in Extension Deployer, the feature is disabled: " + t.getMessage());
                if (!this.fFeedback.isDebugEnabled(this.kModule)) return;
                this.fFeedback.debug(this.kModule, "Extension Deployer Thread uncaught exception: ", t);
                return;
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
            return;
        }
    }
}

