/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.directives;

import com.wily.diagnos.cmp.classmatcher.DGGlobClassMatcher;
import com.wily.diagnos.cmp.directives.ADirective;
import com.wily.diagnos.cmp.directives.FlagName;
import com.wily.diagnos.cmp.directives.builder.CompilerSettingsBuilder;
import com.wily.diagnos.cmp.directives.builder.TracerGroupBuilder;
import com.wily.util.classfile.IClassSchemaPolicy;
import com.wily.util.classfile.IPackagePrefix;

public final class SkipNamespacePrefixForFlagDirective
extends ADirective {
    private final IPackagePrefix fNamespacePrefix;
    private final FlagName fFlagName;

    public SkipNamespacePrefixForFlagDirective(String source, int lineNumber, IPackagePrefix namespacePrefix, FlagName flagName) {
        super(source, lineNumber);
        this.fNamespacePrefix = namespacePrefix;
        this.fFlagName = flagName;
    }

    private IPackagePrefix getNamespacePrefix() {
        return this.fNamespacePrefix;
    }

    private FlagName getFlagName() {
        return this.fFlagName;
    }

    @Override
    protected void applyToSettings(CompilerSettingsBuilder builder) {
        TracerGroupBuilder flag = builder.getTracerGroupBuilder(this.getFlagName());
        String pattern = this.getNamespacePrefix() + "*";
        IClassSchemaPolicy policy = builder.getPersonality().getClassSchemaPolicy();
        DGGlobClassMatcher matcher = new DGGlobClassMatcher(pattern, policy);
        flag.skipInstrumentationInMatchingClasses(matcher);
        flag.setSource(this.getSource());
    }
}

