/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.transform;

import com.wily.diagnos.cmp.directives.DGCompilerSettings;
import com.wily.diagnos.cmp.directives.TracerGroup;
import com.wily.diagnos.cmp.directives.apply.ClassSettingsApplier;
import com.wily.diagnos.cmp.directives.builder.CompilerSettingsBuilder;
import com.wily.diagnos.cmp.log.ICompilerLog;
import com.wily.diagnos.cmp.mutate.IClassMutator;
import com.wily.diagnos.cmp.mutate.IMethodMutator;
import com.wily.diagnos.cmp.mutate.IMutation;
import com.wily.diagnos.cmp.transform.AClassAndEveryMethodTransformation;
import com.wily.diagnos.cmp.transform.ITracerGroupTransformation;
import com.wily.diagnos.cmp.transform.builder.ITransformationBuilder;
import com.wily.diagnos.cmp.transform.builder.SubstituteClassTransformationBuilder;
import com.wily.util.HashCodeUtils;
import com.wily.util.classfile.IClassName;
import com.wily.util.classfile.IModeledClass;
import com.wily.util.classfile.IModeledMethod;

public final class SubstituteClassTransformation
extends AClassAndEveryMethodTransformation
implements ITracerGroupTransformation {
    private final TracerGroup fTracerGroup;
    private final IClassName fSourceClass;
    private final IClassName fReplacementClass;

    public SubstituteClassTransformation(ICompilerLog log, IClassName sourceClass, IClassName replacementClass) {
        this(log, null, sourceClass, replacementClass);
    }

    public SubstituteClassTransformation(ICompilerLog log, TracerGroup tracerGroup, IClassName sourceClass, IClassName replacementClass) {
        super(log);
        this.fTracerGroup = tracerGroup;
        this.fSourceClass = sourceClass;
        this.fReplacementClass = replacementClass;
    }

    @Override
    public TracerGroup getTracerGroup() {
        return this.fTracerGroup;
    }

    public IClassName getSourceClass() {
        return this.fSourceClass;
    }

    public IClassName getReplacementClass() {
        return this.fReplacementClass;
    }

    private static boolean nullEquals(Object obj1, Object obj2) {
        return obj1 == null ? obj2 == null : obj1.equals(obj2);
    }

    public boolean equals(Object obj) {
        if (obj instanceof SubstituteClassTransformation) {
            SubstituteClassTransformation sct = (SubstituteClassTransformation)obj;
            return this.getSourceClass().equals(sct.getSourceClass()) && this.getReplacementClass().equals(sct.getReplacementClass()) && SubstituteClassTransformation.nullEquals(this.getTracerGroup(), sct.getTracerGroup());
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = HashCodeUtils.accumulateHashCode(result, this.getSourceClass());
        result = HashCodeUtils.accumulateHashCode(result, this.getReplacementClass());
        result = HashCodeUtils.accumulateHashCode(result, this.getTracerGroup());
        return result;
    }

    @Override
    public boolean isClassStructureAltering() {
        return true;
    }

    public String toString() {
        return "source Class = " + this.getSourceClass() + " replacement Class = " + this.getReplacementClass() + " tracer group = " + this.getTracerGroup();
    }

    private static boolean mutatedClassIsSourceClass(IModeledClass mutatedClass, IClassName sourceClass) {
        return mutatedClass.getClassName().equals(sourceClass);
    }

    @Override
    protected boolean doShouldProcessClass(DGCompilerSettings settings, IModeledClass targetClass) {
        return !ClassSettingsApplier.shouldSkipClassForTracerGroup(this.getLog(), targetClass, this.getTracerGroup()) && targetClass.referencesClass(this.getSourceClass()) && !SubstituteClassTransformation.mutatedClassIsSourceClass(targetClass, this.getSourceClass());
    }

    @Override
    protected boolean doShouldMutateClass(DGCompilerSettings settings, IModeledClass targetClass) {
        return true;
    }

    @Override
    protected IMutation doGenerateClassMutation(DGCompilerSettings settings, IClassMutator mutator, IModeledClass targetClass) {
        return mutator.newSubstituteSuperclassClassMutation(settings, targetClass, this);
    }

    @Override
    protected boolean doShouldMutateMethod(DGCompilerSettings settings, IModeledMethod targetMethod) {
        return targetMethod.hasBytecode();
    }

    @Override
    protected IMutation doGenerateMethodMutation(DGCompilerSettings settings, IMethodMutator mutator, IModeledMethod targetMethod) {
        return mutator.newSubstituteClassMethodMutation(settings, targetMethod, this);
    }

    @Override
    public ITransformationBuilder generateTransformationBuilder(CompilerSettingsBuilder builder) {
        return new SubstituteClassTransformationBuilder(builder.getTracerGroupBuilder(this.getTracerGroup()), this.getSourceClass(), this.getReplacementClass());
    }
}

