/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.bizrecording;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.bizrecording.BizRecordingAdministrator;
import com.wily.introscope.agent.bizrecording.BizRecordingServletTracerInstance;
import com.wily.introscope.agent.enterprise.EnterpriseAgent;
import com.wily.introscope.agent.trace.ATracerFactory;
import com.wily.introscope.agent.trace.ITracer;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.util.properties.AttributeListing;
import com.wily.wilyassert.Assertion;
import java.util.Map;

public class BizRecordingServletTracer
extends ATracerFactory {
    private final BizRecordingAdministrator fAdministrator = ((EnterpriseAgent)this.getAgent()).getBizRecordingAdministrator();
    private static final ThreadLocal fThreadLocalInstance = new ThreadLocal();

    public BizRecordingServletTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    @Override
    public int ITracerFactory_getVersion() {
        return 1;
    }

    @Override
    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    @Override
    public boolean ITracerFactory_isShutoff() {
        return this.fAdministrator == null || fThreadLocalInstance.get() != null;
    }

    @Override
    public ITracer ITracerFactory_allocateTracer(int tracerIndex, InvocationData data) {
        if (this.ITracerFactory_isShutoff()) {
            return null;
        }
        Map sessions = this.fAdministrator.getBizRecordingSessions();
        if (sessions.size() > 0) {
            BizRecordingServletTracerInstance instance = new BizRecordingServletTracerInstance(this.getAgent(), sessions);
            fThreadLocalInstance.set(instance);
            return instance;
        }
        return null;
    }

    @Override
    public void ITracerFactory_releaseTracer(int tracerIndex, ITracer tracer) {
        Assertion.wilyAssert(tracer == fThreadLocalInstance.get());
        fThreadLocalInstance.set(null);
    }
}

