/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.hc2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.hc2.VerifyAgingChildrenEditor;
import com.wily.introscope.agent.trace.hc2.WilyTransactionStructure;
import com.wily.util.adt.IGuaranteedCounter;
import com.wily.util.feedback.Module;
import com.wily.util.task.IExecutableItem;
import java.util.concurrent.atomic.AtomicReference;

class AElementCreationWatchdog {
    private static final Module kModule = new Module("AElementCreationWatchdog");
    static volatile int kAbsoluteCreationAttentionLevel = 100000;
    private final IGuaranteedCounter countNodesPartial;
    volatile int currentEstimateNumberofNodes;
    final IAgent fAgent;
    final AtomicReference fStartedForcedAging = new AtomicReference();
    final AtomicReference fStartedAging = new AtomicReference();
    WilyTransactionStructure fStructure;

    public AElementCreationWatchdog(IAgent agent, WilyTransactionStructure structure) {
        this.countNodesPartial = agent.IAgent_getGuaranteedCounter();
        this.fAgent = agent;
        this.fStructure = structure;
    }

    public AElementCreationWatchdog() {
        this.fAgent = null;
        this.countNodesPartial = new IGuaranteedCounter(){

            @Override
            public int next() {
                return 0;
            }

            @Override
            public void reset() {
            }

            @Override
            public IGuaranteedCounter getNewInstance() {
                return null;
            }

            @Override
            public int peek() {
                return 0;
            }

            @Override
            public int getAndSet(int i) {
                return 0;
            }

            @Override
            public int prev() {
                return 0;
            }
        };
    }

    public boolean checkAddedElement() {
        int nodesPartial = this.countNodesPartial.peek();
        boolean result = this.checkTransactionStructure(nodesPartial);
        if (result) {
            this.countNodesPartial.next();
            return true;
        }
        return false;
    }

    boolean checkTransactionStructure(int nodesPartial) {
        int currentEstimate = this.currentEstimateNumberofNodes + nodesPartial;
        if (currentEstimate * 3 > kAbsoluteCreationAttentionLevel && this.fStartedForcedAging.get() == null) {
            ExecuteNormalAgingOnAbsoluteCreationLevelHit item = new ExecuteNormalAgingOnAbsoluteCreationLevelHit();
            if (this.fStartedForcedAging.compareAndSet(null, item)) {
                this.fStructure.getTransactionStructureQueue().IExecutionQueue_addExecutableItem(item);
            }
            if (currentEstimate > kAbsoluteCreationAttentionLevel) {
                return false;
            }
        }
        return currentEstimate <= kAbsoluteCreationAttentionLevel;
    }

    public void resetPartialCount() {
        this.countNodesPartial.reset();
    }

    public void setTotalNumberOfNodesAsOfNow(int numberOfAliveElement) {
        this.currentEstimateNumberofNodes = numberOfAliveElement;
        this.resetPartialCount();
    }

    public int getApproximateSize() {
        return this.currentEstimateNumberofNodes;
    }

    public int getPartialNodesCreated() {
        return this.countNodesPartial.peek();
    }

    public boolean setIsExecutingAging(Object object) {
        return this.fStartedAging.compareAndSet(null, object);
    }

    public boolean isExecutingAging(Object object) {
        return this.fStartedAging.get() == object;
    }

    public boolean isAnyExecutingAging() {
        return this.fStartedAging.get() != null;
    }

    public void unsetIsExecutingAging(Object object) {
        this.fStartedAging.compareAndSet(object, null);
    }

    private final class ExecuteEmergencyAgingOnAbsoluteCreationLevelHit
    implements IExecutableItem {
        long[] counters;

        private ExecuteEmergencyAgingOnAbsoluteCreationLevelHit() {
        }

        @Override
        public boolean IExecutableItem_shouldStillExecute() {
            boolean shouldExecute = AElementCreationWatchdog.this.setIsExecutingAging(this);
            if (!shouldExecute) {
                AElementCreationWatchdog.this.fAgent.IAgent_getModuleFeedback().debug(WilyTransactionStructure.kWilyHarvestingModule, "Executing emergency aging on absolute creation of transaction nodes attention level reached not performed because " + AElementCreationWatchdog.this.fStartedAging.get() + " is already aging");
            }
            return shouldExecute;
        }

        @Override
        public void IExecutableItem_executionAborted() {
            AElementCreationWatchdog.this.fStartedForcedAging.set(null);
        }

        @Override
        public void IExecutableItem_execute() {
            try {
                System.currentTimeMillis();
                AElementCreationWatchdog.this.fAgent.IAgent_getModuleFeedback().debug(WilyTransactionStructure.kWilyHarvestingModule, "Executing Emergency aging on absolute creation of transaction nodes attention level reached");
                AElementCreationWatchdog.this.fStructure.ageAllImmediately();
                int elements = WilyTransactionStructure.countElements();
                AElementCreationWatchdog.this.setTotalNumberOfNodesAsOfNow(elements);
            }
            finally {
                AElementCreationWatchdog.this.unsetIsExecutingAging(this);
            }
        }
    }

    private final class ExecuteNormalAgingOnAbsoluteCreationLevelHit
    implements IExecutableItem {
        long[] counters;

        private ExecuteNormalAgingOnAbsoluteCreationLevelHit() {
        }

        @Override
        public boolean IExecutableItem_shouldStillExecute() {
            this.counters = AElementCreationWatchdog.this.fStructure.prepareTransactionStructureForAgingAndReturnCount();
            if (this.counters[0] * 3L > (long)kAbsoluteCreationAttentionLevel) {
                boolean shouldExecute = AElementCreationWatchdog.this.setIsExecutingAging(this);
                if (!shouldExecute) {
                    AElementCreationWatchdog.this.fAgent.IAgent_getModuleFeedback().debug(WilyTransactionStructure.kWilyHarvestingModule, "Executing aging on absolute creation of transaction nodes attention level reached not performed because " + AElementCreationWatchdog.this.fStartedAging.get() + " is already aging");
                }
                return shouldExecute;
            }
            return false;
        }

        @Override
        public void IExecutableItem_executionAborted() {
            AElementCreationWatchdog.this.fStartedForcedAging.set(null);
        }

        @Override
        public void IExecutableItem_execute() {
            ExecuteEmergencyAgingOnAbsoluteCreationLevelHit emergencyAging = null;
            try {
                long now = System.currentTimeMillis();
                long cutOff = now - this.counters[1];
                VerifyAgingChildrenEditor editor = new VerifyAgingChildrenEditor(AElementCreationWatchdog.this.fAgent.IAgent_getModuleFeedback(), now, cutOff, 0);
                AElementCreationWatchdog.this.fAgent.IAgent_getModuleFeedback().debug(WilyTransactionStructure.kWilyHarvestingModule, "Executing aging on absolute creation of transaction nodes attention level reached");
                if (AElementCreationWatchdog.this.fStructure.executeAging(AElementCreationWatchdog.this.fStructure.getRoot(), editor)) {
                    emergencyAging = new ExecuteEmergencyAgingOnAbsoluteCreationLevelHit();
                }
                int elements = WilyTransactionStructure.countElements();
                AElementCreationWatchdog.this.setTotalNumberOfNodesAsOfNow(elements);
            }
            catch (Throwable throwable) {
                AElementCreationWatchdog.this.fStartedForcedAging.set(null);
                AElementCreationWatchdog.this.unsetIsExecutingAging(this);
                if (emergencyAging != null) {
                    try {
                        AElementCreationWatchdog.this.fStructure.getTransactionStructureQueue().IExecutionQueue_addExecutableItem(emergencyAging);
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            AElementCreationWatchdog.this.fStartedForcedAging.set(null);
            AElementCreationWatchdog.this.unsetIsExecutingAging(this);
            if (emergencyAging != null) {
                try {
                    AElementCreationWatchdog.this.fStructure.getTransactionStructureQueue().IExecutionQueue_addExecutableItem(emergencyAging);
                }
                catch (Exception exception) {}
            }
        }
    }
}

