/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.autoprobe.loading;

import com.wily.diagnos.cmp.directives.DirectivesException;
import com.wily.diagnos.cmp.directives.DirectivesFileList;
import com.wily.diagnos.cmp.directives.parser.DGParserException;
import com.wily.diagnos.personality.ICompilerPersonality;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.autoprobe.loading.IDirectiveLoader;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.resource.IResourceReader;
import com.wily.util.resource.InvalidResourceException;
import com.wily.util.text.IStringLocalizer;
import java.io.FileNotFoundException;
import java.io.IOException;

public abstract class ADirectiveLoader
implements IDirectiveLoader {
    private IModuleFeedbackChannel feedback;
    private IStringLocalizer localizer;
    private IResourceReader resourceReader;
    private volatile String[] directiveFiles;
    private ICompilerPersonality personality;
    private String path;
    protected static final int kSignedJARPrecedence = 2;
    protected static final int kBasicPrecedence = 3;
    protected static final int kUnifiedPrecedence = 1;

    protected ADirectiveLoader() {
    }

    protected ADirectiveLoader(IAgent agent, IStringLocalizer localizer, IResourceReader resourceReader, String path, String[] directivesFiles, ICompilerPersonality personality) {
        this.feedback = agent.IAgent_getModuleFeedback();
        this.localizer = localizer;
        this.resourceReader = resourceReader;
        this.path = path;
        this.directiveFiles = directivesFiles;
        this.personality = personality;
    }

    protected IModuleFeedbackChannel getFeedback() {
        return this.feedback;
    }

    protected IStringLocalizer getLocalizer() {
        return this.localizer;
    }

    protected IResourceReader getResourceReader() {
        return this.resourceReader;
    }

    protected String getPath() {
        return this.path;
    }

    protected ICompilerPersonality getPersonality() {
        return this.personality;
    }

    protected boolean hasDirectiveFiles() {
        return this.directiveFiles != null && this.directiveFiles.length > 0;
    }

    @Override
    public String[] getDirectiveFiles() {
        return this.directiveFiles;
    }

    @Override
    public void updateDirectiveFiles(String[] newFiles) {
        this.directiveFiles = newFiles;
    }

    @Override
    public abstract void loadDirectives(DirectivesFileList var1) throws InvalidResourceException, DirectivesException, FileNotFoundException, IOException, DGParserException;

    @Override
    public abstract int getPrecedence();

    public boolean containsFile(String name) {
        boolean result = false;
        String[] directiveFiles = this.getDirectiveFiles();
        if (directiveFiles != null && name != null) {
            int i = 0;
            while (i < directiveFiles.length && !result) {
                if (name.equals(directiveFiles[i])) {
                    result = true;
                }
                ++i;
            }
        }
        return result;
    }
}

