/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.probebuilder.extension.instrument.intelligent;

import com.wily.agent.main.DesperationIntelligentTracerHelper;
import com.wily.agent.main.DesperationTracer;
import com.wily.agent.main.IIntelligentInstrumentationTracerHelper;
import com.wily.agent.main.IntelligentInstrumentationShim;
import com.wily.diagnos.cmp.directives.AnalysedClassesMapInitializer;
import com.wily.diagnos.cmp.directives.apply.ClassSettingsApplier;
import com.wily.diagnos.personality.java.classfile.DGClass;
import com.wily.diagnos.personality.java.classfile.DGMethod;
import com.wily.diagnos.personality.java.tracer.DGIntelligentInstrumentationStreamMethodTracerInstance;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.connection.ConnectedServer;
import com.wily.introscope.agent.connection.IsengardServerConnectionManager;
import com.wily.introscope.agent.intelligent.entrypoint.EntryPointPersistenceService;
import com.wily.introscope.agent.intelligent.entrypoint.Logger;
import com.wily.introscope.agent.service.ASimpleService;
import com.wily.introscope.agent.trace.IIntelligentInstrumentationService;
import com.wily.introscope.agent.trace.IMethodTracer;
import com.wily.introscope.agent.trace.IParameterizedMethodTracer;
import com.wily.introscope.agent.trace.IWallClockDelegate;
import com.wily.introscope.agent.trace.TracerEncoding;
import com.wily.introscope.agent.trace.intelligent.AutoTracingHelper;
import com.wily.introscope.agent.trace.intelligent.CrossProcessAutoTracingConfiguration;
import com.wily.introscope.agent.trace.intelligent.CrossProcessLogger;
import com.wily.introscope.agent.trace.intelligent.DeepTraceConfigurations;
import com.wily.introscope.agent.trace.intelligent.DownStreamListenerExecutor;
import com.wily.introscope.agent.trace.intelligent.DownStreamListenerService;
import com.wily.introscope.agent.trace.intelligent.HighPerformanceIntelligenceStackElement;
import com.wily.introscope.agent.trace.intelligent.HighPerformanceTransactionCache;
import com.wily.introscope.agent.trace.intelligent.IInstrumentationLevelChangeStatusManager;
import com.wily.introscope.agent.trace.intelligent.IntelligentTransactionHarvesterHelper;
import com.wily.introscope.agent.trace.intelligent.SustainabilityMetricsHelper;
import com.wily.introscope.agent.trace.intelligent.frontend.FrontEndCandidateAnalyzer;
import com.wily.introscope.agent.trace.intelligent.frontend.FrontendCandidate;
import com.wily.introscope.agent.transactiontrace.SharedCrossProcessData;
import com.wily.introscope.agent.transformer.TransformerAdministrator;
import com.wily.introscope.agent.transformer.dynamic.IClassRedefinitionDelegate;
import com.wily.introscope.agent.transformer.dynamic.ITracerProviderService;
import com.wily.introscope.agent.util.ByteClassUtil;
import com.wily.introscope.autoprobe.AutoProbeTransformer;
import com.wily.introscope.autoprobe.IAutoProbeConfig;
import com.wily.introscope.probebuilder.intelligent.analysis.AutoInstrumentationWorker;
import com.wily.introscope.probebuilder.intelligent.instrumentation.InstrumentationLevelStatusManager;
import com.wily.introscope.probebuilder.intelligent.instrumentation.IntelligentInstrumentationConfig;
import com.wily.introscope.probebuilder.intelligent.instrumentation.LevelChangeChecker;
import com.wily.introscope.spec.agent.beans.autotracing.IAutoTracingTrigger;
import com.wily.util.classfile.IModeledClass;
import com.wily.util.classfile.IModeledMethod;
import com.wily.util.classfile.InvalidMethodDescriptorException;
import com.wily.util.classfile.InvalidMethodNameException;
import com.wily.util.classfile.java.MethodName;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.properties.hot.ConfigurationManager;
import com.wily.util.properties.hot.ConfigurationProperty;
import com.wily.util.properties.hot.IntegerConfigurationProperty;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class IntelligentInstrumentationService
extends ASimpleService
implements IIntelligentInstrumentationTracerHelper,
IIntelligentInstrumentationService {
    private volatile IAgent kAgent;
    public static final DesperationIntelligentTracerHelper kDesperationHelper = new DesperationIntelligentTracerHelper();
    static final Module kModule = new Module("IntelligentInstrumentationService");
    private static int flags = 0;
    public static final String kIntelligentInstrumentationThreadCountProperty = "introscope.agent.deep.instrumentation.num.threads";
    private static final int kDefaultThreadCount = 100;
    private static volatile int sStartDelay = 10000;
    private static int metricPollingDelay = 15000;
    private ConcurrentHashMap<Integer, FrontendCandidate.FrontEndCandidateState> fBlackListedMethods = new ConcurrentHashMap();
    private ScheduledExecutorService executor;
    private AutoInstrumentationWorker fInstrumentationWorker;

    public IntelligentInstrumentationService() {
        this("Intelligent Service");
    }

    public IntelligentInstrumentationService(String name) {
        super(name);
    }

    protected void doStartService(IAgent agent, Map parameters) throws Exception {
        this.kAgent = agent;
        if (this.shouldStartService(agent)) {
            agent.IAgent_getCommonHeartbeat().addBehavior((ITimestampedRunnable)new EnableIntelligentInstrumentation(agent, kModule, this), "IntelligentInstrumentationService", true, (long)sStartDelay, false, 1);
            ConfigurationManager cm = this.kAgent.IAgent_getConfigurationManager();
            IntelligentInstrumentationThreadCountProperty threadCount = new IntelligentInstrumentationThreadCountProperty(agent);
            cm.add((ConfigurationProperty)threadCount, true);
            IAutoProbeConfig apc = (IAutoProbeConfig)agent.IAgent_getTransformerAdministrator().getDynamicInstrumentationTransformer();
            if (apc != null) {
                apc.setIntelligentInstrumentationService((IIntelligentInstrumentationService)this);
            }
            CrossProcessAutoTracingConfiguration.init((IAgent)agent);
            agent.IAgent_getTracerAdministrator().setIntelligentInstrumentationService((IIntelligentInstrumentationTracerHelper)this);
            DeepTraceConfigurations.init((IAgent)agent);
            HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack.getThreadLocal();
            HighPerformanceTransactionCache.setInstance((HighPerformanceTransactionCache)new HighPerformanceTransactionCache(agent));
            DownStreamListenerExecutor.startExecutor((IAgent)agent);
            HighPerformanceTransactionCache.setDownStreamListenerWorker((DownStreamListenerService)DownStreamListenerExecutor.getDownStreamListenerWorker());
            DownStreamListenerExecutor.scheduleDownstreamListenerExecutor();
            if (!AutoTracingHelper.sAutoTracingEnabled && CrossProcessAutoTracingConfiguration.isCrossProcessAutoTracingEnabled()) {
                CrossProcessLogger.logWarnMessage((String)"Cross Process AutoTracing will be disabled because Automatic tracing is turned off. Please enable the property introscope.agent.deep.automatic.trace.enabled from the profile.");
            }
            if (IntelligentInstrumentationConfig.INSTANCE.isConfigInitialized()) {
                this.startMetricsReporting();
            }
            this.addAutoTraceCrossProcessCallback();
        }
    }

    private void addAutoTraceCrossProcessCallback() {
        SharedCrossProcessData.addCrossProcessDataCallback((SharedCrossProcessData.ICrossProcessDataCallBack)new SharedCrossProcessData.ICrossProcessDataCallBack(){

            public void prepareOptionalParameters(SharedCrossProcessData data) {
                this.copyAutoTraceStatus(data);
            }

            private void copyAutoTraceStatus(SharedCrossProcessData data) {
                String appIn = data.getStringParamIn("IsAutoTraced");
                if (appIn != null) {
                    data.addParamOut("IsAutoTraced", appIn);
                }
            }
        });
    }

    private void startMetricsReporting() {
        this.kAgent.IAgent_getCommonHeartbeat().addBehavior(new ITimestampedRunnable(){

            public void ITimestampedRunnable_execute(long nowInMillis) {
                if (SustainabilityMetricsHelper.sIsSustainabilityEnabled) {
                    SustainabilityMetricsHelper.reportDeepInstrumentationMetrics((int)ClassSettingsApplier.fInstrumentedMethodsCount.get(), (int)ClassSettingsApplier.getTotalNumberOfAnalyzedMethods(), (int)DGIntelligentInstrumentationStreamMethodTracerInstance.kAllIntelligentProbeInfo.size(), (int)ClassSettingsApplier.analysedMapSize.get(), (int)(LevelChangeChecker.getCurrentInstrumentationLevelAfterProcessingStarted() + 1), (long)ClassSettingsApplier.numClassesProcessed.longValue());
                    ClassSettingsApplier.numClassesProcessed.getAndSet(0L);
                }
            }
        }, "IntelligentInstrumentationSustainabilityService", true, (long)metricPollingDelay, false);
    }

    public IMethodTracer getIntelligentInstrumentationTracerForIntelligentShim(int probeHashCode, String probeClassName, String probeMethodName, String probeMethodDescriptor) {
        DesperationTracer t;
        block3: {
            t = DesperationIntelligentTracerHelper.kDesperationTracer;
            try {
                if (DeepTraceConfigurations.fDeepTracingEnabled) {
                    t = HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack.getThreadLocalTracerInstance((int)probeHashCode);
                }
            }
            catch (Throwable tt) {
                if (this.kAgent == null) break block3;
                this.kAgent.IAgent_getModuleFeedback().error(tt.toString(), tt);
            }
        }
        return t;
    }

    public final IMethodTracer getIntelligentInstrumentationTracerForIntelligentShim(int probeHashCode) {
        block3: {
            try {
                if (DeepTraceConfigurations.fDeepTracingEnabled) {
                    IMethodTracer result = HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack.getThreadLocalTracerInstance((int)probeHashCode);
                    result.IMethodTracer_startTrace();
                    return result;
                }
            }
            catch (Throwable tt) {
                if (this.kAgent == null) break block3;
                this.kAgent.IAgent_getModuleFeedback().error(tt.toString(), tt);
            }
        }
        return DesperationIntelligentTracerHelper.kDesperationTracer;
    }

    public final IMethodTracer getIntelligentInstrumentationTracerForIntelligentShim(int probeHashCode, IWallClockDelegate clock) {
        block3: {
            try {
                if (DeepTraceConfigurations.fDeepTracingEnabled) {
                    IMethodTracer result = HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack.getThreadLocalTracerInstance((int)probeHashCode, (IWallClockDelegate)clock);
                    result.IMethodTracer_startTrace();
                    return result;
                }
            }
            catch (Throwable tt) {
                if (this.kAgent == null) break block3;
                this.kAgent.IAgent_getModuleFeedback().error(tt.toString(), tt);
            }
        }
        return DesperationIntelligentTracerHelper.kDesperationTracer;
    }

    public IMethodTracer getIntelligentInstrumentationTracer(IMethodTracer invocationData) {
        DesperationTracer result = DesperationIntelligentTracerHelper.kDesperationTracer;
        if (DeepTraceConfigurations.fDeepTracingEnabled) {
            result = HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack.getThreadLocalTracerInstance((IMethodTracer)invocationData);
        }
        return result;
    }

    public IMethodTracer getIntelligentInstrumentationTracer(int probeHashCode, String probeClassName, String probeMethodName, String probeMethodDescriptor, Object tracedObject, String tracerEncoding, boolean fromAgentShim, IParameterizedMethodTracer invocationData) {
        return null;
    }

    private boolean shouldStartService(IAgent agent) {
        if (agent.IAgent_getComponentTracer().isAgentOldMode()) {
            if (agent.IAgent_getModuleFeedback().isWarningEnabled(kModule)) {
                agent.IAgent_getModuleFeedback().warn("Intelligent instrumentation is turned off due to use of old agent configuration.");
            }
            return false;
        }
        if (!agent.IAgent_getIndexedProperties().getBooleanProperty("introscope.autoprobe.enable", false)) {
            if (agent.IAgent_getModuleFeedback().isWarningEnabled(kModule)) {
                agent.IAgent_getModuleFeedback().warn("Intelligent instrumentation is turned off because Introscope AutoProbe has been disabled.");
            }
            return false;
        }
        return agent.IAgent_getIndexedProperties().getBooleanProperty("introscope.agent.deep.instrumentation.enabled", true);
    }

    public String[] getIntelligentInstrumentationInfoForSequentialHashCode(int value) {
        if (value < 0 || value >= DGIntelligentInstrumentationStreamMethodTracerInstance.kAllIntelligentProbeInfo.size()) {
            return null;
        }
        return DGIntelligentInstrumentationStreamMethodTracerInstance.kAllIntelligentProbeInfo.get(value);
    }

    public String getMethodState(int probeIndex) {
        return DGIntelligentInstrumentationStreamMethodTracerInstance.getMethodState(probeIndex);
    }

    public int getDeepInstrumentationId(String probeClassName, String name, String descriptor, String parameter) {
        return DGIntelligentInstrumentationStreamMethodTracerInstance.getDeepInstrumentationId(probeClassName, name, descriptor, parameter);
    }

    public void resetDeepInstrumentationParameter() {
        DGIntelligentInstrumentationStreamMethodTracerInstance.resetDeepInstrumentationParameter();
    }

    public boolean isMethodTraced(IModeledClass cls, IModeledMethod m) {
        String className = cls.getClassName().getPackageAndNameString().replace('/', '.');
        String methodName = m.getMethodName().getNameString();
        String descriptor = m.getSignature().toString();
        return DGIntelligentInstrumentationStreamMethodTracerInstance.isMethodTraced(className, methodName, descriptor);
    }

    public boolean isMethodInstrumented(String classname, String methodname, String methodDescriptor) {
        return DGIntelligentInstrumentationStreamMethodTracerInstance.isMethodTraced(classname, methodname, methodDescriptor);
    }

    public short[] getMethodMetadata(String classname, String methodname, String methodDescriptor) {
        return AnalysedClassesMapInitializer.getMethodMetadata((String)classname, (String)methodname, (String)methodDescriptor);
    }

    public List<short[]> getMatchingMethodMetadata(String className, String methodName) {
        ArrayList methods = this.getMatchingMethods(className, methodName, this.getAllClassesInVm());
        if (methods.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<short[]> metas = new ArrayList<short[]>(methods.size());
        int i = 0;
        while (i < methods.size()) {
            Method m = (Method)methods.get(i);
            try {
                MethodName mname = MethodName.getMethodName((Method)m, (boolean)true);
                String descriptor = mname.getMethodDescriptor().toString();
                short[] meta = this.getMethodMetadata(className, methodName, descriptor);
                if (meta != null) {
                    metas.add(meta);
                }
            }
            catch (InvalidMethodDescriptorException e) {
                Logger.logException((Exception)((Object)e));
            }
            catch (InvalidMethodNameException e) {
                Logger.logException((Exception)((Object)e));
            }
            ++i;
        }
        return metas;
    }

    public void updateMethodScoreAndState(String classname, String methodname, String methodDescriptor, short methodScore, short methodState) {
        AnalysedClassesMapInitializer.updateMethodScoreAndState((String)classname, (String)methodname, (String)methodDescriptor, (short)methodScore, (short)methodState);
    }

    public void markMethodAsFrontendCandidate(int probeInfo, String state) {
        DGIntelligentInstrumentationStreamMethodTracerInstance.setMethodState(probeInfo, state);
    }

    public void markMethodAsPseudoFrontendAndPersist(int fProbeArrayIndex, String state) {
        if (DGIntelligentInstrumentationStreamMethodTracerInstance.setMethodState(fProbeArrayIndex, state)) {
            EntryPointPersistenceService.getInstance().persistTracing(fProbeArrayIndex);
        }
    }

    public boolean setEntryPointStateForMethod(int probeInfoIndex, String state) {
        boolean replaced = DGIntelligentInstrumentationStreamMethodTracerInstance.setMethodState(probeInfoIndex, state);
        if (state.equals(FrontendCandidate.FrontEndCandidateState.REJECTED.toString())) {
            String[] methodData = this.getIntelligentInstrumentationInfoForSequentialHashCode(probeInfoIndex);
            this.fBlackListedMethods.putIfAbsent(this.getKey(methodData[0], methodData[1]), FrontendCandidate.FrontEndCandidateState.REJECTED);
        }
        return replaced;
    }

    public boolean setEntryPointStateForMethod(String className, String methodName, String methodDescriptor, String state) {
        short[] arr = AnalysedClassesMapInitializer.getMethodMetadata((String)className, (String)methodName, (String)methodDescriptor);
        if (arr != null) {
            return this.setEntryPointStateForMethod(arr[1], state);
        }
        return false;
    }

    public void removeBadPseudoFrontend(String className, String methodName, String methodDescriptor) {
        if (!this.isMethodInRejectedState(className, methodName) && this.setEntryPointStateForMethod(className, methodName, methodDescriptor, FrontendCandidate.FrontEndCandidateState.REJECTED.toString())) {
            EntryPointPersistenceService.getInstance().persistSkip(className, methodName, methodDescriptor);
            SustainabilityMetricsHelper.reportBlacklistedEntryPoint();
        }
    }

    public boolean isMethodInState(String classname, String methodname, String state) {
        if (state.equals(FrontendCandidate.FrontEndCandidateState.REJECTED.toString())) {
            return this.isMethodInRejectedState(classname, methodname);
        }
        boolean retVal = false;
        ArrayList methods = this.getMatchingMethods(classname, methodname, this.getAllClassesInVm());
        int i = 0;
        while (i < methods.size()) {
            Method m = (Method)methods.get(i);
            try {
                String[] probeInfo;
                MethodName mname = MethodName.getMethodName((Method)m, (boolean)true);
                String descriptor = mname.getMethodDescriptor().toString();
                short[] meta = this.getMethodMetadata(classname, methodname, descriptor);
                if (meta != null && (probeInfo = this.getIntelligentInstrumentationInfoForSequentialHashCode(meta[1])) != null && state.equals(probeInfo[6])) {
                    retVal = true;
                    break;
                }
            }
            catch (InvalidMethodDescriptorException e) {
                Logger.logException((Exception)((Object)e));
            }
            catch (InvalidMethodNameException e) {
                Logger.logException((Exception)((Object)e));
            }
            ++i;
        }
        return retVal;
    }

    public boolean setMethodState(String classname, String methodname, String state) {
        boolean updated = false;
        for (String[] probeInfo : this.getMatchingProbeInfo(classname, methodname)) {
            probeInfo[6] = state;
            updated = true;
        }
        return updated;
    }

    public List<String[]> getMatchingProbeInfo(String className, String methodName) {
        List<short[]> metas = this.getMatchingMethodMetadata(className, methodName);
        if (metas.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<String[]> probes = new ArrayList<String[]>(metas.size());
        for (short[] meta : metas) {
            String[] probeInfo = this.getIntelligentInstrumentationInfoForSequentialHashCode(meta[1]);
            if (probeInfo == null) continue;
            probes.add(probeInfo);
        }
        return probes;
    }

    private boolean isMethodInRejectedState(String classname, String methodname) {
        return this.fBlackListedMethods.containsKey(this.getKey(classname, methodname));
    }

    private Integer getKey(String classname, String methodname) {
        Object[] classNmethod = new String[]{classname, methodname};
        return Arrays.hashCode(classNmethod);
    }

    public Class[] getAllClassesInVm() {
        TransformerAdministrator tAdm = this.kAgent.IAgent_getTransformerAdministrator();
        AutoProbeTransformer dit = (AutoProbeTransformer)tAdm.getDynamicInstrumentationTransformer();
        IClassRedefinitionDelegate.IRedefinedClassRepository rep = dit.getClasses();
        return rep.getAllClassInVM();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean areMatchingMethodsTraced(String classToFind, String methodName, Class[] allClassesInVm) {
        ITracerProviderService fTracerProvider = this.kAgent.IAgent_getTransformerAdministrator().getDynamicInstrumentationTransformer().getTracerProviderService();
        Class clazz = null;
        boolean bFound = false;
        byte[] classBytes = null;
        int i = 0;
        while (i < allClassesInVm.length) {
            clazz = allClassesInVm[i];
            String name = clazz.getName();
            if (classToFind.equals(name)) {
                bFound = true;
                break;
            }
            ++i;
        }
        if (!bFound) return false;
        try {
            TracerEncoding te;
            DGMethod m;
            classBytes = ByteClassUtil.getBytesForClass((Class)clazz, (int)Integer.MAX_VALUE, (IModuleFeedbackChannel)this.kAgent.IAgent_getModuleFeedback());
            if (classBytes == null) return false;
            ByteArrayInputStream input = new ByteArrayInputStream(classBytes);
            DGClass modeledClass = new DGClass((InputStream)input);
            Iterator ii = modeledClass.getAllDeclaredMethods();
            do {
                if (ii.hasNext()) continue;
                return false;
            } while (!(m = (DGMethod)ii.next()).getMethodName().getNameString().equals(methodName) || (te = fTracerProvider.getTracerEncoding((IModeledMethod)m)) == null || te.getEncoding() == null);
            return true;
        }
        catch (Exception e) {
            Logger.logDebugMessage((String)"Exception while getting matching classes", (Throwable)e);
        }
        return false;
    }

    public ArrayList getMatchingMethods(String classToFind, String methodName, Class[] allClassesInVm) {
        ArrayList<Method> list = new ArrayList<Method>();
        if (allClassesInVm == null) {
            return list;
        }
        if (this.kAgent.IAgent_getModuleFeedback().isDebugEnabled(kModule)) {
            this.kAgent.IAgent_getModuleFeedback().debug(kModule, "Finding Matching Methods in VM :" + classToFind + ":" + methodName);
        }
        Class clazz = null;
        boolean bFound = false;
        int i = 0;
        while (i < allClassesInVm.length) {
            clazz = allClassesInVm[i];
            String name = clazz.getName();
            if (classToFind.equals(name)) {
                bFound = true;
                break;
            }
            ++i;
        }
        if (bFound) {
            Method[] methods = clazz.getDeclaredMethods();
            int j = 0;
            while (j < methods.length) {
                if (methods[j].getName().equals(methodName)) {
                    list.add(methods[j]);
                }
                ++j;
            }
        }
        if (this.kAgent.IAgent_getModuleFeedback().isDebugEnabled(kModule)) {
            this.kAgent.IAgent_getModuleFeedback().debug(kModule, "Matching Methods count :" + list.size());
        }
        return list;
    }

    public void scheduleRedefinition(ArrayList redefineList) {
        if (this.fInstrumentationWorker == null) {
            this.startExecutor();
        }
        this.scheduleExecutor(redefineList);
    }

    public void startExecutor() {
        this.executor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = Executors.defaultThreadFactory().newThread(r);
                thread.setDaemon(true);
                return thread;
            }
        });
        this.fInstrumentationWorker = new AutoInstrumentationWorker(this.kAgent, kModule, this.executor, AutoInstrumentationWorker.WorkerType.AUTOFRONTEND);
    }

    public void scheduleExecutor(ArrayList redefineList) {
        this.fInstrumentationWorker.setClassesToRedefine(redefineList);
        this.executor.schedule(this.fInstrumentationWorker, 0L, TimeUnit.SECONDS);
    }

    public boolean setAutoTracingTriggers(IAutoTracingTrigger[] triggers, String metricPrefix) {
        boolean result;
        if (this.kAgent.IAgent_getModuleFeedback().isDebugEnabled(kModule)) {
            this.kAgent.IAgent_getModuleFeedback().debug(kModule, "Setting auto tracing triggers.");
            if (this.kAgent.IAgent_getModuleFeedback().isTraceEnabled(kModule)) {
                int i = 0;
                while (i < triggers.length) {
                    this.kAgent.IAgent_getModuleFeedback().trace(kModule, "[" + i + "]: " + triggers[i]);
                    ++i;
                }
            }
        }
        if (!(result = AutoTracingHelper.setAutoTracingTriggers((IAutoTracingTrigger[])triggers, (String)metricPrefix)) && this.kAgent.IAgent_getModuleFeedback().isDebugEnabled(kModule)) {
            this.kAgent.IAgent_getModuleFeedback().debug(kModule, "Failed to set auto tracing triggers.");
        }
        return result;
    }

    public boolean clearAutoTracingTriggers(IAutoTracingTrigger[] triggers, String metricPrefix) {
        boolean result;
        if (this.kAgent.IAgent_getModuleFeedback().isDebugEnabled(kModule)) {
            this.kAgent.IAgent_getModuleFeedback().debug(kModule, "Clearing auto tracing triggers.");
            if (this.kAgent.IAgent_getModuleFeedback().isTraceEnabled(kModule)) {
                int i = 0;
                while (i < triggers.length) {
                    this.kAgent.IAgent_getModuleFeedback().trace(kModule, "[" + i + "]: " + triggers[i]);
                    ++i;
                }
            }
        }
        if (!(result = AutoTracingHelper.clearAutoTracingTriggers((IAutoTracingTrigger[])triggers, (String)metricPrefix)) && this.kAgent.IAgent_getModuleFeedback().isDebugEnabled(kModule)) {
            this.kAgent.IAgent_getModuleFeedback().debug(kModule, "Failed to clear auto tracing triggers.");
        }
        return result;
    }

    public boolean clearAllAutoTracingTriggers() {
        if (this.kAgent.IAgent_getModuleFeedback().isDebugEnabled(kModule)) {
            this.kAgent.IAgent_getModuleFeedback().debug(kModule, "Clearing all auto tracing triggers.");
        }
        return AutoTracingHelper.clearAllAutoTracingTriggers();
    }

    public static synchronized void setBitMask(int mask) {
        flags |= mask;
    }

    public static synchronized void clearBitMask(int mask) {
        flags &= ~mask;
    }

    public static synchronized boolean isMaskSet(int mask) {
        return (flags & mask) != 0;
    }

    public static synchronized int currentFlagValue() {
        return flags;
    }

    private static class EnableIntelligentInstrumentation
    implements ITimestampedRunnable {
        private IntelligentInstrumentationService svc;
        private IAgent fAgent;
        Module fModule;

        public EnableIntelligentInstrumentation(IAgent agent, Module kmodule, IntelligentInstrumentationService s) {
            this.fAgent = agent;
            this.fModule = kmodule;
            this.svc = s;
        }

        public void ITimestampedRunnable_execute(long nowInMillis) {
            if (!this.isConnectedToEM()) {
                this.fAgent.IAgent_getCommonHeartbeat().addBehavior((ITimestampedRunnable)this, "IntelligentInstrumentationService", true, (long)sStartDelay, false, 1);
                return;
            }
            IntelligentInstrumentationShim.getInstance().setHelper((IIntelligentInstrumentationTracerHelper)this.svc);
            this.fAgent.IAgent_getModuleFeedback().info(kModule, "Intelligent Instrumentation Service activated");
            try {
                IntelligentInstrumentationConfig.INSTANCE.initLevelChangeExecutor();
                IntelligentInstrumentationConfig.INSTANCE.initVisibilityGapProcessor(this.fAgent, kModule);
                IntelligentTransactionHarvesterHelper.setInstrumentationLevelChangeStatusManager((IInstrumentationLevelChangeStatusManager)new InstrumentationLevelStatusManager());
            }
            catch (Exception e) {
                this.fAgent.IAgent_getModuleFeedback().debug(kModule, e.getMessage());
            }
            FrontEndCandidateAnalyzer.initialize((IAgent)this.fAgent);
        }

        private boolean isConnectedToEM() {
            ConnectedServer svr;
            IsengardServerConnectionManager iscm = this.fAgent.IAgent_getIsengardServerConnection();
            return iscm != null && (svr = iscm.getConnectedServer()) != null && svr.isConnected();
        }
    }

    private static final class IntelligentInstrumentationThreadCountProperty
    extends IntegerConfigurationProperty {
        volatile int value;

        IntelligentInstrumentationThreadCountProperty(IAgent agent) {
            super(IntelligentInstrumentationService.kIntelligentInstrumentationThreadCountProperty, Integer.valueOf(100), agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            this.value = (Integer)newValue;
        }
    }
}

