/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.backend.http.helper;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.backendprotocols.BackendProtocolsConstants;
import com.wily.introscope.agent.trace.hc2.WilyTransactionStructure;
import com.wily.introscope.agent.trace.intelligent.SustainabilityMetricsHelper;
import com.wily.introscope.agent.urlgroup.URLComponents;
import com.wily.introscope.agent.urlgroup.URLGroupRuleContainer;
import com.wily.introscope.agent.urlgroup.URLMatchResult;
import com.wily.util.adt.IConcurrentMap;
import com.wily.util.adt.IGuaranteedCounter;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.IndexedProperties;
import com.wily.util.properties.hot.ConfigurationProperty;
import com.wily.util.properties.hot.PropertyGroupListner;
import java.util.Collections;
import java.util.Map;
import java.util.StringTokenizer;

public class BackendUrlGroupPropertyHandler
implements PropertyGroupListner,
BackendProtocolsConstants {
    private volatile URLGroupRuleContainer urlGroupRuleContainer = new URLGroupRuleContainer();
    private volatile boolean isNormalizationEnabled = false;
    private final IModuleFeedbackChannel feedback;
    private static final Module module = new Module("BackendURLGroupPropertyHandler");
    private static int fBackendUrlClamp = -1;
    private static IConcurrentMap fBackendUrlGroupMap;
    private static IGuaranteedCounter fBackendUrlCounter;

    public String getKeyGroupPrefix() {
        return "introscope.agent.backendpathgroup";
    }

    public BackendUrlGroupPropertyHandler(IAgent agent) {
        this.feedback = agent.IAgent_getModuleFeedback();
        this.initializeUrlGroups(agent);
        Map map = agent.IAgent_getConcurrentMapFactory().getConcurrentMap("BackendUrlGroups");
        if (map instanceof IConcurrentMap) {
            fBackendUrlGroupMap = (IConcurrentMap)map;
        }
        fBackendUrlCounter = agent.IAgent_getGuaranteedCounter();
        agent.IAgent_getConfigurationManager().add(new ConfigurationProperty("introscope.agent.urlgroup.backend.url.clamp", "5", "Hot_Property_Configuration_Property", null, true, false, this.feedback, agent.IAgent_getModule(), agent.IAgent_getStringLocalizer()){

            public final void set(Object value) {
                fBackendUrlClamp = Integer.parseInt((String)value);
            }
        });
    }

    public void onChange(IndexedProperties props) {
        WilyTransactionStructure.getInstance().ageAllImmediately();
        this.initializeUrlGroups(props);
    }

    public String getNormalizedPath(String path) {
        try {
            if (!this.isNormalizationEnabled) {
                return path;
            }
            URLComponents urlComps = new URLComponents(null, null, 0, path, Collections.EMPTY_MAP);
            URLMatchResult matchResult = this.urlGroupRuleContainer.matchFirstRule(urlComps);
            if (matchResult != null && matchResult.getFormatted() != null && !matchResult.getFormatted().isEmpty()) {
                path = matchResult.getFormatted();
            } else {
                this.feedback.warn(module, "Could not get the normalized url path for:" + path);
            }
        }
        catch (Exception e) {
            this.feedback.error(module, "There is an error while doing the normalization:" + e.getMessage());
        }
        if (fBackendUrlClamp >= 0) {
            path = BackendUrlGroupPropertyHandler.applyURLGroupClamp(path, this.feedback);
        }
        return path;
    }

    private void initializeUrlGroups(IAgent agent) {
        this.initializeUrlGroups(agent.IAgent_getIndexedProperties());
    }

    private void initializeUrlGroups(IndexedProperties props) {
        try {
            URLGroupRuleContainer container = new URLGroupRuleContainer();
            String keys = props.getProperty("introscope.agent.backendpathgroup.keys");
            boolean foundKey = false;
            if (keys != null && keys.length() > 0) {
                StringTokenizer strtok = new StringTokenizer(keys, ",", false);
                while (strtok.hasMoreTokens()) {
                    String currentKey = strtok.nextToken();
                    String propPrefix = "introscope.agent.backendpathgroup.group." + currentKey;
                    String prefixPropKey = String.valueOf(propPrefix) + ".pathprefix";
                    String formatPropKey = String.valueOf(propPrefix) + ".format";
                    String currentPathPrefix = props.getProperty(prefixPropKey);
                    String currentFormat = null;
                    if (currentPathPrefix != null && currentPathPrefix.length() > 0) {
                        currentFormat = props.getProperty(formatPropKey);
                        if (currentFormat != null && currentFormat.length() > 0) {
                            foundKey = true;
                            container.add(currentPathPrefix, currentFormat);
                            continue;
                        }
                        this.feedback.warn("Mis-configured agent properties: " + prefixPropKey + " has value " + currentPathPrefix + ", " + formatPropKey + " has value " + currentFormat + " (both must be non-null and non-empty)");
                        continue;
                    }
                    this.feedback.warn("Mis-configured agent properties: " + prefixPropKey + " has value " + currentPathPrefix + " -- it must be non-null and non-empty");
                }
            }
            this.urlGroupRuleContainer = container;
            this.isNormalizationEnabled = foundKey;
        }
        catch (Exception e) {
            try {
                this.feedback.error("BaseURINameFormatter: Could not initialize URL/Path groupings");
                this.feedback.verbose((Throwable)e);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable throwable) {}
        }
    }

    private static String applyURLGroupClamp(String normalizedUrl, IModuleFeedbackChannel feedback) {
        String result = normalizedUrl;
        String urlGroupKey = "";
        if (result.equals("Resources")) {
            return result;
        }
        if (fBackendUrlGroupMap != null) {
            if (fBackendUrlGroupMap.containsKey((Object)result)) {
                return result;
            }
            if (!BackendUrlGroupPropertyHandler.checkUrlGroupClamp(feedback)) {
                result = "Default";
                return result;
            }
            urlGroupKey = (String)fBackendUrlGroupMap.putIfAbsent((Object)result, (Object)"");
            if (urlGroupKey != null) {
                fBackendUrlCounter.prev();
            } else {
                SustainabilityMetricsHelper.reportBackendURLGroupsMatched((int)fBackendUrlCounter.peek());
            }
        }
        return result;
    }

    private static boolean checkUrlGroupClamp(IModuleFeedbackChannel feedback) {
        int urlCount;
        if (fBackendUrlClamp >= 0 && (urlCount = fBackendUrlCounter.next()) >= fBackendUrlClamp) {
            if (urlCount == fBackendUrlClamp) {
                feedback.info("Absolute URL metric clamp of " + fBackendUrlClamp + " reached, All metics will now report under the Default group.");
                return true;
            }
            fBackendUrlCounter.prev();
            return false;
        }
        return true;
    }
}

