/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.introscope.launch;

import com.ca.apm.introscope.launch.AgentClassLoader;
import com.ca.apm.introscope.launch.CustomAgentLauncher;
import com.ca.apm.introscope.upgrade.FileUtils;
import com.ca.apm.introscope.upgrade.InstallableUnit;
import com.ca.apm.introscope.upgrade.KLauncherConstants;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;

public class AgentUpdateInfo {
    private final String fAgentDir;
    private final String fLogDir;
    private final String fCoreDir;
    private final String fConfigDir;
    private final String fExtDir;
    private String fCurrentCoreDir;
    private String fCurrentConfigDir;
    private final String fUpdateDir;
    private final String fBackupDir;
    private final String fAgentFileName;
    private final String fAgentName;
    private final int fAgentOrder;
    private String fCurrentBackupDir;
    private boolean fBackedUp;
    private boolean fOverrideAgentJarWithNew;
    private String fStagingDir;
    private String fStagingConfigDir;
    private String fNewCoreDir;
    private String fRelativeNewCoreDir;
    private String fNewConfigDir;
    private String fNewExtDir;
    private InstallableUnit fInstallableUnit;
    private String fFormattedDate;
    private boolean fProfileMerge;
    private boolean fPblMerge;
    private boolean fPbdMerge;
    private Set<String> fNewFiles;
    private String fMergeRulesFile;
    private String fUpgradeStatusLog;
    private String fBackupUpgradeStatusLog;
    private Logger fLogger;

    public AgentUpdateInfo(String agentDir, String logDir, String coreDir, String updateDir, String backupDir, String statusLog, String agentFileName, String agentName, int agentOrder, boolean profileMerge, boolean pblMerge, boolean pbdMerge) {
        this.fAgentDir = agentDir;
        this.fLogDir = logDir;
        this.fCoreDir = coreDir;
        this.fConfigDir = String.valueOf(this.fCoreDir) + File.separator + "config";
        this.fExtDir = String.valueOf(this.fCoreDir) + File.separator + "ext";
        this.fCurrentCoreDir = this.fCoreDir;
        this.fCurrentConfigDir = this.fConfigDir;
        this.fUpdateDir = updateDir;
        this.fBackupDir = backupDir;
        this.fUpgradeStatusLog = statusLog;
        this.fAgentFileName = agentFileName;
        this.fAgentName = agentName;
        this.fAgentOrder = agentOrder;
        this.fProfileMerge = profileMerge;
        this.fPblMerge = pblMerge;
        this.fPbdMerge = pbdMerge;
        this.fNewFiles = new HashSet<String>();
        this.fLogger = Logger.getLogger(CustomAgentLauncher.class.getName());
    }

    public void cleanup() {
        this.deleteNewUpgrade();
    }

    public boolean isRequestingUpdate() {
        boolean update = false;
        File file = new File(String.valueOf(this.fUpdateDir) + File.separator + "upgrade.zip");
        if (file.exists()) {
            update = true;
        }
        return update;
    }

    public boolean moveAndValidateInstallableUnit() {
        boolean success = false;
        String srcPath = String.valueOf(this.fUpdateDir) + File.separator + "upgrade.zip";
        File srcFile = new File(srcPath);
        if (!srcFile.exists()) {
            return success;
        }
        if (this.fStagingDir == null) {
            Date currentDate = new Date();
            this.fFormattedDate = KLauncherConstants.sFormatter.format(currentDate);
            this.fStagingDir = String.valueOf(this.fBackupDir) + File.separator + "bak" + this.fFormattedDate;
            File backupDir = new File(this.fStagingDir);
            if (!backupDir.exists() && !backupDir.mkdir()) {
                return success;
            }
        }
        String destPath = String.valueOf(this.fStagingDir) + File.separator + "upgrade.zip";
        try {
            FileUtils.moveFile(srcFile, new File(destPath));
            this.fInstallableUnit = new InstallableUnit();
            success = this.fInstallableUnit.validate(destPath);
            this.fBackupUpgradeStatusLog = String.valueOf(this.fStagingDir) + File.separator + "AgentUpgradeStatus.log";
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return success;
    }

    public boolean backupCurrent() {
        boolean update = false;
        String srcAgentPath = String.valueOf(this.fAgentDir) + File.separator + this.fAgentFileName;
        if (this.fCurrentBackupDir == null) {
            this.fCurrentBackupDir = String.valueOf(this.fCoreDir) + File.separator + "bak";
            File coreBakDir = new File(this.fCurrentBackupDir);
            if (!coreBakDir.exists() && !coreBakDir.mkdir()) {
                return update;
            }
            this.clearDirectory(coreBakDir);
        }
        if (this.fInstallableUnit != null && !this.fInstallableUnit.hasAgentJars()) {
            update = true;
            return update;
        }
        File agentFile = new File(srcAgentPath);
        if (!agentFile.exists()) {
            update = true;
            return update;
        }
        try {
            String destAgentPath = String.valueOf(this.fCurrentBackupDir) + File.separator + this.fAgentFileName;
            FileUtils.replaceFile(agentFile, new File(destAgentPath));
            update = true;
            this.fBackedUp = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return update;
    }

    public boolean restoreBackup() {
        boolean success = true;
        if (this.fBackedUp) {
            this.fNewFiles.clear();
            boolean delSuccess = this.deleteNewCore();
            success = success && delSuccess;
            delSuccess = this.deleteNewUpgrade();
            success = success && delSuccess;
        }
        this.fLogger.info("Was restoring backup successful? " + success);
        return true;
    }

    public boolean onSuccessfulValidation() {
        boolean success = true;
        if (this.fNewCoreDir != null) {
            String srcAgentJar;
            File srcFile;
            if (this.fOverrideAgentJarWithNew && (srcFile = new File(srcAgentJar = String.valueOf(this.fNewCoreDir) + File.separator + this.fAgentFileName)).exists()) {
                File destFile = new File(String.valueOf(this.fAgentDir) + File.separator + this.fAgentFileName);
                try {
                    FileUtils.replaceFile(srcFile, destFile);
                    success = FileUtils.validateFile(destFile);
                }
                catch (IOException e) {
                    success = false;
                    this.fLogger.warning("Failed to move Agent Jar " + e.getMessage());
                }
            }
            this.fNewFiles.clear();
            this.fBackedUp = false;
            boolean delSuccess = this.deleteNewUpgrade();
            this.fLogger.finest("Was Successful in deleting " + this.fStagingDir + File.separator + "upgrade" + "? " + delSuccess);
        }
        return success;
    }

    public boolean onUnsuccessfulValidation() {
        boolean success = true;
        if (this.fNewCoreDir != null) {
            this.fNewFiles.clear();
            this.fBackedUp = false;
            boolean delSuccess = this.deleteNewUpgrade();
            this.fLogger.finest("Was Successful in deleting " + this.fStagingDir + File.separator + "upgrade" + "? " + delSuccess);
            String newCore = this.fNewCoreDir;
            success = this.deleteNewCore();
            this.fLogger.finest("Was Successful in deleting " + newCore + "? " + success);
        }
        return success;
    }

    public boolean createNewCore() {
        boolean success = false;
        try {
            if (this.fInstallableUnit == null || this.fStagingDir == null || this.fNewCoreDir != null) {
                return success;
            }
            String src = String.valueOf(this.fStagingDir) + File.separator + "upgrade.zip";
            Set<String> updateProfiles = this.fInstallableUnit.unzip(src, this.fStagingDir);
            if (this.fFormattedDate != null) {
                Date currentDate = new Date();
                this.fFormattedDate = KLauncherConstants.sFormatter.format(currentDate);
            }
            this.fRelativeNewCoreDir = "core" + this.fFormattedDate;
            this.fNewCoreDir = String.valueOf(this.fAgentDir) + File.separator + this.fRelativeNewCoreDir;
            this.fNewConfigDir = String.valueOf(this.fNewCoreDir) + File.separator + "config";
            this.fNewExtDir = String.valueOf(this.fNewCoreDir) + File.separator + "ext";
            File newCoreDir = new File(this.fNewCoreDir);
            if (!newCoreDir.exists() && !newCoreDir.mkdir()) {
                return success;
            }
            String upgradeDir = String.valueOf(this.fStagingDir) + File.separator + "upgrade";
            String upgradeCoreDir = String.valueOf(upgradeDir) + File.separator + "core";
            this.fStagingConfigDir = String.valueOf(upgradeCoreDir) + File.separator + "config";
            this.fMergeRulesFile = String.valueOf(upgradeCoreDir) + File.separator + "merge-rules.xml";
            final HashSet<String> customerProfiles = new HashSet<String>();
            this.copyDirectoryRecursively(new File(this.fCoreDir), newCoreDir, new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    String ext;
                    boolean retValue = true;
                    if (dir.getName().equalsIgnoreCase("bak") || dir.getName().equalsIgnoreCase("orig")) {
                        retValue = false;
                    } else if (dir.getName().equalsIgnoreCase("config") && "profile".equalsIgnoreCase(ext = AgentUpdateInfo.this.getFileExtension(name))) {
                        customerProfiles.add(name);
                    }
                    return retValue;
                }
            });
            this.createExtraProfilesIfNeeded(updateProfiles, customerProfiles, new File(String.valueOf(upgradeCoreDir) + File.separator + "config"));
            this.moveFilesFromUpgradeRecursively(new File(upgradeCoreDir), newCoreDir);
            this.copyFromUpgradeDirectory(new File(upgradeDir), new File(this.fAgentDir), newCoreDir);
            success = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return success;
    }

    private boolean deleteNewCore() {
        boolean success = true;
        if (this.fNewCoreDir == null) {
            return success;
        }
        File newCoreDir = new File(this.fNewCoreDir);
        if (newCoreDir.exists()) {
            success = FileUtils.deleteDirectory(newCoreDir);
            this.fNewCoreDir = null;
            this.fRelativeNewCoreDir = null;
        }
        return success;
    }

    private boolean deleteNewUpgrade() {
        boolean success = true;
        if (this.fStagingDir == null) {
            return success;
        }
        String upgradeDirPath = String.valueOf(this.fStagingDir) + File.separator + "upgrade";
        File upgradeDir = new File(upgradeDirPath);
        if (upgradeDir.exists()) {
            success = FileUtils.deleteDirectory(upgradeDir);
        }
        return success;
    }

    public URLClassLoader getClassLoader() throws MalformedURLException {
        String url = "file:/" + this.fNewCoreDir + File.separator + this.fAgentFileName;
        this.fLogger.info("Agent class loader url: " + url);
        AgentClassLoader classLoader = new AgentClassLoader(new URL[]{new URL(url)}, ClassLoader.getSystemClassLoader());
        return classLoader;
    }

    public String getAgentDirectory() {
        return this.fAgentDir;
    }

    public String getLogDirectory() {
        return this.fLogDir;
    }

    public String getCoreDirectory() {
        return this.fCoreDir;
    }

    public String getConfigDirectory() {
        return this.fConfigDir;
    }

    public String getExtDirectory() {
        return this.fExtDir;
    }

    public String getCurrentCoreDirectory() {
        return this.fCurrentCoreDir;
    }

    public void setCurrentCoreDirectory(String currentCoreDir) {
        this.fCurrentCoreDir = currentCoreDir;
        this.fCurrentConfigDir = String.valueOf(this.fCurrentCoreDir) + File.separator + "config";
    }

    public String getCurrentConfigDirectory() {
        return this.fCurrentConfigDir;
    }

    public String getNewCoreDirectory() {
        return this.fNewCoreDir;
    }

    public String getRelativeNewCoreDirectory() {
        return this.fRelativeNewCoreDir;
    }

    public String getNewConfigDirectory() {
        return this.fNewConfigDir;
    }

    public String getNewExtDirectory() {
        return this.fNewExtDir;
    }

    public String getStagingConfigDirectory() {
        return this.fStagingConfigDir;
    }

    public String getUpdateDirectory() {
        return this.fUpdateDir;
    }

    public String getUpgradeStatusLog() {
        return this.fUpgradeStatusLog;
    }

    public String getBackupUpgradeStatusLog() {
        return this.fBackupUpgradeStatusLog;
    }

    public String getFormattedMetadata() {
        String formattedData = "";
        if (this.fInstallableUnit != null) {
            formattedData = this.fInstallableUnit.getFormattedMetadata();
        }
        return formattedData;
    }

    public String getBackupDirectory() {
        return this.fBackupDir;
    }

    public String getAgentFileName() {
        return this.fAgentFileName;
    }

    public String getMergeRulesFile() {
        return this.fMergeRulesFile;
    }

    private void copyFromUpgradeDirectory(File upgradeDir, File agentDir, File newCoreDir) throws IOException {
        File[] files;
        if (!(upgradeDir.exists() && agentDir.exists() && newCoreDir.exists())) {
            throw new IOException("Missing directories!");
        }
        this.fNewFiles.clear();
        File[] fileArray = files = upgradeDir.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (!file.isDirectory()) {
                File agentCoreFile;
                String filename = file.getName();
                File coreFile = new File(newCoreDir, filename);
                FileUtils.copyFile(file, coreFile);
                if (filename.equalsIgnoreCase("Agent.jar") && "Agent".equalsIgnoreCase(this.fAgentName)) {
                    this.fOverrideAgentJarWithNew = true;
                    if (this.fAgentOrder != 0) {
                        filename = "Agent" + this.fAgentOrder + ".jar";
                        agentCoreFile = new File(newCoreDir, filename);
                        FileUtils.copyFile(file, agentCoreFile);
                    }
                    this.fNewFiles.add(filename);
                } else if (filename.equalsIgnoreCase("AgentNoRedef.jar") && "AgentNoRedef".equalsIgnoreCase(this.fAgentName)) {
                    this.fOverrideAgentJarWithNew = true;
                    if (this.fAgentOrder != 0) {
                        filename = "AgentNoRedef" + this.fAgentOrder + ".jar";
                        agentCoreFile = new File(newCoreDir, filename);
                        FileUtils.copyFile(file, agentCoreFile);
                    }
                    this.fNewFiles.add(filename);
                } else if (!filename.equalsIgnoreCase("au.inf")) {
                    this.fNewFiles.add(filename);
                }
            }
            ++n2;
        }
        if (!this.fOverrideAgentJarWithNew) {
            File agentFile = new File(agentDir, this.fAgentFileName);
            File destFile = new File(newCoreDir, this.fAgentFileName);
            if (agentFile.exists()) {
                FileUtils.copyFile(agentFile, destFile);
            } else {
                agentFile = new File(agentDir, String.valueOf(this.fAgentName) + ".jar");
                if (agentFile.exists()) {
                    FileUtils.copyFile(agentFile, destFile);
                    this.fOverrideAgentJarWithNew = true;
                    this.fNewFiles.add(this.fAgentFileName);
                }
            }
        }
    }

    private void copyFromUpgradeDirectoryOld(File upgradeDir, File agentDir, File newCoreDir) throws IOException {
        File[] files;
        if (!(upgradeDir.exists() && agentDir.exists() && newCoreDir.exists())) {
            throw new IOException("Missing directories!");
        }
        File newCoreOrgDir = new File(newCoreDir, "orig");
        if (!newCoreOrgDir.exists() && !newCoreOrgDir.mkdir()) {
            throw new IOException("Failed to create directory " + newCoreOrgDir.getName());
        }
        this.fNewFiles.clear();
        File[] fileArray = files = upgradeDir.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (!file.isDirectory()) {
                String filename = file.getName();
                File coreFile = new File(newCoreOrgDir, filename);
                FileUtils.copyFile(file, coreFile);
                if (filename.equalsIgnoreCase("Agent.jar") && "Agent".equalsIgnoreCase(this.fAgentName)) {
                    this.fOverrideAgentJarWithNew = true;
                    if (this.fAgentOrder != 0) {
                        filename = "Agent" + this.fAgentOrder + "jar";
                    }
                } else if (filename.equalsIgnoreCase("AgentNoRedef.jar") && "AgentNoRedef".equalsIgnoreCase(this.fAgentName)) {
                    if (this.fAgentOrder != 0) {
                        filename = "AgentNoRedef" + this.fAgentOrder + "jar";
                    }
                } else if (filename.equalsIgnoreCase("au.inf")) {
                    filename = null;
                }
                if (filename != null) {
                    File agentFile = new File(agentDir, filename);
                    if (agentFile.exists()) {
                        String destPath = String.valueOf(this.fCurrentBackupDir) + File.separator + filename;
                        FileUtils.copyFile(agentFile, new File(destPath));
                        if (!agentFile.delete()) {
                            this.fLogger.severe("!!! Failed to delete " + agentFile);
                        }
                    }
                    agentFile = null;
                    this.fNewFiles.add(filename);
                    agentFile = new File(agentDir, filename);
                    FileUtils.copyFile(file, agentFile);
                }
            }
            ++n2;
        }
    }

    private void copyDirectoryRecursively(File srcDir, File destDir, FilenameFilter filter) throws IOException {
        if (srcDir.isDirectory()) {
            if (!destDir.exists() && !destDir.mkdir()) {
                throw new IOException("Failed to create " + destDir.getName());
            }
            String[] files = srcDir.list(filter);
            int i = 0;
            while (i < files.length) {
                this.copyDirectoryRecursively(new File(srcDir, files[i]), new File(destDir, files[i]), filter);
                ++i;
            }
        } else if (destDir.isDirectory()) {
            FileUtils.copyFile(srcDir, new File(destDir, srcDir.getName()));
        } else {
            FileUtils.copyFile(srcDir, destDir);
        }
    }

    private void createExtraProfilesIfNeeded(Set<String> updateProfiles, Set<String> customerProfiles, File upgradeConfigDir) throws IOException {
        ArrayList<String> profiles = new ArrayList<String>();
        for (String profile : customerProfiles) {
            if (updateProfiles.contains(profile)) continue;
            profiles.add(profile);
        }
        if (profiles.size() > 0 && updateProfiles.contains("IntroscopeAgent.profile")) {
            File srcFile = new File(upgradeConfigDir, "IntroscopeAgent.profile");
            if (!srcFile.exists()) {
                return;
            }
            for (String profile : profiles) {
                File destFile = new File(upgradeConfigDir, profile);
                FileUtils.copyFile(srcFile, destFile);
            }
        }
    }

    private void moveFilesFromUpgradeRecursively(File srcDir, File destDir) throws IOException {
        if (srcDir.isDirectory()) {
            if (!destDir.exists() && !destDir.mkdir()) {
                throw new IOException("Failed to make destionation directory " + destDir.getName());
            }
            String[] files = srcDir.list();
            int i = 0;
            while (i < files.length) {
                this.moveFilesFromUpgradeRecursively(new File(srcDir, files[i]), new File(destDir, files[i]));
                ++i;
            }
        } else if (destDir.isDirectory()) {
            this.moveFileSelectively(srcDir, new File(destDir, srcDir.getName()));
        } else {
            this.moveFileSelectively(srcDir, destDir);
        }
    }

    private void moveFileSelectively(File srcFile, File destFile) throws IOException {
        boolean move = this.isElligibleToMove(srcFile, destFile);
        if (move) {
            FileUtils.moveFile(srcFile, destFile);
        }
    }

    private boolean isElligibleToMove(File srcFile, File destFile) {
        boolean move = false;
        String ext = this.getFileExtension(srcFile.getName());
        if ("profile".equalsIgnoreCase(ext)) {
            if (!this.fProfileMerge || !destFile.exists()) {
                move = true;
            }
        } else if ("pbl".equalsIgnoreCase(ext)) {
            if (!this.fPblMerge || !destFile.exists()) {
                move = true;
            }
        } else if ("pbd".equalsIgnoreCase(ext)) {
            if (!this.fPbdMerge || !destFile.exists()) {
                move = true;
            }
        } else {
            move = true;
        }
        return move;
    }

    private String getFileExtension(String filename) {
        String ext = null;
        int dotPos = filename.lastIndexOf(46);
        if (dotPos > 0 && dotPos <= filename.length() - 2) {
            ext = filename.substring(dotPos + 1);
        }
        return ext;
    }

    private boolean clearDirectory(File dir) {
        boolean success = false;
        if (dir.exists() && dir.isDirectory()) {
            File[] files = dir.listFiles();
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    this.clearDirectory(files[i]);
                } else {
                    success = files[i].delete();
                }
                ++i;
            }
        }
        return success;
    }

    public String toString() {
        StringBuilder strBldr = new StringBuilder("Class:  AgentUpdateInfo");
        strBldr.append("\n\tWorking Directory:   [").append(this.fAgentDir).append("]").append("\n\tConfig Directory:    [").append(this.fConfigDir).append("]").append("\n\tExtension Directory: [").append(this.fExtDir).append("]").append("\n\tUpdate Directory:    [").append(this.fUpdateDir).append("]").append("\n\tBackup Directory:    [").append(this.fBackupDir).append("]");
        return strBldr.toString();
    }
}

