/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.introscope.launch;

import com.ca.apm.introscope.upgrade.ALauncherAlgorithm;
import com.ca.apm.introscope.upgrade.LauncherLogger;
import com.ca.apm.introscope.upgrade.MultiLauncherAlgorithm;
import com.ca.apm.introscope.upgrade.SingleLauncherAlgorithm;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Logger;

public class CustomAgentLauncher {
    private static Logger sLogger = Logger.getLogger(CustomAgentLauncher.class.getName());

    public static void premain(String agentArgs, Instrumentation inst) throws FileNotFoundException, IOException {
        sLogger.info("Starting launcher at " + new Date());
        String[] args = agentArgs.split(";");
        File launchPropertyFile = new File(args[0]);
        if (!launchPropertyFile.exists()) {
            sLogger.severe("Cannot find file launch.properties at " + args[0] + ". Agent will not start.");
            return;
        }
        Properties launchProperties = new Properties();
        FileInputStream fistream = null;
        try {
            try {
                fistream = new FileInputStream(launchPropertyFile);
                launchProperties.load(fistream);
                LauncherLogger.setup(sLogger, launchPropertyFile.getParentFile().getCanonicalPath(), launchProperties);
            }
            catch (FileNotFoundException e) {
                sLogger.severe("Cannot open file launch.properties. Agent will not start.");
                throw e;
            }
        }
        finally {
            if (fistream != null) {
                fistream.close();
            }
        }
        boolean multiLauncherEnabled = Boolean.parseBoolean(launchProperties.getProperty("com.ca.apm.introscope.launch.agent.order.enabled", "false"));
        ALauncherAlgorithm launcherAlgo = null;
        launcherAlgo = multiLauncherEnabled ? new MultiLauncherAlgorithm(agentArgs, inst, launchPropertyFile, sLogger) : new SingleLauncherAlgorithm(agentArgs, inst, launchPropertyFile, sLogger);
        launcherAlgo.start();
    }
}

