/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.introscope.upgrade;

import com.ca.apm.introscope.launch.CustomAgentLauncher;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.logging.Logger;

public class FileUtils {
    public static boolean validateFile(File srcFile) {
        boolean success;
        block26: {
            success = false;
            FileInputStream istream = null;
            BufferedInputStream bistream = null;
            try {
                try {
                    istream = new FileInputStream(srcFile);
                    byte[] data = new byte[1024];
                    int count = 0;
                    bistream = new BufferedInputStream(istream);
                    int x = 0;
                    long total = 0L;
                    while ((count = bistream.read(data)) > 0) {
                        int i = 0;
                        while (i < count) {
                            x = data[i] & 0xFF;
                            total += (long)(x >>>= 1);
                            ++i;
                        }
                    }
                    if (total > 0L) {
                        success = true;
                    }
                }
                catch (IOException iOException) {
                    try {
                        if (bistream != null) {
                            bistream.close();
                        }
                    }
                    catch (IOException iOException2) {
                        System.out.println("Problems during cleaning up the I/O.");
                    }
                    try {
                        if (istream != null) {
                            ((InputStream)istream).close();
                        }
                        break block26;
                    }
                    catch (IOException iOException3) {
                        System.out.println("Problems during cleaning up the I/O.");
                    }
                    break block26;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (bistream != null) {
                        bistream.close();
                    }
                }
                catch (IOException iOException) {
                    System.out.println("Problems during cleaning up the I/O.");
                }
                try {
                    if (istream != null) {
                        ((InputStream)istream).close();
                    }
                }
                catch (IOException iOException) {
                    System.out.println("Problems during cleaning up the I/O.");
                }
                throw throwable;
            }
            try {
                if (bistream != null) {
                    bistream.close();
                }
            }
            catch (IOException iOException) {
                System.out.println("Problems during cleaning up the I/O.");
            }
            try {
                if (istream != null) {
                    ((InputStream)istream).close();
                }
            }
            catch (IOException iOException) {
                System.out.println("Problems during cleaning up the I/O.");
            }
        }
        return success;
    }

    public static void replaceFile(File srcFile, File destFile) throws IOException {
        if (!srcFile.exists()) {
            return;
        }
        if (destFile.exists()) {
            destFile.delete();
        }
        FileUtils.copyFile(srcFile, destFile);
    }

    public static void moveFile(File srcFile, File destFile) throws IOException {
        if (!srcFile.exists()) {
            return;
        }
        if (destFile.exists() && !destFile.delete()) {
            throw new IOException("Failed to delete destination file " + destFile);
        }
        boolean rename = srcFile.renameTo(destFile);
        if (!rename) {
            FileUtils.copyFile(srcFile, destFile);
            if (!srcFile.delete()) {
                throw new IOException("Failed to delete source file " + srcFile);
            }
        }
    }

    public static void copyFile(File srcFile, File destFile) throws IOException {
        FileInputStream istream = null;
        OutputStream ostream = null;
        BufferedInputStream bistream = null;
        try {
            istream = new FileInputStream(srcFile);
            ostream = new FileOutputStream(destFile);
            byte[] data = new byte[1024];
            int count = 0;
            bistream = new BufferedInputStream(istream);
            while ((count = bistream.read(data)) > 0) {
                ostream.write(data, 0, count);
            }
            ostream.flush();
        }
        catch (Throwable throwable) {
            try {
                if (ostream != null) {
                    ostream.close();
                }
            }
            catch (IOException iOException) {
                System.out.println("Problems during cleaning up the I/O.");
            }
            try {
                if (bistream != null) {
                    bistream.close();
                }
            }
            catch (IOException iOException) {
                System.out.println("Problems during cleaning up the I/O.");
            }
            try {
                if (istream != null) {
                    ((InputStream)istream).close();
                }
            }
            catch (IOException iOException) {
                System.out.println("Problems during cleaning up the I/O.");
            }
            throw throwable;
        }
        try {
            if (ostream != null) {
                ostream.close();
            }
        }
        catch (IOException iOException) {
            System.out.println("Problems during cleaning up the I/O.");
        }
        try {
            if (bistream != null) {
                bistream.close();
            }
        }
        catch (IOException iOException) {
            System.out.println("Problems during cleaning up the I/O.");
        }
        try {
            if (istream != null) {
                ((InputStream)istream).close();
            }
        }
        catch (IOException iOException) {
            System.out.println("Problems during cleaning up the I/O.");
        }
    }

    public static void copyFileNew(File srcFile, File destFile) throws IOException {
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        FileInputStream fistream = null;
        FileOutputStream fostream = null;
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            fistream = new FileInputStream(srcFile);
            source = fistream.getChannel();
            fostream = new FileOutputStream(destFile);
            destination = fostream.getChannel();
            long position = 0L;
            long size = source.size();
            while (position < size) {
                position += ((FileChannel)destination).transferFrom(source, position, size - position);
            }
            fostream.flush();
        }
        finally {
            if (destination != null) {
                try {
                    destination.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fostream != null) {
                try {
                    fostream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (source != null) {
                try {
                    source.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fistream != null) {
                try {
                    fistream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void checkIfFileHasLock(String fileName) {
        File file = new File(fileName);
        FileLock lock = null;
        try {
            try {
                FileChannel channel = new RandomAccessFile(file, "rw").getChannel();
                lock = channel.lock();
                lock = channel.tryLock();
            }
            catch (Exception e) {
                Logger.getLogger(CustomAgentLauncher.class.getName()).severe(e.getMessage());
                e.printStackTrace();
                try {
                    lock.release();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                lock.release();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean deleteDirectory(File dir) {
        boolean success = false;
        if (dir.exists() && dir.isDirectory()) {
            String[] children = dir.list();
            int i = 0;
            while (i < children.length) {
                success = FileUtils.deleteDirectory(new File(dir, children[i]));
                if (!success) {
                    return success;
                }
                ++i;
            }
        }
        return dir.delete();
    }
}

