/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.introscope.upgrade;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class LauncherLogger {
    private static FileHandler sFileTxt;
    private static SimpleFormatter sFormatterTxt;

    public static void setup(Logger logger, String currentPath, Properties launchProperties) throws IOException {
        String fileName = launchProperties.getProperty("com.ca.apm.introscope.launcher.logger.file");
        String levelStr = launchProperties.getProperty("com.ca.apm.introscope.launcher.logger.level", "INFO");
        Level level = LauncherLogger.getLevel(levelStr);
        logger.setLevel(level);
        if (fileName != null) {
            sFileTxt = new FileHandler(LauncherLogger.getFilePath(currentPath, fileName));
            sFormatterTxt = new SimpleFormatter();
            sFileTxt.setFormatter(sFormatterTxt);
            logger.addHandler(sFileTxt);
        }
    }

    private static Level getLevel(String level) {
        Level retLevel = Level.INFO;
        if ("INFO".equalsIgnoreCase(level)) {
            retLevel = Level.INFO;
        } else if ("SEVERE".equalsIgnoreCase(level)) {
            retLevel = Level.SEVERE;
        } else if ("WARNING".equalsIgnoreCase(level)) {
            retLevel = Level.WARNING;
        } else if ("ALL".equalsIgnoreCase(level) || "DEBUG".equalsIgnoreCase(level)) {
            retLevel = Level.ALL;
        }
        return retLevel;
    }

    private static String getFilePath(String relativeDir, String filePath) throws IOException {
        String canonicalPath = filePath;
        File file = new File(filePath);
        if (!file.isAbsolute()) {
            file = new File(relativeDir, filePath);
            canonicalPath = file.getCanonicalPath();
        }
        return canonicalPath;
    }
}

