/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.introscope.upgrade;

import com.ca.apm.introscope.upgrade.FileUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class UpgradeStatusLogger {
    private String fLogPath;
    private List<String> fLogList;

    public UpgradeStatusLogger(String logPath) throws IOException {
        this.fLogPath = logPath;
        File logFile = new File(this.fLogPath);
        if (!logFile.exists() && !logFile.createNewFile()) {
            throw new IOException("Failed to create update status log file");
        }
        this.fLogList = new ArrayList<String>();
    }

    public void log(String msg) {
        this.fLogList.add(msg);
    }

    public void save(boolean status, String logPath) throws IOException {
        BufferedReader reader = null;
        OutputStreamWriter writer = null;
        BufferedWriter bufferedWriter = null;
        try {
            reader = new BufferedReader(new FileReader(this.fLogPath));
            String line = null;
            while ((line = reader.readLine()) != null) {
                this.fLogList.add(line);
            }
            StringBuilder strBldr = new StringBuilder();
            String newLine = System.getProperty("line.separator");
            strBldr.append("<update-status>").append(newLine);
            if (status) {
                strBldr.append("\t<status>Agent upgraded successfully on " + new Date() + ".</status>").append(newLine);
            } else {
                strBldr.append("\t<status>Agent upgrade attempt on " + new Date() + " was unsuccessful.</status>").append(newLine);
            }
            for (String log : this.fLogList) {
                strBldr.append(log).append(newLine);
            }
            strBldr.append("</update-status>");
            writer = new FileWriter(this.fLogPath);
            bufferedWriter = new BufferedWriter(writer);
            bufferedWriter.write(strBldr.toString());
            bufferedWriter.flush();
            bufferedWriter.close();
            if (logPath != null) {
                FileUtils.copyFile(new File(this.fLogPath), new File(logPath));
            }
        }
        catch (Throwable throwable) {
            this.fLogList.clear();
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException) {}
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        this.fLogList.clear();
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
        if (bufferedWriter != null) {
            try {
                bufferedWriter.close();
            }
            catch (IOException iOException) {}
        }
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException iOException) {}
        }
    }
}

