/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.tracer;

import com.wily.diagnos.cmp.classfile.DGClassModificationException;
import com.wily.diagnos.cmp.log.DGCompilerLog;
import com.wily.diagnos.cmp.log.ICompilerLog;
import com.wily.diagnos.cmp.mutate.IMethodMutator;
import com.wily.diagnos.cmp.mutate.IMutation;
import com.wily.diagnos.cmp.tracer.MethodTracer;
import com.wily.diagnos.personality.java.classfile.DGMethod;
import com.wily.util.WilyStringBuilder;
import com.wily.util.classfile.IClassName;
import com.wily.util.classfile.IModeledMethod;
import com.wily.util.classfile.java.ClassName;
import com.wily.wilyassert.Assertion;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class DGAggregateMethodTracer {
    private static final IMutation kEmptyMutation = new IMutation(){

        public void mutate() throws DGClassModificationException, IOException {
        }
    };
    private boolean containsNewBlame;
    private boolean containsDeclaredOldBlame;
    private boolean containsMaybeOldBlame;
    private final List fIndividualTracers = new ArrayList();
    private IClassName fTracerLoadingClass;
    private boolean fNeedsStubbing = false;

    private void setTracerLoadingClass(IClassName tracerLoadingClass) {
        this.fTracerLoadingClass = tracerLoadingClass;
    }

    protected IClassName getTracerLoadingClass() {
        return this.fTracerLoadingClass;
    }

    public void addTracer(MethodTracer tracer) {
        this.fIndividualTracers.add(tracer);
        Assertion.wilyAssert(false);
        this.setTracerLoadingClass(tracer.getInstrumentationClass());
        if (tracer.isNewBlame()) {
            this.containsNewBlame = true;
        } else if (tracer.isDeclaredOldBlame()) {
            this.containsDeclaredOldBlame = true;
        } else if (tracer.isMaybeOldBlame()) {
            this.containsMaybeOldBlame = true;
        }
    }

    public IMutation newMutation(IMethodMutator mutator, IModeledMethod method) throws DGClassModificationException {
        Assertion.wilyAssert(false);
        Assertion.wilyAssert(false);
        if (method.isInstanceConstructor()) {
            return mutator.newAggregateConstructorMethodTracerMutation(method, this, this.getTracerLoadingClass());
        }
        return mutator.newAggregateMethodTracerMutation(method, this, this.getTracerLoadingClass());
    }

    public String getTracerParameter() {
        Assertion.wilyAssert(false);
        ArrayList<TracerInfo> tracerInfoList = new ArrayList<TracerInfo>(this.fIndividualTracers.size());
        int i = 0;
        while (i < this.fIndividualTracers.size()) {
            MethodTracer tracer = (MethodTracer)this.fIndividualTracers.get(i);
            tracerInfoList.add(new TracerInfo(tracer.getTracerOrdering(), tracer.getTracerClass(), tracer.getTracerParameters()));
            ++i;
        }
        Collections.sort(tracerInfoList);
        StringBuffer buffer = new StringBuffer();
        int i2 = 0;
        while (i2 < tracerInfoList.size()) {
            TracerInfo info = (TracerInfo)tracerInfoList.get(i2);
            buffer.append(",");
            buffer.append(info.getFactoryClass().getReflectionFriendlyQualifiedNameString());
            buffer.append(",");
            buffer.append(info.getTracerParameters());
            ++i2;
        }
        return buffer.toString();
    }

    private int getTracerCount() {
        return this.fIndividualTracers.size();
    }

    private Iterator getSortedLogMethodTracerIterator() {
        ArrayList<TracerLogInfo> tracerInfoList = new ArrayList<TracerLogInfo>(this.fIndividualTracers.size());
        int i = 0;
        while (i < this.fIndividualTracers.size()) {
            MethodTracer tracer = (MethodTracer)this.fIndividualTracers.get(i);
            tracerInfoList.add(new TracerLogInfo(tracer));
            ++i;
        }
        Collections.sort(tracerInfoList);
        return tracerInfoList.iterator();
    }

    private Iterator getDGMethodTracerIterator() {
        return this.fIndividualTracers.iterator();
    }

    public void logAggregateMethodTracer(ICompilerLog log, IModeledMethod m) {
        if (this.containsNewBlame && (this.containsDeclaredOldBlame || this.containsMaybeOldBlame)) {
            this.logDetailedAggregateMethodTracer(log, m);
            return;
        }
        Iterator iterator = this.getSortedLogMethodTracerIterator();
        while (iterator.hasNext()) {
            TracerLogInfo tracer = (TracerLogInfo)iterator.next();
            log.ICompilerLog_logMethodTracer(m, 0, tracer.t);
        }
    }

    private void logDetailedAggregateMethodTracer(ICompilerLog log, IModeledMethod m) {
        String methodName = "<Unknown>";
        if (m != null) {
            methodName = m.getMethodName().getNameString();
        }
        methodName = "        " + DGCompilerLog.staticPadPostfix(methodName, 35);
        Iterator iterator = this.getSortedLogMethodTracerIterator();
        while (iterator.hasNext()) {
            TracerLogInfo tracer = (TracerLogInfo)iterator.next();
            log.ICompilerLog_logMessage(tracer.getVerboseLog(methodName));
        }
    }

    public IMutation getConstructorMethodTracerMutationInstance(DGAggregateMethodTracer dgTracer, DGMethod method, ClassName tracerLoadingClass) {
        return kEmptyMutation;
    }

    public IMutation getMethodTracerMutationInstance(DGAggregateMethodTracer dgTracer, DGMethod method, ClassName tracerLoadingClass) {
        return kEmptyMutation;
    }

    public void setNeedsStubbing(boolean b) {
        this.fNeedsStubbing = b;
    }

    public boolean needsStubbing() {
        return this.fNeedsStubbing;
    }

    private static final class TracerInfo
    implements Comparable {
        private final int fOrdering;
        private final IClassName fFactoryClass;
        private final String fTracerParameters;

        public TracerInfo(int ordering, IClassName factoryClass, String tracerParameters) {
            this.fOrdering = ordering;
            this.fFactoryClass = factoryClass;
            this.fTracerParameters = tracerParameters;
        }

        public IClassName getFactoryClass() {
            return this.fFactoryClass;
        }

        public String getTracerParameters() {
            return this.fTracerParameters;
        }

        public int compareTo(Object o) {
            TracerInfo info = (TracerInfo)o;
            return this.fOrdering - info.fOrdering;
        }
    }

    private static final class TracerLogInfo
    implements Comparable {
        final MethodTracer t;

        public TracerLogInfo(MethodTracer tracer) {
            this.t = tracer;
        }

        public int compareTo(Object o) {
            TracerLogInfo info = (TracerLogInfo)o;
            return this.t.getTracerOrdering() - info.t.getTracerOrdering();
        }

        public String getVerboseLog(String methodName) {
            WilyStringBuilder builder = new WilyStringBuilder();
            builder.append(methodName);
            String tracerName = this.t.getTracerClass().getContainerAndPackageAndNameString();
            builder.append(" inserted method tracer object allocation: ").append(tracerName).append("; tracer order: ").append(this.t.getTracerOrdering()).append("; file: ").append(this.t.getFileName()).append("; line: ").append(this.t.getLine());
            return builder.toString();
        }
    }
}

