/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.personality.java.classfile.attributes.stackmapframe;

import com.wily.diagnos.personality.java.classfile.attributes.stackmapframe.DGDoubleVariableInfo;
import com.wily.diagnos.personality.java.classfile.attributes.stackmapframe.DGFloatVariableInfo;
import com.wily.diagnos.personality.java.classfile.attributes.stackmapframe.DGIntegerVariableInfo;
import com.wily.diagnos.personality.java.classfile.attributes.stackmapframe.DGLongVariableInfo;
import com.wily.diagnos.personality.java.classfile.attributes.stackmapframe.DGNullVariableInfo;
import com.wily.diagnos.personality.java.classfile.attributes.stackmapframe.DGObjectVariableInfo;
import com.wily.diagnos.personality.java.classfile.attributes.stackmapframe.DGTopVariableInfo;
import com.wily.diagnos.personality.java.classfile.attributes.stackmapframe.DGUninitializedThisVariableInfo;
import com.wily.diagnos.personality.java.classfile.attributes.stackmapframe.DGUninitializedVariableInfo;
import com.wily.diagnos.personality.java.classfile.attributes.stackmapframe.DGVerificationTypeInfo;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class DGVerificationTypeInfoArray {
    private DGVerificationTypeInfo[] fTypes;

    public DGVerificationTypeInfoArray(int count, DataInputStream data) throws IOException {
        this.fTypes = new DGVerificationTypeInfo[count];
        int i = 0;
        while (i < count) {
            int infoType = data.readUnsignedByte();
            switch (infoType) {
                case 0: {
                    this.fTypes[i] = new DGTopVariableInfo(data);
                    break;
                }
                case 1: {
                    this.fTypes[i] = new DGIntegerVariableInfo(data);
                    break;
                }
                case 2: {
                    this.fTypes[i] = new DGFloatVariableInfo(data);
                    break;
                }
                case 3: {
                    this.fTypes[i] = new DGDoubleVariableInfo(data);
                    break;
                }
                case 4: {
                    this.fTypes[i] = new DGLongVariableInfo(data);
                    break;
                }
                case 5: {
                    this.fTypes[i] = new DGNullVariableInfo(data);
                    break;
                }
                case 6: {
                    this.fTypes[i] = new DGUninitializedThisVariableInfo(data);
                    break;
                }
                case 7: {
                    this.fTypes[i] = new DGObjectVariableInfo(data);
                    break;
                }
                case 8: {
                    this.fTypes[i] = new DGUninitializedVariableInfo(data);
                    break;
                }
            }
            ++i;
        }
    }

    public DGVerificationTypeInfoArray(int count) {
        this.fTypes = new DGVerificationTypeInfo[count];
        int i = 0;
        while (i < count) {
            this.fTypes[i] = new DGTopVariableInfo();
            ++i;
        }
    }

    public DGVerificationTypeInfoArray(DGVerificationTypeInfoArray types1, DGVerificationTypeInfoArray types2) {
        this.fTypes = new DGVerificationTypeInfo[types1.getNumElements() + types2.getNumElements()];
        System.arraycopy(types1.fTypes, 0, this.fTypes, 0, types1.getNumElements());
        System.arraycopy(types2.fTypes, 0, this.fTypes, types1.getNumElements(), types2.getNumElements());
    }

    public DGVerificationTypeInfoArray(DGVerificationTypeInfoArray types, int numToChop) {
        int newSize = types.getNumElements() - numToChop;
        if (newSize < 0) {
            newSize = 0;
        }
        this.fTypes = new DGVerificationTypeInfo[newSize];
        System.arraycopy(types.fTypes, 0, this.fTypes, 0, newSize);
    }

    public DGVerificationTypeInfoArray(DGVerificationTypeInfo info) {
        this.fTypes = new DGVerificationTypeInfo[1];
        this.fTypes[0] = info;
    }

    public String toString() {
        StringBuffer result = new StringBuffer("[");
        int i = 0;
        while (i < this.fTypes.length) {
            if (i != 0) {
                result.append(", ");
            }
            result.append(this.fTypes[i]);
            ++i;
        }
        result.append("]");
        return result.toString();
    }

    public void write(DataOutputStream out) throws IOException {
        int i = 0;
        while (i < this.fTypes.length) {
            this.fTypes[i].write(out);
            ++i;
        }
    }

    public int size() {
        int len = 0;
        int i = 0;
        while (i < this.fTypes.length) {
            len += this.fTypes[i].size();
            ++i;
        }
        return len;
    }

    public DGVerificationTypeInfo getTypeInfo(int slot) {
        return this.fTypes[this.getIndexForSlot(slot)];
    }

    public void setTypeInfo(int index, byte infoType, int arg) {
        switch (infoType) {
            case 0: {
                this.fTypes[index] = new DGTopVariableInfo();
                break;
            }
            case 1: {
                this.fTypes[index] = new DGIntegerVariableInfo();
                break;
            }
            case 2: {
                this.fTypes[index] = new DGFloatVariableInfo();
                break;
            }
            case 3: {
                this.fTypes[index] = new DGDoubleVariableInfo();
                break;
            }
            case 4: {
                this.fTypes[index] = new DGLongVariableInfo();
                break;
            }
            case 5: {
                this.fTypes[index] = new DGNullVariableInfo();
                break;
            }
            case 6: {
                this.fTypes[index] = new DGUninitializedThisVariableInfo();
                break;
            }
            case 7: {
                this.fTypes[index] = new DGObjectVariableInfo(arg);
                break;
            }
            case 8: {
                this.fTypes[index] = new DGUninitializedVariableInfo(arg);
                break;
            }
        }
    }

    public int getNumElements() {
        return this.fTypes.length;
    }

    public void copyTypeInfo(int dstIdx, DGVerificationTypeInfoArray types, int srcIdx) {
        this.fTypes[dstIdx] = types.fTypes[srcIdx];
    }

    public int getNumSlotsUsed() {
        int slots = 0;
        int i = 0;
        while (i < this.fTypes.length) {
            slots += this.fTypes[i].getNumSlotsUsed();
            ++i;
        }
        return slots;
    }

    public int getIndexForSlot(int slot) {
        int current = 0;
        int index = 0;
        while (index < this.fTypes.length) {
            if (current >= slot) {
                return index;
            }
            current += this.fTypes[index].getNumSlotsUsed();
            ++index;
        }
        return index += slot - current;
    }

    public boolean updateUninitializedVariableOffset(int pc, int delta) {
        boolean dirty = false;
        int index = 0;
        while (index < this.fTypes.length) {
            DGUninitializedVariableInfo uvi;
            int offset;
            if (this.fTypes[index] instanceof DGUninitializedVariableInfo && (offset = (uvi = (DGUninitializedVariableInfo)this.fTypes[index]).getOffset()) >= pc) {
                uvi.setOffset(offset + delta);
                dirty = true;
            }
            ++index;
        }
        return dirty;
    }
}

