/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.personality.java.classfile.constants;

import com.wily.diagnos.cmp.classfile.DGClassLoadingException;
import com.wily.diagnos.personality.java.classfile.constants.DGConstant;
import com.wily.diagnos.personality.java.classfile.constants.DGConstantPool;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class DGMethodHandleConstant
extends DGConstant {
    private int fReferenceKind;
    private int fCPI_referenceIndex;

    protected DGMethodHandleConstant(DGConstantPool constantPool, int tag) {
        super(constantPool, tag);
    }

    public DGMethodHandleConstant(DGConstantPool constantPool, DataInputStream in) throws IOException {
        super(constantPool, 15);
        this.fReferenceKind = in.readUnsignedByte();
        this.fCPI_referenceIndex = in.readUnsignedShort();
    }

    public void validate() throws DGClassLoadingException {
        switch (this.fReferenceKind) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.fPool.validateType(this.fCPI_referenceIndex, 9);
                break;
            }
            case 5: 
            case 8: {
                this.fPool.validateType(this.fCPI_referenceIndex, 10);
                break;
            }
            case 6: 
            case 7: {
                int CFVersion = this.fPool.getDGClass().getMajorVersion();
                if (CFVersion >= 52) {
                    this.fPool.validateType(this.fCPI_referenceIndex, new int[]{10, 11});
                    break;
                }
                this.fPool.validateType(this.fCPI_referenceIndex, 10);
                break;
            }
            case 9: {
                this.fPool.validateType(this.fCPI_referenceIndex, 11);
            }
        }
    }

    public String toString() {
        return "# " + this.fIndex + ": Kind = CONSTANT_MethodHandle (" + this.fTag + ")\n" + "\treference_kind = " + this.fReferenceKind + "\treference_index = " + this.fCPI_referenceIndex;
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeByte(this.fTag);
        out.writeByte(this.fReferenceKind);
        out.writeShort(this.fCPI_referenceIndex);
    }
}

