/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.errors;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.errors.ErrorReportingService;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.agent.trace.ASingleMetricTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.spec.metric.ESEException;
import com.wily.util.properties.AttributeListing;
import com.wily.wilyassert.Assertion;

public class HTTPErrorCodeReporter
extends ASingleMetricTracerFactory {
    public static final int FirstRealHttpError = 400;

    public HTTPErrorCodeReporter(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    public final void ITracer_startTrace(int tracerIndex, InvocationData data) {
    }

    protected IDataAccumulator createDataAccumulator(String formattedMetricName) {
        return null;
    }

    private String buildErrorMessage(InvocationData data) {
        if (!data.hasInvocationParametersAvailable() || data.getInvocationParameterCount() == 0) {
            return null;
        }
        Object firstParam = data.getInvocationParameterAsObject(0);
        if (!(firstParam instanceof Integer)) {
            return null;
        }
        Integer httpErrorCode = (Integer)firstParam;
        if (httpErrorCode < 400) {
            return null;
        }
        StringBuffer answer = new StringBuffer("HTTP Error Code: ");
        answer.append(httpErrorCode.toString());
        if (data.getInvocationParameterCount() >= 2) {
            answer.append(": ");
            answer.append(data.getInvocationParameterAsObject(1).toString());
        }
        return InvocationData.limitSize(answer.toString());
    }

    public final void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        String errorMessage = this.buildErrorMessage(data);
        if (errorMessage != null && ErrorReportingService.flagErrorInManagedApplication(errorMessage)) {
            try {
                this.getAgent().IAgent_getComponentTracer().noteBoundaryError();
                this.getDataAccumulatorFactory().getLongIntervalCounterDataAccumulator(this.getFormattedName()).ILongIntervalCounterDataAccumulator_addSingleIncident();
            }
            catch (ESEException eSEException) {
                Assertion.wilyFail("Metric type conflict");
            }
        }
    }
}

