/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.extension;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.KAgentConstants;
import com.wily.introscope.agent.connection.IsengardServerConnectionManager;
import com.wily.introscope.agent.extension.ExtensionProfileAdministrator;
import com.wily.introscope.agent.extension.IExtensionLocatorPolicy;
import com.wily.introscope.agent.extension.OptionalExtensionsBootLoadConfiguration;
import com.wily.introscope.agent.extension.OptionalExtensionsIncludeConfiguration;
import com.wily.introscope.agent.extension.OptionalExtensionsManager;
import com.wily.introscope.agent.service.IAgentService;
import com.wily.introscope.agent.transformer.dynamic.AInstrumentationHelper;
import com.wily.introscope.agent.util.JavaVersion;
import com.wily.introscope.install.KIntroscopeConfigConstants;
import com.wily.util.ConfigurationWatcher;
import com.wily.util.extension.ExtensionBroker;
import com.wily.util.extension.ExtensionUtilities;
import com.wily.util.extension.IExtension;
import com.wily.util.extension.IExtensionBroker;
import com.wily.util.extension.IExtensionLocator;
import com.wily.util.extension.IPlugin;
import com.wily.util.extension.IPluginFilter;
import com.wily.util.extension.KExtensionConstants;
import com.wily.util.extension.NullExtensionLocator;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.finder.IResourceFinderFeedback;
import com.wily.util.io.ExtendedFile;
import com.wily.util.resource.IResource;
import com.wily.util.text.IStringLocalizer;
import com.wily.wilyassert.Assertion;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExtensionAdministrator {
    private static final String kAgentExtensionType = "Introscope-Agent";
    private static final String kAgentBootExtensionType = "Introscope-Agent-Boot";
    private static final String kServiceBootPluginType = "service boot";
    private static final String kExtensionsProfileAbsentLog = "The agent extensions profile 'Extensions.profile' could not be located. No extensions will be loaded.";
    public static final String kServiceParamExtensionAdministrator = "ExtensionAdministrator";
    private final IAgent fAgent;
    private final IModuleFeedbackChannel fFeedback;
    private final ExtendedFile fAgentExtensionDirectoryCore;
    private final ExtendedFile fAgentExtensionDirectoryOptional;
    private boolean fIsOptionalExtensionsEnabled;
    private boolean fIsOptionalExtensionsDynamic;
    private final IExtensionBroker fBroker;
    private OptionalExtensionsManager fOptionalExtensionsManager;
    private final IExtensionLocatorPolicy fPolicy;
    private final Map fPluginCallbacks = new HashMap();
    private final ConfigurationWatcher fConfigurationWatcher;
    private final IResourceFinderFeedback fResourceFinderfeedback;
    private final IResource fProfileResource;
    private final IResource fOptionalExtensionProfileResource;
    private ExtensionProfileAdministrator fExtensionProfileAdministrator;
    private final IExtension.IExtensionCallback fExtensionCallback = new IExtension.IExtensionCallback(){

        public void onLoad(IExtension e) {
            for (String pluginFilter : ExtensionAdministrator.this.fPluginCallbacks.keySet()) {
                IPlugin[] plugins = e.IExtension_getFilteredPluginList(pluginFilter);
                int i = 0;
                while (i < plugins.length) {
                    plugins[i].IPlugin_setCallback((IPlugin.IPluginCallback)ExtensionAdministrator.this.fPluginCallbacks.get(pluginFilter));
                    ++i;
                }
            }
        }

        public void onUnload(IExtension e) {
        }
    };
    private final IPluginFilter fJavaCompFilter;

    public ExtensionAdministrator(IAgent agent, IExtensionLocatorPolicy policy, ConfigurationWatcher configurationWatcher, IResourceFinderFeedback resourceFinderfeedback, IResource profileResource) {
        Assertion.wilyAssert(false);
        this.fAgent = agent;
        this.fFeedback = this.fAgent.IAgent_getModuleFeedback();
        this.fPolicy = policy;
        this.fConfigurationWatcher = configurationWatcher;
        this.fResourceFinderfeedback = resourceFinderfeedback;
        this.fProfileResource = profileResource;
        this.fAgentExtensionDirectoryCore = this.findExtensionDirectoryPerPropertyKey(agent, "introscope.agent.extensions.directory");
        this.findOptionalExtensionMode();
        if (this.fIsOptionalExtensionsEnabled) {
            this.fAgentExtensionDirectoryOptional = this.findExtensionDirectoryPerPropertyKey(agent, "introscope.agent.extensions.bundles.directory");
            if (this.fAgentExtensionDirectoryOptional != null) {
                this.fOptionalExtensionsManager = new OptionalExtensionsManager(this.fAgent, this.fIsOptionalExtensionsDynamic);
                this.fExtensionProfileAdministrator = new ExtensionProfileAdministrator(this.fAgent, this, this.fConfigurationWatcher, profileResource, this.fPolicy, resourceFinderfeedback);
                this.fOptionalExtensionProfileResource = this.fExtensionProfileAdministrator.getfOptionalExtensionsProfileResource();
            } else {
                this.fIsOptionalExtensionsEnabled = false;
                this.fOptionalExtensionProfileResource = null;
                this.fOptionalExtensionsManager = null;
                this.fExtensionProfileAdministrator = null;
            }
        } else {
            this.fAgentExtensionDirectoryOptional = null;
            this.fOptionalExtensionsManager = null;
            this.fExtensionProfileAdministrator = null;
            this.fOptionalExtensionProfileResource = null;
        }
        this.fJavaCompFilter = new JavaCompatibilityFilter(this.fAgent);
        IExtensionLocator locatorExtCore = this.createExtensionLocator(policy, this.fAgentExtensionDirectoryCore);
        Assertion.wilyAssert(false);
        this.fBroker = AInstrumentationHelper.isValidate() ? new ExtensionBroker(ExtensionAdministrator.class.getClassLoader(), new IExtensionLocator[]{locatorExtCore}, this.getModuleFeedback(), this.getStringLocalizer(), AInstrumentationHelper.getValidationFeedbackChannel(), agent.IAgent_getIndexedProperties()) : new ExtensionBroker(ExtensionAdministrator.class.getClassLoader(), new IExtensionLocator[]{locatorExtCore}, this.getModuleFeedback(), this.getStringLocalizer(), null, agent.IAgent_getIndexedProperties());
        ((ExtensionBroker)this.fBroker).loadExtensions(new String[]{kAgentBootExtensionType, "Eclipse-Plugin"});
        this.loadBootServicePlugins();
        if (this.fIsOptionalExtensionsEnabled && this.fOptionalExtensionProfileResource == null) {
            this.fIsOptionalExtensionsEnabled = false;
            this.getModuleFeedback().error(kExtensionsProfileAbsentLog);
        }
        if (this.fIsOptionalExtensionsEnabled) {
            this.fExtensionProfileAdministrator.initialLoadExtensionProfiles(this.fOptionalExtensionsManager);
        }
    }

    public void initialLoadExtensions() {
        ((ExtensionBroker)this.fBroker).loadExtensions(new String[]{kAgentExtensionType, "Eclipse-Plugin"});
        if (this.fIsOptionalExtensionsEnabled) {
            HashSet<String> extensionsToLoad;
            IExtensionLocator[] locatorExtOptionalArr;
            OptionalExtensionsBootLoadConfiguration.init(this.fAgent);
            OptionalExtensionsIncludeConfiguration.init(this.fAgent, this.fOptionalExtensionsManager);
            if (this.fIsOptionalExtensionsDynamic) {
                this.fOptionalExtensionsManager.start();
            }
            if ((locatorExtOptionalArr = this.createExtensionLocatorOptional(this.fPolicy, this.fAgentExtensionDirectoryOptional, extensionsToLoad = OptionalExtensionsIncludeConfiguration.getIncludedExtensions())) != null && locatorExtOptionalArr.length > 0) {
                ((ExtensionBroker)this.fBroker).loadExtensions(locatorExtOptionalArr, new String[]{kAgentExtensionType, "Eclipse-Plugin"}, this.fExtensionCallback);
                this.fOptionalExtensionsManager.notifyExtensionsLoaded(extensionsToLoad);
            }
        }
        this.logExtensionVersions();
    }

    public ExtensionAdministrator(IAgent agent, IExtensionLocatorPolicy policy) {
        this(agent, policy, null, null, null);
    }

    private final IAgent getAgent() {
        return this.fAgent;
    }

    private final IModuleFeedbackChannel getModuleFeedback() {
        return this.getAgent().IAgent_getModuleFeedback();
    }

    private final IStringLocalizer getStringLocalizer() {
        return this.getAgent().IAgent_getStringLocalizer();
    }

    private final void findOptionalExtensionMode() {
        boolean isInfrastructureAgent;
        String value = (String)this.fAgent.IAgent_getIndexedProperties().get("introscope.agent.extensions.bundles.mode");
        this.fIsOptionalExtensionsEnabled = false;
        this.fIsOptionalExtensionsDynamic = false;
        if ("off".equalsIgnoreCase(value)) {
            this.fFeedback.info("Agent property introscope.agent.extensions.bundles.mode set at off");
            return;
        }
        if (!(value == null || value.equalsIgnoreCase("dynamic") || value.equalsIgnoreCase("controlled") || value.equalsIgnoreCase("off"))) {
            this.fFeedback.warn("Agent property introscope.agent.extensions.bundles.mode has invalid value " + value + ". Using default value " + "off");
            this.fAgent.IAgent_getIndexedProperties().setProperty("introscope.agent.extensions.bundles.mode", "off");
            return;
        }
        if ("controlled".equalsIgnoreCase(value)) {
            this.fIsOptionalExtensionsEnabled = true;
            this.fIsOptionalExtensionsDynamic = false;
            this.fFeedback.info("Agent property introscope.agent.extensions.bundles.mode set at controlled");
            return;
        }
        if ("dynamic".equalsIgnoreCase(value)) {
            this.fIsOptionalExtensionsEnabled = true;
            this.fIsOptionalExtensionsDynamic = true;
        }
        boolean diEnabled = this.fAgent.IAgent_getIndexedProperties().getBooleanProperty("introscope.autoprobe.dynamicinstrument.enabled");
        boolean bl = isInfrastructureAgent = this.fAgent.IAgent_getType() == KAgentConstants.EAgentType.InfrastructureAgent;
        if (!isInfrastructureAgent && this.fIsOptionalExtensionsEnabled && this.fIsOptionalExtensionsDynamic) {
            if (!diEnabled) {
                this.fFeedback.warn("Agent property introscope.autoprobe.dynamicinstrument.enabled is set to false, which disables dynamic extension loading feature.");
                this.fFeedback.warn("Agent property introscope.agent.extensions.bundles.mode is set to controlled");
                this.fAgent.IAgent_getIndexedProperties().setProperty("introscope.agent.extensions.bundles.mode", "controlled");
                this.fIsOptionalExtensionsEnabled = true;
                this.fIsOptionalExtensionsDynamic = false;
            } else {
                this.fFeedback.info("Agent property introscope.agent.extensions.bundles.mode set at dynamic");
            }
        }
    }

    private final ExtendedFile findExtensionDirectoryPerPropertyKey(IAgent agent, String kAgentExtensionDirectoryPropertyKey) {
        this.getModuleFeedback().info(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Extension_Looking_For_Directory_Key", kAgentExtensionDirectoryPropertyKey));
        String directoryProperty = (String)agent.IAgent_getIndexedProperties().get(kAgentExtensionDirectoryPropertyKey);
        if (directoryProperty == null || directoryProperty.equals("")) {
            if (kAgentExtensionDirectoryPropertyKey.equalsIgnoreCase("introscope.agent.extensions.bundles.directory")) {
                directoryProperty = KIntroscopeConfigConstants.kAgentOptionalExtensionDirectoryPropertyKeyDefaultValue;
            } else {
                this.getModuleFeedback().info(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Extension_Property_Not_Configured", kAgentExtensionDirectoryPropertyKey));
                return null;
            }
        }
        return this.findExtensionDirectory(agent, directoryProperty);
    }

    private final ExtendedFile findExtensionDirectory(IAgent agent, String directoryProperty) {
        ExtendedFile extensionDirectory = null;
        if (ExtendedFile.isAbsolutePath(directoryProperty)) {
            extensionDirectory = new ExtendedFile(directoryProperty);
        } else {
            IResource resource = agent.IAgent_getConfigurationResource();
            Assertion.wilyAssert(false);
            if (resource != null) {
                if (resource.IResource_isFileResource()) {
                    extensionDirectory = new ExtendedFile(new File(resource.IResource_getLocation()).getParent(), directoryProperty);
                } else {
                    this.getModuleFeedback().error(this.getStringLocalizer().IStringLocalizer_getLocalizedString("Agent_Extension_Cannot_Use_Relative_Path_For_System_Resource"));
                }
            }
        }
        if (extensionDirectory != null && !extensionDirectory.exists()) {
            this.getModuleFeedback().error(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Extension_Directory_Not_Found", extensionDirectory.safeGetCanonicalPath()));
            extensionDirectory = null;
        }
        if (extensionDirectory != null && !extensionDirectory.isDirectory()) {
            this.getModuleFeedback().error(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Extension_Directory_Not_A_Directory", extensionDirectory.safeGetCanonicalPath()));
            extensionDirectory = null;
        }
        if (extensionDirectory != null) {
            this.getModuleFeedback().info(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Extension_Directory_Found", extensionDirectory.safeGetCanonicalPath()));
        }
        return extensionDirectory;
    }

    private final IExtensionLocator createExtensionLocator(IExtensionLocatorPolicy policy, ExtendedFile extensionDirectory) {
        IExtensionLocator locator = null;
        locator = extensionDirectory != null ? policy.createExtensionLocator(this.getModuleFeedback(), this.getStringLocalizer(), extensionDirectory) : new NullExtensionLocator();
        return locator;
    }

    private final String getAttribute(IExtension extension, String attributeName, String defaultValue) {
        String result = extension.IExtension_getAttributes().getValue(attributeName);
        return result == null ? defaultValue : result;
    }

    private final void logExtensionVersions() {
        IExtension[] extensions = this.fBroker.IExtensionBroker_getFilteredExtensionList(kAgentExtensionType);
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            String extensionName = extension.IExtension_getName();
            String releaseString = this.getAttribute(extension, "com-wily-Release", "<Unknown Release>");
            String buildString = this.getAttribute(extension, "com-wily-Build", "<Unknown Build>");
            this.getModuleFeedback().verbose(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Extension_Release_And_Build", extensionName, releaseString, buildString));
            ++i;
        }
    }

    public final ExtendedFile getAgentExtensionDirectory() {
        return this.fAgentExtensionDirectoryCore;
    }

    public final boolean isOptionalExtensionsModeDynamic() {
        return this.fIsOptionalExtensionsDynamic;
    }

    public final IPlugin[] getAgentPluginsByType(String pluginType) {
        IPlugin[] plugins = this.fBroker.IExtensionBroker_getFilteredPluginList(kAgentExtensionType, pluginType);
        return this.filterNonCompatiblePlugins(plugins);
    }

    public final IPlugin[] getAgentBootPluginsByType(String pluginType) {
        IPlugin[] plugins = this.fBroker.IExtensionBroker_getFilteredPluginList(kAgentBootExtensionType, pluginType);
        return this.filterNonCompatiblePlugins(plugins);
    }

    public final void setGlobalPluginCallbackByType(String pluginType, IPlugin.IPluginCallback cb) {
        this.fPluginCallbacks.put(pluginType, cb);
    }

    public void registerExtensionClassloaders(final IsengardServerConnectionManager serverConn) {
        IExtension[] extensions = this.fBroker.IExtensionBroker_getFilteredExtensionList(kAgentExtensionType);
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            String key = extension.IExtension_getClassloaderKey();
            if (key != null && key.length() > 0) {
                serverConn.registerClassloader(key, extension.IExtension_getClassLoader());
                extension.IExtension_setCallback(new IExtension.IExtensionCallback(){

                    public void onUnload(IExtension e) {
                        serverConn.unregisterClassloader(e.IExtension_getClassloaderKey());
                    }

                    public void onLoad(IExtension e) {
                    }
                });
            }
            ++i;
        }
    }

    public void unloadExtensions(HashSet<String> extensionsToUnload) {
        IExtension[] extensions = this.fBroker.IExtensionBroker_getFilteredExtensionList(kAgentExtensionType);
        ArrayList<String> extensionNames = new ArrayList<String>();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            String location = extension.IExtension_getSource();
            for (String dirName : extensionsToUnload) {
                if (!location.contains("extensions" + File.separator + dirName + File.separator + "lib")) continue;
                extensionNames.add(extension.IExtension_getName());
            }
            ++i;
        }
        ((ExtensionBroker)this.fBroker).unloadExtensions(extensionNames.toArray(new String[0]));
    }

    public void loadExtensions(HashSet<String> extensionsToLoad) {
        IExtensionLocator[] locators = this.createExtensionLocatorOptional(this.fPolicy, this.fAgentExtensionDirectoryOptional, extensionsToLoad);
        if (locators == null || locators.length == 0) {
            return;
        }
        ((ExtensionBroker)this.fBroker).loadExtensions(locators, new String[]{kAgentExtensionType}, this.fExtensionCallback);
    }

    public IExtensionLocator[] createExtensionLocatorOptional(IExtensionLocatorPolicy policy, ExtendedFile fAgentExtensionDirectoryOptional, Set<String> effectiveIncludedExtensions) {
        ArrayList<IExtensionLocator> locators = null;
        if (fAgentExtensionDirectoryOptional != null && fAgentExtensionDirectoryOptional.isDirectory()) {
            FilenameFilter filterOnlyExtensions = new FilenameFilter(){

                public boolean accept(File fAgentExtensionDirectoryOptional, String name) {
                    return !name.equalsIgnoreCase("Extensions.profile");
                }
            };
            List<File> optionalExtDirs = Arrays.asList(fAgentExtensionDirectoryOptional.listFiles(filterOnlyExtensions));
            locators = new ArrayList<IExtensionLocator>();
            for (File optionalExtDir : optionalExtDirs) {
                if (!effectiveIncludedExtensions.contains(optionalExtDir.getName())) continue;
                String optionalExtDirPath = String.valueOf(optionalExtDir.getAbsolutePath()) + File.separator + "lib";
                ExtendedFile optionalExtDirFile = null;
                if (new File(optionalExtDirPath).isDirectory()) {
                    optionalExtDirFile = new ExtendedFile(optionalExtDirPath);
                }
                locators.add(this.createExtensionLocator(policy, optionalExtDirFile));
            }
        }
        if (locators != null && locators.size() > 0) {
            return locators.toArray(new IExtensionLocator[locators.size()]);
        }
        return null;
    }

    public IExtensionLocator[] createExtensionLocatorAllArr(IExtensionLocator locatorExtCore, IExtensionLocator[] locatorExtOptionalArr) {
        IExtensionLocator[] locatorExtAllArr = null;
        if (locatorExtOptionalArr != null) {
            locatorExtAllArr = new IExtensionLocator[locatorExtOptionalArr.length + 1];
            int i = 1;
            while (i < locatorExtAllArr.length) {
                locatorExtAllArr[i] = locatorExtOptionalArr[i - 1];
                ++i;
            }
        } else {
            locatorExtAllArr = new IExtensionLocator[]{locatorExtCore};
        }
        return locatorExtAllArr;
    }

    public ConfigurationWatcher getConfigurationWatcher() {
        return this.fConfigurationWatcher;
    }

    public IResourceFinderFeedback getResourceFinderfeedback() {
        return this.fResourceFinderfeedback;
    }

    public IResource getProfileResource() {
        return this.fProfileResource;
    }

    public IResource getOptionalExtensionProfileResource() {
        return this.fOptionalExtensionProfileResource;
    }

    public ExtensionProfileAdministrator getExensionProfileAdministrator() {
        return this.fExtensionProfileAdministrator;
    }

    public ExtendedFile getOptionalExtensionDirectory() {
        return this.fAgentExtensionDirectoryOptional;
    }

    public ExtendedFile getExtensionDirectoryFromServiceParameters(Map params) {
        String jarLocation = (String)params.get("com-wily-Extension-Location");
        if (jarLocation != null) {
            ExtendedFile jarFile = new ExtendedFile(jarLocation);
            ExtendedFile extensionDir = new ExtendedFile(jarFile.getParentFile().getParentFile());
            return extensionDir;
        }
        return null;
    }

    public OptionalExtensionsManager getOptionalExtensionManager() {
        return this.fOptionalExtensionsManager;
    }

    private final void loadBootServicePlugins() {
        IPlugin[] plugins = this.getAgentBootPluginsByType(kServiceBootPluginType);
        int i = 0;
        while (i < plugins.length) {
            IPlugin plugin = plugins[i];
            try {
                this.loadServiceBootPlugin(plugin);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                try {
                    this.getAgent().IAgent_safeReportError("Exception when loading " + plugin.IPlugin_getName(), t);
                }
                catch (ThreadDeath td2) {
                    throw td2;
                }
                catch (Throwable throwable) {}
            }
            ++i;
        }
    }

    private final void loadServiceBootPlugin(IPlugin plugin) {
        IAgentService service = (IAgentService)ExtensionUtilities.createEntryPointClass(this.fFeedback, this.fAgent.IAgent_getStringLocalizer(), plugin, 2, IAgentService.class);
        if (service != null) {
            try {
                int actualVersion = service.IAgentService_getServiceVersion();
                if (actualVersion == 2) {
                    Map props = plugin.IPlugin_getAttributes().newMap();
                    props.put(kServiceParamExtensionAdministrator, this);
                    service.IAgentService_startService(this.fAgent, props);
                    this.fFeedback.verbose(this.fAgent.IAgent_getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Service_Plugin_Registered_Message", plugin.IPlugin_getOwningExtension().IExtension_getName(), plugin.IPlugin_getName()));
                } else {
                    this.fFeedback.error(this.fAgent.IAgent_getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Service_Version_Mismatch_Error_Message", service.getClass().getName(), plugin.IPlugin_getName(), String.valueOf(2), String.valueOf(actualVersion)));
                }
            }
            catch (Throwable t) {
                this.fFeedback.error(this.fAgent.IAgent_getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Service_Initialization_Error_Message", service.getClass().getName(), plugin.IPlugin_getName()));
                this.fFeedback.verbose(t);
            }
        }
    }

    private IPlugin[] filterNonCompatiblePlugins(IPlugin[] plugins) {
        boolean found = false;
        ArrayList<IPlugin> bag = new ArrayList<IPlugin>();
        int i = 0;
        while (i < plugins.length) {
            IPlugin plugin = plugins[i];
            if (this.fJavaCompFilter.apply(plugin)) {
                bag.add(plugin);
            } else {
                found = true;
                String versionExpr = plugin.IPlugin_getAttributes().getValue("Java-Version-Compatibility");
                this.getModuleFeedback().warn(String.format("Skipped loading plugin: %s as it requires java version: %s, Current java version: %s", plugin.IPlugin_getName(), versionExpr, JavaVersion.CURRENT.getVersion()));
            }
            ++i;
        }
        return found ? bag.toArray(KExtensionConstants.kZeroLengthPluginArray) : plugins;
    }

    private class JavaCompatibilityFilter
    implements IPluginFilter {
        private final boolean shouldCheckJavaCompatibility;

        JavaCompatibilityFilter(IAgent agent) {
            this.shouldCheckJavaCompatibility = agent.IAgent_getIndexedProperties().getBooleanProperty("introscope.agent.plugin.java.compatibility.check.enabled", true);
        }

        public boolean apply(IPlugin plugin) {
            if (this.shouldCheckJavaCompatibility && plugin.IPlugin_getAttributes().containsKey("Java-Version-Compatibility")) {
                String versionExpr = plugin.IPlugin_getAttributes().getValue("Java-Version-Compatibility");
                return versionExpr == null || JavaVersion.CURRENT.satisfies(versionExpr);
            }
            return true;
        }
    }
}

