/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.nio;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.ABundledTracerFactory;
import com.wily.introscope.agent.trace.ITracer;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.trace.nio.DatagramChannelMap;
import com.wily.util.properties.AttributeListing;
import com.wily.wilyassert.Assertion;
import java.net.InetSocketAddress;
import java.nio.channels.DatagramChannel;

public final class DatagramMappingTracer
extends ABundledTracerFactory
implements ITracer {
    private static final String kAddressParameterIndexKey = "addressparameterindex";
    private final ReentrancyLevel fReentrancyLevel = this.calculateReentrancyLevel(ReentrancyLevel.kNone);
    private final int addressParamIndex = this.getIntegerParameter("addressparameterindex", 0);

    public DatagramMappingTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    @Override
    public final ITracer ITracerFactory_allocateTracer(int tracerIndex, InvocationData data) {
        if (data.isSocketClamped()) {
            return null;
        }
        Object invocationObject = data.getInvocationObject();
        if (invocationObject instanceof DatagramChannel && data.hasInvocationParametersAvailable() && data.getInvocationParameterAsObject(this.addressParamIndex) instanceof InetSocketAddress) {
            DatagramChannel channel = (DatagramChannel)data.getInvocationObject();
            InetSocketAddress remoteAddress = (InetSocketAddress)data.getInvocationParameterAsObject(this.addressParamIndex);
            DatagramChannelMap.put(channel, remoteAddress, this.getNameParameter(), remoteAddress, true);
            return this;
        }
        Assertion.wilyAssert("Instrumentation error: instrumented object is not a DatagramChannel or does not have parameter " + this.addressParamIndex + " of type InetSocketAddress");
        return null;
    }

    @Override
    public final void ITracer_startTrace(int tracerIndex, InvocationData data) {
    }

    @Override
    public final void ITracer_finishTrace(int tracerIndex, InvocationData data) {
    }

    @Override
    public final void ITracerFactory_releaseTracer(int tracerIndex, ITracer tracer) {
    }

    @Override
    public final ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return this.fReentrancyLevel;
    }

    @Override
    public final boolean ITracerFactory_isShutoff() {
        return false;
    }
}

